/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.util.JIDUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;

public abstract class RepositoryAccess {
    private static final Logger log = Logger.getLogger("tigase.xmpp.RepositoryAccess");
    protected static final String NOT_AUTHORIZED_MSG = "Session has not been yet authorised.";
    protected static final String NO_ACCESS_TO_REP_MSG = "Can not access user repository.";
    private static final String ANONYMOUS_MECH = "ANONYMOUS";
    private UserRepository repo = null;
    private UserAuthRepository authRepo = null;
    private Authorization authState = Authorization.NOT_AUTHORIZED;
    private boolean anon_allowed = false;
    private boolean is_anonymous = false;

    public RepositoryAccess(UserRepository rep, UserAuthRepository auth, boolean anon_allowed) {
        this.repo = rep;
        this.authRepo = auth;
        this.anon_allowed = anon_allowed;
    }

    public abstract String getUserId() throws NotAuthorizedException;

    public abstract String getUserName() throws NotAuthorizedException;

    public abstract String getDomain();

    public Authorization unregister(String name_param) throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            return Authorization.FORBIDDEN;
        }
        String user_name = JIDUtils.getNodeNick((String)name_param);
        if (user_name == null || user_name.equals("")) {
            user_name = name_param;
        }
        if (this.getUserName().equals(user_name)) {
            try {
                this.authRepo.removeUser(JIDUtils.getNodeID((String)user_name, (String)this.getDomain()));
                return Authorization.AUTHORIZED;
            }
            catch (UserNotFoundException e) {
                return Authorization.REGISTRATION_REQUIRED;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Repository access exception.", e);
                return Authorization.INTERNAL_SERVER_ERROR;
            }
        }
        return Authorization.FORBIDDEN;
    }

    public Authorization register(String name_param, String pass_param, String email_param) throws NotAuthorizedException {
        String user_name = JIDUtils.getNodeNick((String)name_param);
        if (user_name == null || user_name.equals("")) {
            user_name = name_param;
        }
        if (this.isAuthorized()) {
            return this.changeRegistration(user_name, pass_param, email_param);
        }
        if (user_name == null || user_name.equals("") || pass_param == null || pass_param.equals("")) {
            return Authorization.NOT_ACCEPTABLE;
        }
        try {
            this.authRepo.addUser(JIDUtils.getNodeID((String)user_name, (String)this.getDomain()), pass_param);
            log.info("User added: " + JIDUtils.getNodeID((String)user_name, (String)this.getDomain()) + ", pass: " + pass_param);
            this.setRegistration(user_name, pass_param, email_param);
            log.info("Registration data set for: " + JIDUtils.getNodeID((String)user_name, (String)this.getDomain()) + ", pass: " + pass_param + ", email: " + email_param);
            return Authorization.AUTHORIZED;
        }
        catch (UserExistsException e) {
            return Authorization.CONFLICT;
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            return Authorization.INTERNAL_SERVER_ERROR;
        }
    }

    private Authorization changeRegistration(String name_param, String pass_param, String email_param) throws NotAuthorizedException {
        if (name_param == null || name_param.equals("") || pass_param == null || pass_param.equals("")) {
            return Authorization.BAD_REQUEST;
        }
        if (this.getUserName().equals(name_param)) {
            this.setRegistration(name_param, pass_param, email_param);
            return Authorization.AUTHORIZED;
        }
        return Authorization.NOT_AUTHORIZED;
    }

    private void setRegistration(String name_param, String pass_param, String email_param) {
        try {
            this.authRepo.updatePassword(JIDUtils.getNodeID((String)name_param, (String)this.getDomain()), pass_param);
            if (email_param != null && !email_param.equals("")) {
                this.repo.setData(JIDUtils.getNodeID((String)name_param, (String)this.getDomain()), "email", email_param);
            }
        }
        catch (UserNotFoundException e) {
            log.log(Level.WARNING, "Problem accessing reposiotry: ", e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
        }
    }

    public final Authorization getAuthState() {
        return this.authState;
    }

    public final boolean isAuthorized() {
        return this.authState == Authorization.AUTHORIZED;
    }

    public Authorization loginPlain(String user, String password) throws NotAuthorizedException, AuthorizationException {
        try {
            if (this.authRepo.plainAuth(JIDUtils.getNodeID((String)user, (String)this.getDomain()), password)) {
                this.authState = Authorization.AUTHORIZED;
            }
            return this.authState;
        }
        catch (UserNotFoundException e) {
            log.info("User not found, authorization failed: " + user);
            throw new NotAuthorizedException("Authorization failed", e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            throw new NotAuthorizedException("Authorization failed", e);
        }
    }

    public boolean isAnonymous() {
        return this.is_anonymous;
    }

    public Authorization loginOther(Map<String, Object> props) throws NotAuthorizedException, AuthorizationException {
        try {
            String mech = (String)props.get("mechanism");
            if (this.anon_allowed && mech != null && mech.equals(ANONYMOUS_MECH)) {
                this.is_anonymous = true;
                props.put("user-id", UUID.randomUUID().toString());
                this.authState = Authorization.AUTHORIZED;
            } else if (this.authRepo.otherAuth(props)) {
                this.authState = Authorization.AUTHORIZED;
            }
            return this.authState;
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException("Authorization failed", e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            throw new NotAuthorizedException("Authorization failed", e);
        }
    }

    public Authorization loginDigest(String user, String digest, String id, String alg) throws NotAuthorizedException, AuthorizationException {
        try {
            if (this.authRepo.digestAuth(JIDUtils.getNodeID((String)user, (String)this.getDomain()), digest, id, alg)) {
                this.authState = Authorization.AUTHORIZED;
            }
            return this.authState;
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException("Authorization failed", e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            throw new NotAuthorizedException("Authorization failed", e);
        }
    }

    public void queryAuth(Map<String, Object> authProps) {
        this.authRepo.queryAuth(authProps);
        if (this.anon_allowed && authProps.get("protocol") == "sasl") {
            String[] auth_mechs = (String[])authProps.get("result");
            auth_mechs = Arrays.copyOf(auth_mechs, auth_mechs.length + 1);
            auth_mechs[auth_mechs.length - 1] = ANONYMOUS_MECH;
        }
    }

    public void logout() throws NotAuthorizedException {
        this.authState = Authorization.NOT_AUTHORIZED;
    }

    public String[] getDataList(String subnode, String key) throws NotAuthorizedException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getDataList(this.getUserId(), subnode, key);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            return null;
        }
    }

    public String getData(String subnode, String key, String def) throws NotAuthorizedException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getData(this.getUserId(), subnode, key, def);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            return null;
        }
    }

    public void setData(String subnode, String key, String value) throws NotAuthorizedException {
        try {
            this.repo.setData(this.getUserId(), subnode, key, value);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
        }
    }

    public void removeData(String subnode, String key) throws NotAuthorizedException {
        try {
            this.repo.removeData(this.getUserId(), subnode, key);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
        }
    }

    public String[] getDataGroups(String subnode) throws NotAuthorizedException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getSubnodes(this.getUserId(), subnode);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            return null;
        }
    }

    public String[] getDataKeys(String subnode) throws NotAuthorizedException {
        if (this.is_anonymous) {
            return null;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            return this.repo.getKeys(this.getUserId(), subnode);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
            return null;
        }
    }

    public void removeDataGroup(String subnode) throws NotAuthorizedException {
        if (this.is_anonymous) {
            return;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            this.repo.removeSubnode(this.getUserId(), subnode);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
        }
    }

    public void setDataList(String subnode, String key, String[] list) throws NotAuthorizedException {
        if (this.is_anonymous) {
            return;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            this.repo.setDataList(this.getUserId(), subnode, key, list);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
        }
    }

    public void addDataList(String subnode, String key, String[] list) throws NotAuthorizedException {
        if (this.is_anonymous) {
            return;
        }
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG);
        }
        try {
            this.repo.addDataList(this.getUserId(), subnode, key, list);
        }
        catch (UserNotFoundException e) {
            log.log(Level.FINEST, "Problem accessing reposiotry: ", e);
            throw new NotAuthorizedException(NO_ACCESS_TO_REP_MSG, e);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Repository access exception.", e);
        }
    }

    private String calcNode(String base, String subnode) {
        if (subnode == null) {
            return base;
        }
        return base + "/" + subnode;
    }

    public void setPublicDataList(String subnode, String key, String[] list) throws NotAuthorizedException {
        this.setDataList(this.calcNode("public", subnode), key, list);
    }

    public void addPublicDataList(String subnode, String key, String[] list) throws NotAuthorizedException {
        this.addDataList(this.calcNode("public", subnode), key, list);
    }

    public String[] getPublicDataList(String subnode, String key) throws NotAuthorizedException {
        return this.getDataList(this.calcNode("public", subnode), key);
    }

    public void setPublicData(String subnode, String key, String value) throws NotAuthorizedException {
        this.setData(this.calcNode("public", subnode), key, value);
    }

    public String getPublicData(String subnode, String key, String def) throws NotAuthorizedException {
        return this.getData(this.calcNode("public", subnode), key, def);
    }

    public void removePublicData(String subnode, String key) throws NotAuthorizedException {
        this.removeData(this.calcNode("public", subnode), key);
    }

    public void removePublicDataGroup(String subnode) throws NotAuthorizedException {
        this.removeDataGroup(this.calcNode("public", subnode));
    }

    public void setOfflineDataList(String subnode, String key, String[] list) throws NotAuthorizedException {
        this.setDataList(this.calcNode("offline", subnode), key, list);
    }

    public void addOfflineDataList(String subnode, String key, String[] list) throws NotAuthorizedException {
        this.addDataList(this.calcNode("offline", subnode), key, list);
    }

    public String[] getOfflineDataList(String subnode, String key) throws NotAuthorizedException {
        return this.getDataList(this.calcNode("offline", subnode), key);
    }

    public void setOfflineData(String subnode, String key, String value) throws NotAuthorizedException {
        this.setData(this.calcNode("offline", subnode), key, value);
    }

    public String getOfflineData(String subnode, String key, String def) throws NotAuthorizedException {
        return this.getData(this.calcNode("offline", subnode), key, def);
    }

    public void removeOfflineData(String subnode, String key) throws NotAuthorizedException {
        this.removeData(this.calcNode("offline", subnode), key);
    }

    public void removeOfflineDataGroup(String subnode) throws NotAuthorizedException {
        this.removeDataGroup(this.calcNode("offline", subnode));
    }
}

