/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public class PacketFilter {
    private static final Logger log = Logger.getLogger("tigase.server.xmppsession.PacketFilter");

    public boolean preprocess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || !session.isAuthorized()) {
            return false;
        }
        try {
            if (packet.getFrom() != null && packet.getFrom().equals(session.getConnectionId())) {
                String from_jid = session.getJID();
                if (from_jid != null && !from_jid.isEmpty()) {
                    log.finest("Setting correct from attribute: " + from_jid);
                    packet.getElement().setAttribute("from", from_jid);
                } else {
                    log.warning("Session is authenticated but session.getJid() is empty: " + packet.toString());
                }
            }
        }
        catch (NotAuthorizedException e) {
            return false;
        }
        return false;
    }

    public boolean forward(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        return false;
    }

    public boolean process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null) {
            return false;
        }
        log.finest("Processing packet: " + packet.toString());
        try {
            if (packet.getElemTo() == null) {
                if (packet.getElemName().equals("iq") && packet.getType() != null && packet.getType() == StanzaType.result) {
                    return true;
                }
                log.warning("No 'to' address, can't deliver packet: " + packet.getStringData());
                return false;
            }
            String id = null;
            id = JIDUtils.getNodeID((String)packet.getElemTo());
            if (id.equals(session.getUserId())) {
                log.finest("Yes, this is packet to 'this' client: " + id);
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getParentSession().getResourceConnection(packet.getElemTo()).getConnectionId());
                log.finest("Setting to: " + result.getTo());
                result.setFrom(packet.getTo());
                results.offer(result);
                return true;
            }
            id = JIDUtils.getNodeID((String)packet.getElemFrom());
            if (id.equals(session.getUserId())) {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
                return true;
            }
        }
        catch (NotAuthorizedException e) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                log.warning("NotAuthorizedException for packet: " + packet.getStringData());
            }
            catch (PacketErrorTypeException e2) {
                log.warning("Packet processing exception: " + e2);
            }
        }
        return false;
    }
}

