/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionType;
import tigase.net.SocketType;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.stats.StatRecord;
import tigase.util.Algorithms;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPIOService;

public class ServerConnectionManager
extends ConnectionManager<XMPPIOService> {
    private static final Logger log = Logger.getLogger("tigase.server.xmppserver.ServerConnectionManager");
    private static final String DIALBACK_XMLNS = "jabber:server:dialback";
    public static final String HOSTNAMES_PROP_KEY = "hostnames";
    public String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    public static final String MAX_PACKET_WAITING_TIME_PROP_KEY = "max-packet-waiting-time";
    public static final long MAX_PACKET_WAITING_TIME_PROP_VAL = 300000L;
    private String[] hostnames = this.HOSTNAMES_PROP_VAL;
    private long maxPacketWaitingTime = 300000L;
    private Map<String, XMPPIOService> servicesByHost_Type = new HashMap<String, XMPPIOService>();
    private Map<String, XMPPIOService> handshakingByHost_Type = new HashMap<String, XMPPIOService>();
    private Set<String> connectingByHost_Type = new HashSet<String>();
    private Map<String, ServerPacketQueue> waitingPackets = new ConcurrentSkipListMap<String, ServerPacketQueue>();
    private Map<String, ServerPacketQueue> waitingControlPackets = new ConcurrentSkipListMap<String, ServerPacketQueue>();
    private Map<String, Object> sharedSessionData = new ConcurrentSkipListMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPacket(Packet packet) {
        log.finest("Processing packet: " + packet.getStringData());
        if (!packet.isCommand() || !this.processCommand(packet)) {
            if (packet.getElemTo() == null) {
                log.warning("Missing 'to' attribute, ignoring packet..." + packet.toString() + "\n This most likely happens due to missconfiguration of components domain names.");
                return;
            }
            if (packet.getElemFrom() == null) {
                log.warning("Missing 'from' attribute, ignoring packet..." + packet.toString());
                return;
            }
            String to_hostname = JIDUtils.getNodeHost((String)packet.getElemTo());
            if (Arrays.binarySearch(this.hostnames, to_hostname) >= 0) {
                log.finest("Packet addresses to localhost, I am not processing it: " + packet.getStringData());
                try {
                    this.addOutPacket(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "S2S - not delivered", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
                return;
            }
            String cid = this.getConnectionId(packet);
            log.finest("Connection ID is: " + cid);
            Map<String, XMPPIOService> map = this.servicesByHost_Type;
            synchronized (map) {
                XMPPIOService serv = this.servicesByHost_Type.get(cid);
                if (serv == null || !this.writePacketToSocket(serv, packet)) {
                    this.addWaitingPacket(cid, packet, this.waitingPackets);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWaitingPacket(String cid, Packet packet, Map<String, ServerPacketQueue> waitingPacketsMap) {
        Set<String> set = this.connectingByHost_Type;
        synchronized (set) {
            boolean connecting = this.connectingByHost_Type.contains(cid);
            if (!connecting) {
                boolean reconnect;
                String remotehost;
                String localhost = JIDUtils.getNodeNick((String)cid);
                connecting = this.openNewServerConnection(localhost, remotehost = JIDUtils.getNodeHost((String)cid), reconnect = packet == null);
                if (connecting) {
                    this.connectingByHost_Type.add(cid);
                } else {
                    waitingPacketsMap.remove(cid);
                    if (packet.getElement().getXMLNS() == null || !packet.getElement().getXMLNS().equals(DIALBACK_XMLNS)) {
                        try {
                            this.addOutPacket(Authorization.REMOTE_SERVER_NOT_FOUND.getResponseMessage(packet, "S2S - destination host not found", true));
                        }
                        catch (PacketErrorTypeException e) {
                            log.warning("Packet processing exception: " + e);
                        }
                    }
                }
            }
            if (connecting && packet != null) {
                ServerPacketQueue queue = waitingPacketsMap.get(cid);
                if (queue == null) {
                    queue = new ServerPacketQueue();
                    waitingPacketsMap.put(cid, queue);
                }
                queue.offer(packet);
            }
        }
    }

    private boolean openNewServerConnection(String localhost, String remotehost, boolean reconnect) {
        try {
            String ipAddress = DNSResolver.getHostSRV_IP((String)remotehost);
            TreeMap<String, Object> port_props = new TreeMap<String, Object>();
            port_props.put("remote-ip", ipAddress);
            port_props.put("local-hostname", localhost);
            port_props.put("remote-hostname", remotehost);
            port_props.put("ifc", new String[]{ipAddress});
            port_props.put("socket", (Object)SocketType.plain);
            port_props.put("type", (Object)ConnectionType.connect);
            port_props.put("port-no", 5269);
            String cid = this.getConnectionId(localhost, remotehost, ConnectionType.connect);
            port_props.put("cid", cid);
            log.finest("STARTING new connection: " + cid);
            if (reconnect) {
                this.reconnectService(port_props, 15000L);
            } else {
                this.startService(port_props);
            }
            return true;
        }
        catch (UnknownHostException e) {
            log.warning("UnknownHostException for host: " + remotehost);
            return false;
        }
    }

    private String getConnectionId(String localhost, String remotehost, ConnectionType connection) {
        return JIDUtils.getJID((String)localhost, (String)remotehost, (String)connection.toString());
    }

    private String getConnectionId(Packet packet) {
        return JIDUtils.getJID((String)JIDUtils.getNodeHost((String)packet.getElemFrom()), (String)JIDUtils.getNodeHost((String)packet.getElemTo()), (String)ConnectionType.connect.toString());
    }

    private String getConnectionId(XMPPIOService service) {
        String local_hostname = (String)service.getSessionData().get("local-hostname");
        String remote_hostname = (String)service.getSessionData().get("remote-hostname");
        String cid = this.getConnectionId(local_hostname, remote_hostname != null ? remote_hostname : "NULL", service.connectionType());
        return cid;
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService serv) {
        Queue<Packet> packets = serv.getReceivedPackets();
        Packet p = null;
        while ((p = packets.poll()) != null) {
            log.finest("Processing socket data: " + p.getStringData());
            if (p.getElement().getXMLNS() != null && p.getElement().getXMLNS().equals(DIALBACK_XMLNS)) {
                LinkedList<Packet> results = new LinkedList<Packet>();
                this.processDialback(p, serv, results);
                for (Packet res : results) {
                    String cid = res.getTo();
                    log.finest("Sending dialback result: " + res.getStringData() + " to " + cid);
                    XMPPIOService sender = this.handshakingByHost_Type.get(cid);
                    if (sender == null) {
                        sender = this.servicesByHost_Type.get(cid);
                    }
                    log.finest("cid: " + cid + ", writing packet to socket: " + res.getStringData());
                    if (sender != null && this.writePacketToSocket(sender, res)) continue;
                    this.addWaitingPacket(cid, res, this.waitingControlPackets);
                }
                continue;
            }
            if (p.getElemName().equals("error")) {
                this.processStreamError(p, serv);
                return null;
            }
            if (this.checkPacket(p, serv)) {
                log.finest("Adding packet out: " + p.getStringData());
                this.addOutPacket(p);
                continue;
            }
            return null;
        }
        return null;
    }

    private void bouncePacketsBack(Authorization author, String cid) {
        Queue waiting = this.waitingPackets.remove(cid);
        if (waiting != null) {
            Packet p = null;
            while ((p = (Packet)waiting.poll()) != null) {
                log.finest("Sending packet back: " + p.getStringData());
                try {
                    this.addOutPacket(author.getResponseMessage(p, "S2S - not delivered", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
            }
        }
    }

    private void processStreamError(Packet packet, XMPPIOService serv) {
        Authorization author = Authorization.RECIPIENT_UNAVAILABLE;
        if (packet.getElement().getChild("host-unknown") != null) {
            author = Authorization.REMOTE_SERVER_NOT_FOUND;
        }
        String cid = this.getConnectionId(serv);
        this.bouncePacketsBack(author, cid);
        serv.stop();
    }

    private boolean checkPacket(Packet packet, XMPPIOService serv) {
        String packet_from = packet.getElemFrom();
        String packet_to = packet.getElemTo();
        if (packet_from == null || packet_to == null) {
            this.generateStreamError("improper-addressing", serv);
            return false;
        }
        String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
        if (!JIDUtils.getNodeHost((String)packet_from).equals(remote_hostname)) {
            this.generateStreamError("invalid-from", serv);
            return false;
        }
        String local_hostname = (String)serv.getSessionData().get("local-hostname");
        if (!JIDUtils.getNodeHost((String)packet_to).equals(local_hostname)) {
            this.generateStreamError("host-unknown", serv);
            return false;
        }
        return true;
    }

    private boolean processCommand(Packet packet) {
        switch (packet.getCommand()) {
            case STARTTLS: {
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                break;
            }
        }
        return false;
    }

    @Override
    public String xmppStreamOpened(XMPPIOService serv, Map<String, String> attribs) {
        log.finer("Stream opened: " + attribs.toString());
        switch (serv.connectionType()) {
            case connect: {
                String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                String local_hostname = (String)serv.getSessionData().get("local-hostname");
                String cid = this.getConnectionId(local_hostname, remote_hostname, ConnectionType.connect);
                log.finest("Stream opened for: " + cid);
                this.handshakingByHost_Type.put(cid, serv);
                String remote_id = attribs.get("id");
                this.sharedSessionData.put(cid + "-session-id", remote_id);
                String uuid = UUID.randomUUID().toString();
                String key = null;
                try {
                    key = Algorithms.hexDigest((String)remote_id, (String)uuid, (String)"SHA");
                }
                catch (NoSuchAlgorithmException e) {
                    key = uuid;
                }
                this.sharedSessionData.put(cid + "-dialback-key", key);
                Element elem = new Element("db:result", key);
                elem.addAttribute("to", remote_hostname);
                elem.addAttribute("from", local_hostname);
                elem.addAttribute("xmlns:db", DIALBACK_XMLNS);
                StringBuilder sb = new StringBuilder();
                Packet p = null;
                Queue waiting = this.waitingControlPackets.get(cid);
                if (waiting != null) {
                    while ((p = (Packet)waiting.poll()) != null) {
                        log.finest("Sending packet: " + p.getStringData());
                        sb.append(p.getStringData());
                    }
                }
                sb.append(elem.toString());
                log.finest("cid: " + (String)serv.getSessionData().get("cid") + ", sending: " + sb.toString());
                return sb.toString();
            }
            case accept: {
                String remote_hostname = (String)serv.getSessionData().get("remote-hostname");
                String local_hostname = (String)serv.getSessionData().get("local-hostname");
                String cid = this.getConnectionId(local_hostname != null ? local_hostname : "NULL", remote_hostname != null ? remote_hostname : "NULL", ConnectionType.accept);
                log.finest("Stream opened for: " + cid);
                if (remote_hostname != null) {
                    log.fine("Opening stream for already established connection...., trying to turn on TLS????");
                }
                String id = UUID.randomUUID().toString();
                serv.getSessionData().put("sessionID", id);
                return "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback' id='" + id + "'" + ">";
            }
        }
        log.severe("Warning, program shouldn't reach that point.");
        return null;
    }

    @Override
    public void xmppStreamClosed(XMPPIOService serv) {
        log.finer("Stream closed: " + this.getConnectionId(serv));
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String ext_comp;
            if (!entry.getKey().startsWith("--ext-comp") || (ext_comp = (String)entry.getValue()) == null) continue;
            String[] comp_params = ext_comp.split(",");
            this.HOSTNAMES_PROP_VAL = Arrays.copyOf(this.HOSTNAMES_PROP_VAL, this.HOSTNAMES_PROP_VAL.length + 1);
            this.HOSTNAMES_PROP_VAL[this.HOSTNAMES_PROP_VAL.length - 1] = comp_params[1];
        }
        this.hostnames = this.HOSTNAMES_PROP_VAL;
        props.put(HOSTNAMES_PROP_KEY, this.HOSTNAMES_PROP_VAL);
        props.put(MAX_PACKET_WAITING_TIME_PROP_KEY, 300000L);
        return props;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5269};
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.hostnames = (String[])props.get(HOSTNAMES_PROP_KEY);
        if (this.hostnames == null || this.hostnames.length == 0) {
            log.warning("Hostnames definition is empty, setting 'localhost'");
            this.hostnames = new String[]{"localhost"};
        }
        Arrays.sort(this.hostnames);
        this.addRouting("*");
        this.maxPacketWaitingTime = (Long)props.get(MAX_PACKET_WAITING_TIME_PROP_KEY);
    }

    @Override
    public void serviceStarted(XMPPIOService serv) {
        super.serviceStarted(serv);
        log.finest("s2s connection opened: " + serv.getRemoteAddress() + ", type: " + serv.connectionType().toString() + ", id=" + serv.getUniqueId());
        switch (serv.connectionType()) {
            case connect: {
                String data = "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' xmlns:db='jabber:server:dialback'>";
                log.finest("cid: " + (String)serv.getSessionData().get("cid") + ", sending: " + data);
                serv.xmppStreamOpen(data);
                break;
            }
        }
    }

    @Override
    public List<StatRecord> getStatistics() {
        List<StatRecord> stats = super.getStatistics();
        stats.add(new StatRecord(this.getName(), "Open s2s connections", "int", this.servicesByHost_Type.size(), Level.INFO));
        int waiting = 0;
        for (ServerPacketQueue q : this.waitingPackets.values()) {
            waiting += q.size();
        }
        stats.add(new StatRecord(this.getName(), "Packets queued", "int", waiting, Level.INFO));
        stats.add(new StatRecord(this.getName(), "Connecting s2s connections", "int", this.connectingByHost_Type.size(), Level.FINE));
        stats.add(new StatRecord(this.getName(), "Handshaking s2s connections", "int", this.handshakingByHost_Type.size(), Level.FINER));
        LinkedList<String> waiting_qs = new LinkedList<String>();
        for (Map.Entry<String, ServerPacketQueue> entry : this.waitingPackets.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            waiting_qs.add(entry.getKey() + ":  " + entry.getValue().size());
        }
        if (waiting_qs.size() > 0) {
            stats.add(new StatRecord(this.getName(), "Packets queued for each connection", waiting_qs, Level.FINER));
        }
        ArrayList<String> all_s2s = new ArrayList<String>(this.servicesByHost_Type.keySet());
        Collections.sort(all_s2s);
        stats.add(new StatRecord(this.getName(), "s2s connections", all_s2s, Level.FINEST));
        return stats;
    }

    @Override
    public void serviceStopped(XMPPIOService service) {
        super.serviceStopped(service);
        String local_hostname = (String)service.getSessionData().get("local-hostname");
        String remote_hostname = (String)service.getSessionData().get("remote-hostname");
        if (remote_hostname == null) {
            log.info("remote-hostname is NULL, local-hostname: " + local_hostname + ", local address: " + service.getLocalAddress() + ", remote address: " + service.getRemoteAddress());
            return;
        }
        String cid = this.getConnectionId(local_hostname, remote_hostname, service.connectionType());
        boolean stopped = false;
        XMPPIOService serv = this.servicesByHost_Type.get(cid);
        if (serv == service) {
            stopped = true;
            this.servicesByHost_Type.remove(cid);
        } else {
            log.info("Stopped non-active service for CID: " + cid);
        }
        serv = this.handshakingByHost_Type.get(cid);
        if (!stopped && serv == service) {
            stopped = true;
            this.handshakingByHost_Type.remove(cid);
            this.connectingByHost_Type.remove(cid);
            this.waitingControlPackets.remove(cid);
        } else if (!stopped) {
            log.info("Stopped non-handshaking service for CID: " + cid);
        }
        if (serv == null && this.connectingByHost_Type.contains(cid)) {
            this.connectingByHost_Type.remove(cid);
            this.waitingControlPackets.remove(cid);
            stopped = true;
        }
        if (!stopped) {
            return;
        }
        log.fine("s2s stopped: " + cid);
        ServerPacketQueue waiting = this.waitingPackets.get(cid);
        if (waiting != null && waiting.size() > 0) {
            if (System.currentTimeMillis() - waiting.creationTime > this.maxPacketWaitingTime) {
                this.bouncePacketsBack(Authorization.REMOTE_SERVER_TIMEOUT, cid);
            } else {
                this.addWaitingPacket(cid, null, this.waitingPackets);
            }
        }
    }

    public void handleDialbackSuccess(String connect_jid) {
        log.finest("handleDialbackSuccess: connect_jid=" + connect_jid);
        Packet p = null;
        XMPPIOService serv = this.servicesByHost_Type.get(connect_jid);
        ServerPacketQueue waiting = this.waitingPackets.remove(connect_jid);
        if (waiting != null) {
            while ((p = (Packet)waiting.poll()) != null) {
                log.finest("Sending packet: " + p.getStringData());
                this.writePacketToSocket(serv, p);
            }
        }
    }

    private void generateStreamError(String error_el, XMPPIOService serv) {
        Element error = new Element("stream:error", new Element[]{new Element(error_el, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-streams"})}, null, null);
        try {
            serv.writeRawData(error.toString());
            serv.writeRawData("</stream:stream>");
            serv.stop();
        }
        catch (Exception e) {
            serv.stop();
        }
    }

    private void initServiceMapping(String local_hostname, String remote_hostname, String cid, XMPPIOService serv) {
        XMPPIOService old_serv;
        XMPPIOService xMPPIOService = old_serv = this.handshakingByHost_Type.get(cid) != null ? this.handshakingByHost_Type.get(cid) : this.servicesByHost_Type.get(cid);
        if (old_serv != serv) {
            serv.getSessionData().put("local-hostname", local_hostname);
            serv.getSessionData().put("remote-hostname", remote_hostname);
            this.handshakingByHost_Type.put(cid, serv);
            if (old_serv != null && old_serv.connectionType() != ConnectionType.accept) {
                log.finest("Stopping old connection for: " + cid);
                old_serv.stop();
            }
        }
    }

    public synchronized void processDialback(Packet packet, XMPPIOService serv, Queue<Packet> results) {
        Element elem;
        log.finest("DIALBACK - " + packet.getStringData());
        String local_hostname = JIDUtils.getNodeHost((String)packet.getElemTo());
        if (Arrays.binarySearch(this.hostnames, local_hostname) < 0) {
            this.generateStreamError("host-unknown", serv);
            return;
        }
        String remote_hostname = JIDUtils.getNodeHost((String)packet.getElemFrom());
        if (Arrays.binarySearch(this.hostnames, remote_hostname) >= 0) {
            this.generateStreamError("host-unknown", serv);
            return;
        }
        String connect_jid = this.getConnectionId(local_hostname, remote_hostname, ConnectionType.connect);
        String accept_jid = this.getConnectionId(local_hostname, remote_hostname, ConnectionType.accept);
        if (packet.getElemName().equals("result")) {
            if (packet.getType() == null) {
                if (packet.getElemCData() != null) {
                    this.sharedSessionData.put(accept_jid + "-session-id", serv.getSessionData().get("sessionID"));
                    this.sharedSessionData.put(accept_jid + "-dialback-key", packet.getElemCData());
                    this.initServiceMapping(local_hostname, remote_hostname, accept_jid, serv);
                    String[] stringArray = new String[4];
                    stringArray[0] = (String)serv.getSessionData().get("sessionID");
                    stringArray[1] = packet.getElemFrom();
                    stringArray[2] = packet.getElemTo();
                    stringArray[3] = DIALBACK_XMLNS;
                    elem = new Element("db:verify", packet.getElemCData(), new String[]{"id", "to", "from", "xmlns:db"}, stringArray);
                    Packet result = new Packet(elem);
                    result.setTo(connect_jid);
                    results.offer(result);
                } else {
                    log.finer("Incorrect diablack packet: " + packet.getStringData());
                    this.bouncePacketsBack(Authorization.SERVICE_UNAVAILABLE, connect_jid);
                    this.generateStreamError("bad-format", serv);
                }
            } else {
                XMPPIOService connect_serv = this.handshakingByHost_Type.get(connect_jid);
                switch (packet.getType()) {
                    case valid: {
                        log.finer("Connection: " + connect_jid + " is valid, adding to available services.");
                        this.servicesByHost_Type.put(connect_jid, connect_serv);
                        this.handshakingByHost_Type.remove(connect_jid);
                        this.connectingByHost_Type.remove(connect_jid);
                        this.waitingControlPackets.remove(connect_jid);
                        this.handleDialbackSuccess(connect_jid);
                        break;
                    }
                    default: {
                        log.finer("Connection: " + connect_jid + " is invalid!! Stopping...");
                        connect_serv.stop();
                    }
                }
            }
        }
        if (packet.getElemName().equals("verify")) {
            if (packet.getType() == null) {
                if (packet.getElemId() != null && packet.getElemCData() != null) {
                    this.initServiceMapping(local_hostname, remote_hostname, accept_jid, serv);
                    String id = packet.getElemId();
                    String key = packet.getElemCData();
                    String local_key = (String)this.sharedSessionData.get(connect_jid + "-dialback-key");
                    log.fine("Local key for cid=" + connect_jid + " is " + local_key);
                    Element result_el = new Element("db:verify", new String[]{"to", "from", "id", "xmlns:db"}, new String[]{packet.getElemFrom(), packet.getElemTo(), packet.getElemId(), DIALBACK_XMLNS});
                    Packet result = new Packet(result_el);
                    if (key.equals(local_key)) {
                        log.finer("Verification for " + accept_jid + " succeeded, sending valid.");
                        result_el.setAttribute("type", "valid");
                    } else {
                        log.finer("Verification for " + accept_jid + " failed, sending invalid.");
                        result_el.setAttribute("type", "invalid");
                    }
                    result.setTo(accept_jid);
                    log.finest("Adding result packet: " + result.getStringData() + " to " + result.getTo());
                    results.offer(result);
                }
            } else {
                elem = new Element("db:result", new String[]{"type", "to", "from", "xmlns:db"}, new String[]{packet.getType().toString(), packet.getElemFrom(), packet.getElemTo(), DIALBACK_XMLNS});
                XMPPIOService accept_serv = this.handshakingByHost_Type.remove(accept_jid);
                if (accept_serv == null) {
                    accept_serv = this.servicesByHost_Type.get(accept_jid);
                } else {
                    this.connectingByHost_Type.remove(accept_jid);
                    this.waitingControlPackets.remove(accept_jid);
                }
                if (accept_serv == null) {
                    log.fine("Connection closed before handshaking completed: " + accept_jid + ", can't send packet: " + elem.toString());
                    return;
                }
                try {
                    accept_serv.writeRawData(elem.toString());
                    switch (packet.getType()) {
                        case valid: {
                            log.finer("Received " + packet.getType().toString() + " validation result, adding connection to active services.");
                            this.servicesByHost_Type.put(accept_jid, accept_serv);
                            break;
                        }
                        default: {
                            log.finer("Received " + packet.getType().toString() + " validation result, stopping service, closing connection.");
                            accept_serv.writeRawData("</stream:stream>");
                            accept_serv.stop();
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    accept_serv.stop();
                }
            }
        }
    }

    @Override
    protected long getMaxInactiveTime() {
        return 900000L;
    }

    @Override
    protected XMPPIOService getXMPPIOServiceInstance() {
        return new XMPPIOService();
    }

    private static class ServerPacketQueue
    extends ConcurrentLinkedQueue<Packet> {
        private static final long serialVersionUID = 1L;
        private long creationTime = System.currentTimeMillis();

        private ServerPacketQueue() {
        }
    }
}

