/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ssender;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.ssender.SenderTask;
import tigase.server.ssender.StanzaHandler;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class StanzaSender
extends AbstractMessageReceiver
implements Configurable,
StanzaHandler {
    private static final String INTERVAL_PROP_KEY = "default-interval";
    private static final long INTERVAL_PROP_VAL = 10L;
    private static final String STANZA_LISTENERS_PROP_KEY = "stanza-listeners";
    private static final String TASK_CLASS_PROP_KEY = "class-name";
    private static final String TASK_INIT_PROP_KEY = "init-string";
    private static final String TASK_INTERVAL_PROP_KEY = "interval";
    private static final String JDBC_TASK_NAME = "jdbc";
    private static final String JDBC_TASK_CLASS = "tigase.server.ssender.JDBCTask";
    private static final String JDBC_TASK_INIT = "jdbc:mysql://localhost/tigase?user=root&password=mypass&table=xmpp_stanza";
    private static final long JDBC_INTERVAL = 10L;
    private static final String DRUPAL_FORUM_TASK_NAME = "drupal-forum";
    private static final String DRUPAL_FORUM_TASK_CLASS = "tigase.server.ssender.DrupalForumTask";
    private static final String DRUPAL_FORUM_TASK_INIT = "drupal_forum:mysql://localhost/tigase?user=root&password=mypass";
    private static final long DRUPAL_FORUM_INTERVAL = 30L;
    private static final String FILE_TASK_NAME = "file";
    private static final String FILE_TASK_CLASS = "tigase.server.ssender.FileTask";
    private static final String FILE_TASK_INIT = File.separator + "var" + File.separator + "spool" + File.separator + "jabber" + File.separator + "*.stanza";
    private static final long FILE_INTERVAL = 10L;
    private static final String[] STANZA_LISTENERS_PROP_VAL = new String[]{"jdbc", "file"};
    private static final String TASK_ACTIVE_PROP_KEY = "active";
    private static final boolean TASK_ACTIVE_PROP_VAL = false;
    private static final Logger log = Logger.getLogger("tigase.server.ssender.StanzaSender");
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private Map<String, SenderTask> tasks_list = new LinkedHashMap<String, SenderTask>();
    private Timer tasks = new Timer("StanzaSender", true);

    @Override
    public void release() {
        super.release();
    }

    @Override
    public void processPacket(Packet packet) {
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String[] config_tasks;
        super.setProperties(props);
        this.addRouting(this.myDomain());
        for (String task_name : config_tasks = (String[])props.get(STANZA_LISTENERS_PROP_KEY)) {
            SenderTask old_task = this.tasks_list.get(task_name);
            if (old_task != null) {
                old_task.cancel();
            }
            if (!((Boolean)props.get(task_name + "/" + TASK_ACTIVE_PROP_KEY)).booleanValue()) continue;
            String task_class = (String)props.get(task_name + "/" + TASK_CLASS_PROP_KEY);
            String task_init = (String)props.get(task_name + "/" + TASK_INIT_PROP_KEY);
            long task_interval = (Long)props.get(task_name + "/" + TASK_INTERVAL_PROP_KEY);
            try {
                SenderTask task = (SenderTask)Class.forName(task_class).newInstance();
                task.setName(task_name + "@" + this.myDomain());
                task.init(this, task_init);
                this.tasks_list.put(task_name, task);
                this.tasks.scheduleAtFixedRate((TimerTask)task, task_interval * 1000L, task_interval * 1000L);
                log.config("Initialized task: " + task_name + ", class: " + task_class + ", init: " + task_init + ", interval: " + task_interval);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not initialize stanza listener: ", e);
            }
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        defs.put(INTERVAL_PROP_KEY, 10L);
        if (((Boolean)params.get("--test")).booleanValue()) {
            defs.put("file/active", true);
        } else {
            defs.put("file/active", false);
        }
        defs.put("file/class-name", FILE_TASK_CLASS);
        defs.put("file/init-string", FILE_TASK_INIT);
        defs.put("file/interval", 10L);
        if (((Boolean)params.get("--test")).booleanValue()) {
            defs.put("jdbc/active", true);
        } else {
            defs.put("jdbc/active", false);
        }
        defs.put("jdbc/class-name", JDBC_TASK_CLASS);
        defs.put("jdbc/init-string", JDBC_TASK_INIT);
        defs.put("jdbc/interval", 10L);
        String repo_uri = DRUPAL_FORUM_TASK_INIT;
        if (params.get("--gen-drupal-db-uri") != null) {
            repo_uri = (String)params.get("--gen-drupal-db-uri");
        } else if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        ArrayList<String> listeners = new ArrayList<String>();
        listeners.addAll(Arrays.asList(STANZA_LISTENERS_PROP_VAL));
        if (params.get("--gen-ssend-forum-task") != null) {
            String[] forum_ids;
            for (String id : forum_ids = ((String)params.get("--gen-ssend-forum-task")).split(",")) {
                String task_name = "drupal-forum-" + id;
                listeners.add(task_name);
                defs.put(task_name + "/" + TASK_ACTIVE_PROP_KEY, true);
                defs.put(task_name + "/" + TASK_CLASS_PROP_KEY, DRUPAL_FORUM_TASK_CLASS);
                defs.put(task_name + "/" + TASK_INTERVAL_PROP_KEY, 30L);
                defs.put(task_name + "/" + TASK_INIT_PROP_KEY, repo_uri + "&forum=" + id + "&jid=forum-" + id + "@srecv." + this.getDefHostName());
            }
        }
        defs.put(STANZA_LISTENERS_PROP_KEY, listeners.toArray(new String[0]));
        return defs;
    }

    @Override
    public void handleStanza(String stanza) {
        this.parseXMLData(stanza);
    }

    @Override
    public void handleStanza(Packet stanza) {
        this.addOutPacket(stanza);
    }

    @Override
    public void handleStanzas(Queue<Packet> results) {
        this.addOutPackets(results);
    }

    private void parseXMLData(String data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        while (elems != null && elems.size() > 0) {
            Packet result = new Packet((Element)elems.poll());
            this.addOutPacket(result);
        }
    }
}

