/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.xml.Element;

public class BoshSessionCache {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshSessionCache");
    public static final String DEF_ID = "";
    public static final String ROSTER_ID = "bosh-roster";
    public static final String RESOURCE_BIND_ID = "bosh-resource-bind";
    private Map<String, List<Element>> id_cache = new LinkedHashMap<String, List<Element>>();
    private Map<String, Element> jid_presence = new LinkedHashMap<String, Element>();

    public void set(String id, List<Element> data) {
        if (id == null) {
            id = DEF_ID;
        }
        ArrayList<Element> cached_data = new ArrayList<Element>();
        this.id_cache.put(id, cached_data);
        cached_data.addAll(data);
        log.finest("SET, id = " + id + ", DATA: " + data.toString());
    }

    public void add(String id, List<Element> data) {
        List<Element> cached_data;
        if (id == null) {
            id = DEF_ID;
        }
        if ((cached_data = this.id_cache.get(id)) == null) {
            cached_data = new ArrayList<Element>();
            this.id_cache.put(id, cached_data);
        }
        cached_data.addAll(data);
        log.finest("ADD, id = " + id + ", DATA: " + data.toString());
    }

    public List<Element> remove(String id) {
        if (id == null) {
            id = DEF_ID;
        }
        List<Element> data = this.id_cache.remove(id);
        log.finest("REMOVED, id = " + id + ", DATA: " + data.toString());
        return data;
    }

    public List<Element> get(String id) {
        if (id == null) {
            id = DEF_ID;
        }
        List<Element> data = this.id_cache.get(id);
        log.finest("GET, id = " + id + ", DATA: " + data.toString());
        return data;
    }

    public List<Element> getAll() {
        ArrayList<Element> result = new ArrayList<Element>();
        for (List<Element> cache_data : this.id_cache.values()) {
            result.addAll(cache_data);
        }
        result.addAll(this.jid_presence.values());
        log.finest("GET_ALL, DATA: " + ((Object)result).toString());
        return result;
    }

    public void addPresence(Element presence) {
        String from = presence.getAttribute("from");
        this.jid_presence.put(from, presence);
        log.finest("ADD_PRESENCE, from = " + from + ", PRESENCE: " + presence.toString());
    }

    public List<Element> getAllPresences() {
        return new ArrayList<Element>(this.jid_presence.values());
    }

    public List<Element> getPresence(String ... from) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (String f : from) {
            Element presence = this.jid_presence.get(f);
            if (presence == null) continue;
            result.add(presence);
        }
        return result;
    }

    public void addRoster(Element roster) {
        this.add(ROSTER_ID, Arrays.asList(roster));
        log.finest("ADD_ROSTER, ROSTER: " + roster.toString());
    }
}

