/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSessionCache;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.bosh.Constants;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class BoshSession {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshSession");
    private static final long SECOND = 1000L;
    private UUID sid = null;
    private Queue<BoshIOService> connections = new ConcurrentLinkedQueue<BoshIOService>();
    private Queue<Element> waiting_packets = new ConcurrentLinkedQueue<Element>();
    private BoshSessionCache cache = null;
    private boolean cache_on = false;
    private BoshSessionTaskHandler handler = null;
    private long max_wait = 30L;
    private long min_polling = 10L;
    private long max_inactivity = 10L;
    private int concurrent_requests = 2;
    private int hold_requests = 1;
    private long max_pause = 10L;
    private String content_type = "text/xml; charset=utf-8";
    private String domain = null;
    private String sessionId = null;
    private long[] current_rids = null;
    private int rids_head = 0;
    private int rids_tail = 0;
    private long previous_received_rid = -1L;
    private boolean terminate = false;
    private Map<TimerTask, TimedTask> task_enum = new LinkedHashMap<TimerTask, TimedTask>();
    private EnumMap<TimedTask, TimerTask> enum_task = new EnumMap(TimedTask.class);
    private Pattern[] links_regexs = new Pattern[]{Pattern.compile("([^>/\";]|^)(www\\.[^ ]+)", 2), Pattern.compile("([^\">;]|^)(http://[^ ]+)", 2)};
    private String[] replace_with = new String[]{"$1&lt;a href=\"http://$2\" target=\"_top\"&gt;$2&lt;/a&gt;", "$1&lt;a href=\"$2\" target=\"_top\"&gt;$2&lt;/a&gt;"};

    public BoshSession(String def_domain, BoshSessionTaskHandler handler) {
        this.sid = UUID.randomUUID();
        this.domain = def_domain;
        this.handler = handler;
    }

    public void init(Packet packet, BoshIOService service, long max_wait, long min_polling, long max_inactivity, int concurrent_requests, int hold_requests, long max_pause, Queue<Packet> out_results) {
        String lang;
        String cache_action = packet.getAttribute("cache");
        if (cache_action != null && cache_action.equals(Constants.CacheAction.on.toString())) {
            this.cache = new BoshSessionCache();
            this.cache_on = true;
            log.fine("BoshSessionCache set to ON");
        }
        this.current_rids = new long[this.concurrent_requests + 1];
        for (int i = 0; i < this.current_rids.length; ++i) {
            this.current_rids[i] = -1L;
        }
        long wait_l = max_wait;
        String wait_s = packet.getAttribute("wait");
        if (wait_s != null) {
            try {
                wait_l = Long.parseLong(wait_s);
            }
            catch (NumberFormatException e) {
                wait_l = max_wait;
            }
        }
        this.max_wait = Math.min(wait_l, max_wait);
        int hold_i = hold_requests;
        String tmp_str = packet.getAttribute("hold");
        if (tmp_str != null) {
            try {
                hold_i = Integer.parseInt(tmp_str);
            }
            catch (NumberFormatException e) {
                hold_i = hold_requests;
            }
        }
        if ((tmp_str = packet.getAttribute("rid")) != null) {
            try {
                this.previous_received_rid = Long.parseLong(tmp_str);
                this.current_rids[this.rids_head++] = this.previous_received_rid;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.hold_requests = Math.max(hold_i, hold_requests);
        if (packet.getAttribute("to") != null) {
            this.domain = packet.getAttribute("to");
        }
        this.min_polling = min_polling;
        this.max_inactivity = max_inactivity;
        this.concurrent_requests = concurrent_requests;
        this.max_pause = max_pause;
        if (packet.getAttribute("content") != null) {
            this.content_type = packet.getAttribute("content");
        }
        if ((lang = packet.getAttribute("xml:lang")) == null) {
            lang = "en";
        }
        service.setContentType(this.content_type);
        Element body = new Element("body", new String[]{"wait", "inactivity", "polling", "requests", "hold", "maxpause", "sid", "ver", "from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{Long.valueOf(this.max_wait).toString(), Long.valueOf(this.max_inactivity).toString(), Long.valueOf(this.min_polling).toString(), Integer.valueOf(this.concurrent_requests).toString(), Integer.valueOf(this.hold_requests).toString(), Long.valueOf(this.max_pause).toString(), this.sid.toString(), "1.6", this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
        this.sessionId = UUID.randomUUID().toString();
        body.setAttribute("authid", this.sessionId);
        if (this.getCurrentRidTail() > 0L) {
            body.setAttribute("ack", "" + this.takeCurrentRidTail());
        }
        body.setXMLNS("http://jabber.org/protocol/httpbind");
        this.sendBody(service, body);
        Packet streamOpen = Command.STREAM_OPENED.getPacket(null, null, StanzaType.set, "sess1", "submit");
        Command.addFieldValue(streamOpen, "session-id", this.sessionId);
        Command.addFieldValue(streamOpen, "hostname", this.domain);
        Command.addFieldValue(streamOpen, "xml:lang", lang);
        out_results.offer(streamOpen);
        out_results.offer(Command.GETFEATURES.getPacket(null, null, StanzaType.get, "sess1", null));
    }

    public UUID getSid() {
        return this.sid;
    }

    public String getDomain() {
        return this.domain;
    }

    public void close() {
        this.terminate = true;
        this.processPacket(null, null);
    }

    public void processPacket(Packet packet, Queue<Packet> out_results) {
        if (packet != null) {
            log.finest("[" + this.connections.size() + "] Processing packet: " + packet.toString());
            this.waiting_packets.offer(packet.getElement());
            if (this.cache_on) {
                this.processAutomaticCache(packet);
            }
        }
        if (this.connections.size() > 0 && (this.waiting_packets.size() > 0 || this.terminate)) {
            BoshIOService serv = this.connections.poll();
            this.sendBody(serv, null);
        }
    }

    private Element applyFilters(Element packet) {
        String body;
        Element result = packet.clone();
        if (result.getName().equals("message") && (body = result.getCData("/message/body")) != null) {
            int count = 0;
            for (Pattern reg : this.links_regexs) {
                body = reg.matcher(body).replaceAll(this.replace_with[count++]);
            }
            result.getChild("body").setCData(body);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentRidTail() {
        long[] lArray = this.current_rids;
        synchronized (this.current_rids) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.current_rids[this.rids_tail];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long takeCurrentRidTail() {
        long[] lArray = this.current_rids;
        synchronized (this.current_rids) {
            int idx = this.rids_tail++;
            if (this.rids_tail >= this.current_rids.length) {
                this.rids_tail = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.current_rids[idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRid(long rid) {
        long[] lArray = this.current_rids;
        synchronized (this.current_rids) {
            if (this.previous_received_rid + 1L != rid) {
                log.info("Incorrect packet order, last_rid=" + this.previous_received_rid + ", current_rid=" + rid);
            }
            this.previous_received_rid = rid;
            this.current_rids[this.rids_head++] = rid;
            if (this.rids_head >= this.current_rids.length) {
                this.rids_head = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDuplicate(long rid) {
        long[] lArray = this.current_rids;
        synchronized (this.current_rids) {
            for (long c_rid : this.current_rids) {
                if (rid != c_rid) continue;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return false;
        }
    }

    private void sendBody(BoshIOService serv, Element body_par) {
        Element body = body_par;
        if (body == null) {
            body = new Element("body", new String[]{"from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
            body.setXMLNS("http://jabber.org/protocol/httpbind");
            long rid = this.takeCurrentRidTail();
            if (rid > 0L) {
                body.setAttribute("ack", "" + rid);
            }
            if (this.waiting_packets.size() > 0) {
                body.addChild(this.applyFilters(this.waiting_packets.poll()));
                while (this.waiting_packets.size() > 0 && body.getChildren().size() < 2) {
                    body.addChild(this.applyFilters(this.waiting_packets.poll()));
                }
            }
        }
        try {
            if (this.terminate) {
                body.setAttribute("type", StanzaType.terminate.toString());
            }
            serv.writeRawData(body.toString());
            serv.stop();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "[" + this.connections.size() + "] Exception during writing to socket", e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "[" + this.connections.size() + "] Exception during writing to socket", e);
        }
        serv.setSid(null);
        this.disconnected(serv);
        TimerTask tt = this.enum_task.remove((Object)TimedTask.EMPTY_RESP);
        if (tt != null) {
            this.task_enum.remove(tt);
            this.handler.cancelTask(tt);
        }
    }

    private void processAutomaticCache(Packet packet) {
        if (packet.getElemName().equals("presence")) {
            this.cache.addPresence(packet.getElement());
        }
        if (packet.isXMLNS("/iq/query", "jabber:iq:roster")) {
            this.cache.addRoster(packet.getElement());
        }
        if (packet.isXMLNS("/iq/bind", "urn:ietf:params:xml:ns:xmpp-bind")) {
            this.cache.set("bosh-resource-bind", Collections.singletonList(packet.getElement()));
        }
    }

    private void processCache(Constants.CacheAction action, Packet packet) {
        List<Element> children = packet.getElemChildren("body");
        String cache_id = packet.getAttribute("cache-id");
        List<Element> cache_res = null;
        switch (action) {
            case on: {
                if (this.cache == null) {
                    this.cache = new BoshSessionCache();
                }
                this.cache_on = true;
                log.fine("BoshSessionCache set to ON");
                break;
            }
            case off: {
                this.cache_on = false;
                log.fine("BoshSessionCache set to OFF");
                break;
            }
            case set: {
                this.cache.set(cache_id, children);
                break;
            }
            case add: {
                this.cache.add(cache_id, children);
                break;
            }
            case get: {
                cache_res = this.cache.get(cache_id);
                break;
            }
            case remove: {
                this.cache.remove(cache_id);
                break;
            }
            case get_all: {
                cache_res = this.cache.getAll();
                break;
            }
            default: {
                log.warning("Unknown cache action: " + action.toString());
            }
        }
        if (cache_res != null) {
            this.waiting_packets.addAll(cache_res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSocketPacket(Packet packet, BoshIOService service, Queue<Packet> out_results) {
        TimerTask tt;
        log.finest("[" + this.connections.size() + "] Processing socket packet: " + packet.toString());
        Map<TimerTask, TimedTask> map = this.task_enum;
        synchronized (map) {
            tt = this.enum_task.remove((Object)TimedTask.STOP);
            if (tt != null) {
                this.task_enum.remove(tt);
                this.handler.cancelTask(tt);
            }
        }
        service.setContentType(this.content_type);
        service.setSid(this.sid);
        this.connections.offer(service);
        if (packet.getElemName().equals("body")) {
            boolean duplicate = false;
            if (packet.getAttribute("rid") != null) {
                try {
                    long rid = Long.parseLong(packet.getAttribute("rid"));
                    service.setRid(rid);
                    duplicate = this.isDuplicate(rid);
                    if (!duplicate) {
                        this.processRid(rid);
                    }
                }
                catch (NumberFormatException e) {
                    log.warning("Incorrect RID value: " + packet.getAttribute("rid"));
                }
            }
            if (!duplicate) {
                if (packet.getType() != null && packet.getType() == StanzaType.terminate) {
                    this.max_inactivity = 2L;
                    this.terminate = true;
                    Packet command2 = Command.STREAM_CLOSED.getPacket(null, null, StanzaType.set, "sess1");
                    out_results.offer(command2);
                }
                if (packet.getAttribute("xmpp:restart") != null && packet.getAttribute("xmpp:restart").equals("true")) {
                    log.fine("Found stream restart instruction: " + packet.toString());
                    out_results.offer(Command.GETFEATURES.getPacket(null, null, StanzaType.get, "restart1", null));
                }
                if (packet.getAttribute("cache") != null) {
                    try {
                        Constants.CacheAction action = Constants.CacheAction.valueOf(packet.getAttribute("cache"));
                        if (this.cache_on || action == Constants.CacheAction.on) {
                            this.processCache(action, packet);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warning("Incorrect cache action: " + packet.getAttribute("cache"));
                    }
                } else {
                    List<Element> children = packet.getElemChildren("body");
                    if (children != null) {
                        for (Element el : children) {
                            if (el.getXMLNS().equals("http://jabber.org/protocol/httpbind")) {
                                el.setXMLNS("jabber:client");
                            }
                            Packet result = new Packet(el);
                            log.finest("Sending out packet: " + result.toString());
                            out_results.offer(result);
                        }
                    }
                }
            } else {
                log.info("Duplicated packet: " + packet.toString());
            }
        } else {
            log.warning("[" + this.connections.size() + "] Unexpected packet from the network: " + packet.toString());
        }
        this.processPacket(null, out_results);
        if (this.connections.size() > this.hold_requests) {
            BoshIOService serv = this.connections.poll();
            this.sendBody(serv, null);
        }
        Map<TimerTask, TimedTask> map2 = this.task_enum;
        synchronized (map2) {
            tt = this.enum_task.get((Object)TimedTask.EMPTY_RESP);
            if (this.connections.size() > 0 && this.waiting_packets.size() == 0 && tt == null) {
                tt = this.handler.scheduleTask(this, this.max_wait * 1000L);
                this.task_enum.put(tt, TimedTask.EMPTY_RESP);
                this.enum_task.put(TimedTask.EMPTY_RESP, tt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(BoshIOService bios) {
        Map<TimerTask, TimedTask> map = this.task_enum;
        synchronized (map) {
            if (bios != null) {
                this.connections.remove(bios);
            }
            TimerTask tt = this.enum_task.get((Object)TimedTask.STOP);
            if (this.connections.size() == 0 && tt == null) {
                tt = this.handler.scheduleTask(this, this.max_inactivity * 1000L);
                this.task_enum.put(tt, TimedTask.STOP);
                this.enum_task.put(TimedTask.STOP, tt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean task(Queue<Packet> out_results, TimerTask tt) {
        block13: {
            Map<TimerTask, TimedTask> map = this.task_enum;
            synchronized (map) {
                block12: {
                    TimedTask ttask = this.task_enum.remove(tt);
                    if (ttask == null) break block12;
                    this.enum_task.remove((Object)ttask);
                    switch (ttask) {
                        case STOP: {
                            for (TimerTask ttemp : this.task_enum.keySet()) {
                                this.handler.cancelTask(ttemp);
                            }
                            for (Element packet : this.waiting_packets) {
                                try {
                                    out_results.offer(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(new Packet(packet), "Bosh = disconnected", true));
                                }
                                catch (PacketErrorTypeException e) {
                                    log.warning("Packet processing exception: " + e);
                                }
                            }
                            Packet command2 = Command.STREAM_CLOSED.getPacket(null, null, StanzaType.set, "sess1");
                            out_results.offer(command2);
                            return true;
                        }
                        case EMPTY_RESP: {
                            BoshIOService serv = this.connections.poll();
                            if (serv != null) {
                                this.sendBody(serv, null);
                                break;
                            }
                            break block13;
                        }
                        default: {
                            log.warning("[" + this.connections.size() + "] Uknown TimedTask value: " + ttask.toString());
                            break;
                        }
                    }
                    break block13;
                }
                log.warning("[" + this.connections.size() + "] TimedTask enum is null for scheduled task....");
            }
        }
        return false;
    }

    private static enum TimedTask {
        EMPTY_RESP,
        STOP;

    }
}

