/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import tigase.server.ComponentRegistrator;
import tigase.server.MessageReceiver;
import tigase.util.DNSResolver;

public class MessageRouterConfig {
    private static final Logger log = Logger.getLogger("tigase.server.MessageRouterConfig");
    public static final String LOCAL_ADDRESSES_PROP_KEY = "hostnames";
    private static String[] LOCAL_ADDRESSES_PROP_VALUE = new String[]{"localhost", "hostname"};
    public static final String MSG_RECEIVERS_PROP_KEY = "components/msg-receivers/";
    public static final String MSG_RECEIVERS_NAMES_PROP_KEY = "components/msg-receivers/id-names";
    public static final String DEF_SM_NAME = "sess-man";
    public static final String DEF_C2S_NAME = "c2s";
    public static final String DEF_S2S_NAME = "s2s";
    public static final String DEF_EXT_COMP_NAME = "ext-comp";
    public static final String DEF_SSEND_NAME = "ssend";
    public static final String DEF_SRECV_NAME = "srecv";
    public static final String DEF_BOSH_NAME = "bosh";
    private static final String[] ALL_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "sess-man", "ssend", "srecv", "bosh"};
    private static final String[] DEF_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "sess-man", "bosh"};
    private static final String[] SM_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"ext-comp", "sess-man"};
    private static final String[] CS_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "ext-comp", "bosh"};
    private static final Map<String, String> MSG_RCV_CLASSES = new LinkedHashMap<String, String>();
    public static final String REGISTRATOR_PROP_KEY = "components/registrators/";
    public static final String REGISTRATOR_NAMES_PROP_KEY = "components/registrators/id-names";
    private static final String[] REGISTRATOR_NAMES_PROP_VAL;
    public static final String STAT_1_CLASS_PROP_KEY = "components/registrators/stat-1.class";
    public static final String STAT_1_CLASS_PROP_VAL = "tigase.stats.StatisticsCollector";
    public static final String STAT_1_ACTIVE_PROP_KEY = "components/registrators/stat-1.active";
    public static final boolean STAT_1_ACTIVE_PROP_VAL = true;
    public static final String DISCO_NAME_PROP_KEY = "disco-name";
    public static final String DISCO_NAME_PROP_VAL = "Tigase";
    public static final String DISCO_SHOW_VERSION_PROP_KEY = "disco-show-version";
    public static final boolean DISCO_SHOW_VERSION_PROP_VAL = true;
    private Map<String, Object> props = null;

    public static void getDefaults(Map<String, Object> defs, Map<String, Object> params, String comp_name) {
        String config_type = (String)params.get("config-type");
        Object[] rcv_names = DEF_MSG_RECEIVERS_NAMES_PROP_VAL;
        Object par_names = params.get(comp_name + "/" + MSG_RECEIVERS_NAMES_PROP_KEY);
        if (par_names != null) {
            rcv_names = (String[])par_names;
        } else {
            if (config_type.equals("--gen-config-all")) {
                rcv_names = ALL_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-sm")) {
                rcv_names = SM_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-cs")) {
                rcv_names = CS_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
        }
        Arrays.sort(rcv_names);
        for (String key : params.keySet()) {
            String new_comp_name;
            if (key.startsWith("--ext-comp") && Arrays.binarySearch(rcv_names, new_comp_name = DEF_EXT_COMP_NAME + key.substring("--ext-comp".length())) < 0) {
                rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
                rcv_names[rcv_names.length - 1] = new_comp_name;
                Arrays.sort(rcv_names);
            }
            if (!key.startsWith("--comp-name")) continue;
            String comp_name_suffix = key.substring("--comp-name".length());
            String c_name = (String)params.get("--comp-name" + comp_name_suffix);
            String c_class = (String)params.get("--comp-class" + comp_name_suffix);
            if (Arrays.binarySearch(rcv_names, c_name) >= 0) continue;
            defs.put(MSG_RECEIVERS_PROP_KEY + c_name + ".class", c_class);
            defs.put(MSG_RECEIVERS_PROP_KEY + c_name + ".active", true);
            rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
            rcv_names[rcv_names.length - 1] = c_name;
            Arrays.sort(rcv_names);
        }
        defs.put(MSG_RECEIVERS_NAMES_PROP_KEY, rcv_names);
        for (Object name : rcv_names) {
            if (defs.get(MSG_RECEIVERS_PROP_KEY + (String)name + ".class") != null) continue;
            String def_class = MSG_RCV_CLASSES.get(name);
            if (def_class == null) {
                def_class = "tigase.server.xmppcomponent.ComponentConnectionManager";
            }
            defs.put(MSG_RECEIVERS_PROP_KEY + (String)name + ".class", def_class);
            defs.put(MSG_RECEIVERS_PROP_KEY + (String)name + ".active", true);
        }
        defs.put(REGISTRATOR_NAMES_PROP_KEY, REGISTRATOR_NAMES_PROP_VAL);
        defs.put(STAT_1_CLASS_PROP_KEY, STAT_1_CLASS_PROP_VAL);
        defs.put(STAT_1_ACTIVE_PROP_KEY, true);
        LOCAL_ADDRESSES_PROP_VALUE = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        defs.put(LOCAL_ADDRESSES_PROP_KEY, LOCAL_ADDRESSES_PROP_VALUE);
        defs.put(DISCO_NAME_PROP_KEY, DISCO_NAME_PROP_VAL);
        defs.put(DISCO_SHOW_VERSION_PROP_KEY, true);
    }

    public MessageRouterConfig(Map<String, Object> props) {
        this.props = props;
    }

    public String[] getRegistrNames() {
        Object[] names = (String[])this.props.get(REGISTRATOR_NAMES_PROP_KEY);
        log.config(Arrays.toString(names));
        ArrayList<Object> al = new ArrayList<Object>();
        for (Object name : names) {
            if (!((Boolean)this.props.get(REGISTRATOR_PROP_KEY + (String)name + ".active")).booleanValue()) continue;
            al.add(name);
        }
        return al.toArray(new String[al.size()]);
    }

    public String[] getMsgRcvNames() {
        Object[] names = (String[])this.props.get(MSG_RECEIVERS_NAMES_PROP_KEY);
        log.config(Arrays.toString(names));
        ArrayList<Object> al = new ArrayList<Object>();
        for (Object name : names) {
            if (this.props.get(MSG_RECEIVERS_PROP_KEY + (String)name + ".active") == null || !((Boolean)this.props.get(MSG_RECEIVERS_PROP_KEY + (String)name + ".active")).booleanValue()) continue;
            al.add(name);
        }
        return al.toArray(new String[al.size()]);
    }

    public ComponentRegistrator getRegistrInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cls_name = (String)this.props.get(REGISTRATOR_PROP_KEY + name + ".class");
        if (cls_name.equals("tigase.server.XMPPServiceCollector") || cls_name.equals("tigase.disco.XMPPServiceCollector")) {
            log.warning("This class is not used anymore. Correct your configuration please. Remove all references to class: XMPPServiceCollector.");
            return null;
        }
        return (ComponentRegistrator)Class.forName(cls_name).newInstance();
    }

    public MessageReceiver getMsgRcvInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cls_name = (String)this.props.get(MSG_RECEIVERS_PROP_KEY + name + ".class");
        return (MessageReceiver)Class.forName(cls_name).newInstance();
    }

    static {
        MSG_RCV_CLASSES.put(DEF_C2S_NAME, "tigase.server.xmppclient.ClientConnectionManager");
        MSG_RCV_CLASSES.put(DEF_S2S_NAME, "tigase.server.xmppserver.ServerConnectionManager");
        MSG_RCV_CLASSES.put(DEF_EXT_COMP_NAME, "tigase.server.xmppcomponent.ComponentConnectionManager");
        MSG_RCV_CLASSES.put(DEF_SM_NAME, "tigase.server.xmppsession.SessionManager");
        MSG_RCV_CLASSES.put(DEF_SSEND_NAME, "tigase.server.ssender.StanzaSender");
        MSG_RCV_CLASSES.put(DEF_SRECV_NAME, "tigase.server.sreceiver.StanzaReceiver");
        MSG_RCV_CLASSES.put(DEF_BOSH_NAME, "tigase.server.bosh.BoshConnectionManager");
        REGISTRATOR_NAMES_PROP_VAL = new String[]{"stat-1"};
    }
}

