/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;

public enum Command {
    STREAM_OPENED,
    STREAM_CLOSED,
    STARTTLS,
    GETFEATURES,
    GETDISCO,
    CLOSE,
    GETSTATS,
    USER_STATUS,
    BROADCAST_TO_ONLINE,
    BROADCAST_TO_ALL,
    OTHER;

    private static final Logger log;
    public static final String XMLNS = "http://jabber.org/protocol/commands";

    public static Command valueof(String cmd) {
        try {
            return Command.valueOf(cmd);
        }
        catch (Exception e) {
            return OTHER;
        }
    }

    public Packet getPacket(String from, String to, StanzaType type, String id) {
        Element elem = Command.createIqCommand(from, to, type, id, this.toString(), null);
        return new Packet(elem);
    }

    public Packet getPacket(String from, String to, StanzaType type, String id, String data_type) {
        Element elem = Command.createIqCommand(from, to, type, id, this.toString(), data_type);
        return new Packet(elem);
    }

    public static Element createIqCommand(String from, String to, StanzaType type, String id, String node, String data_type) {
        Element iq = new Element("iq", new String[]{"from", "to", "type", "id"}, new String[]{from, to, type.toString(), id});
        Element command2 = new Element("command", new String[]{"xmlns", "node"}, new String[]{XMLNS, node});
        if (data_type != null) {
            Element x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", data_type});
            command2.addChild(x);
            if (data_type.equals("result")) {
                command2.setAttribute("status", "completed");
            }
        }
        iq.addChild(command2);
        return iq;
    }

    public static void setStatus(Packet packet, String status) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        command2.setAttribute("status", status);
    }

    public static void addAction(Packet packet, String action) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element actions = command2.getChild("actions");
        if (actions == null) {
            actions = new Element("actions", new String[]{"execute"}, new String[]{action});
            command2.addChild(actions);
        }
        actions.addChild(new Element(action));
    }

    public static String getAction(Packet packet) {
        return packet.getElement().getAttribute("/iq/command", "action");
    }

    public static void addNote(Packet packet, String note) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element notes = command2.getChild("note");
        if (notes == null) {
            notes = new Element("note", new String[]{"type"}, new String[]{"info"});
            command2.addChild(notes);
        }
        notes.setCData(note);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            command2.addChild(x);
        }
        Element field = new Element("field", new Element[]{new Element("value", f_value)}, new String[]{"var"}, new String[]{f_name});
        x.addChild(field);
    }

    public static void addFieldMultiValue(Packet packet, String f_name, List<String> f_value) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            command2.addChild(x);
        }
        if (f_value != null && f_value.size() > 0) {
            Element field = new Element("field", new String[]{"var", "type"}, new String[]{f_name, "text-multi"});
            for (String val : f_value) {
                Element value = new Element("value", val);
                field.addChild(value);
            }
            x.addChild(field);
        }
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String label, String[] labels, String[] options) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            command2.addChild(x);
        }
        Element field = new Element("field", new Element[]{new Element("value", f_value)}, new String[]{"var", "type", "label"}, new String[]{f_name, "list-single", label});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element("value", options[i])}, new String[]{"label"}, new String[]{labels[i]}));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String label, String[] labels, String[] options, String type) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            command2.addChild(x);
        }
        Element field = new Element("field", new Element[]{new Element("value", f_value)}, new String[]{"var", "type", "label"}, new String[]{f_name, type, label});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element("value", options[i])}, new String[]{"label"}, new String[]{labels[i]}));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String type) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            command2.addChild(x);
        }
        Element field = new Element("field", new Element[]{new Element("value", f_value)}, new String[]{"var", "type"}, new String[]{f_name, type});
        x.addChild(field);
    }

    public static void addFieldValue(Packet packet, String f_name, String f_value, String type, String label) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            command2.addChild(x);
        }
        Element field = new Element("field", new Element[]{new Element("value", f_value)}, new String[]{"var", "type", "label"}, new String[]{f_name, type, label});
        x.addChild(field);
    }

    public static void setData(Packet packet, Element data) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        command2.addChild(data);
    }

    public static void setData(Packet packet, List<Element> data) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        command2.addChildren(data);
    }

    public static String getFieldValue(Packet packet, String f_name) {
        List children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command", XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals("field") || !child.getAttribute("var").equals(f_name)) continue;
                return child.getChildCData("/field/value");
            }
        }
        return null;
    }

    public static String[] getFieldValues(Packet packet, String f_name) {
        List children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command", XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals("field") || !child.getAttribute("var").equals(f_name)) continue;
                LinkedList<String> values = new LinkedList<String>();
                List val_children = child.getChildren();
                for (Element val_child : val_children) {
                    if (!val_child.getName().equals("value")) continue;
                    values.add(val_child.getCData());
                }
                return values.toArray(new String[0]);
            }
        }
        return null;
    }

    public static boolean removeFieldValue(Packet packet, String f_name) {
        List children;
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command", XMLNS);
        Element x = command2.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals("field") || !child.getAttribute("var").equals(f_name)) continue;
                return x.removeChild(child);
            }
        }
        return false;
    }

    public static String getFieldValue(Packet packet, String f_name, boolean debug) {
        Element iq = packet.getElement();
        log.info("Command iq: " + iq.toString());
        Element command2 = iq.getChild("command", XMLNS);
        log.info("Command command: " + command2.toString());
        Element x = command2.getChild("x", "jabber:x:data");
        if (x == null) {
            log.info("Command x: NULL");
            return null;
        }
        log.info("Command x: " + x.toString());
        List children = x.getChildren();
        for (Element child : children) {
            log.info("Command form child: " + child.toString());
            if (child.getName().equals("field") && child.getAttribute("var").equals(f_name)) {
                log.info("Command found: field=" + f_name + ", value=" + child.getChildCData("/field/value"));
                return child.getChildCData("value");
            }
            log.info("Command not found: field=" + f_name + ", value=" + child.getChildCData("/field/value"));
        }
        return null;
    }

    public static List<Element> getData(Packet packet) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        return command2.getChildren();
    }

    public static Element getData(Packet packet, String el_name, String xmlns) {
        Element iq = packet.getElement();
        Element command2 = iq.getChild("command");
        return command2.getChild(el_name, xmlns);
    }

    static {
        log = Logger.getLogger("tigase.server.Command");
    }
}

