/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import tigase.conf.ConfigRepository;
import tigase.conf.Configurable;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ServerComponent;
import tigase.util.ClassUtil;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xml.db.Types;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class Configurator
extends AbstractComponentRegistrator<Configurable>
implements Configurable,
XMPPService {
    public static final String PROPERTY_FILENAME_PROP_KEY = "--property-file";
    private static final String LOGGING_KEY = "logging/";
    private static final Logger log = Logger.getLogger("tigase.conf.Configurator");
    private ConfigRepository repository = null;
    private Map<String, Object> defConfigParams = new LinkedHashMap<String, Object>();
    private Map<String, Object> defProperties = new LinkedHashMap<String, Object>();
    private ServiceEntity serviceEntity = null;
    private ServiceEntity config_list = null;
    private ServiceEntity config_set = null;
    private boolean demoMode = false;
    private String routerCompName = null;
    private static String config_file = null;
    private static String key = null;
    private static String value = null;
    private static boolean set = false;
    private static boolean add = false;
    private static boolean print = false;
    private static boolean force = true;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "config", "Server configuration");
        this.serviceEntity.addIdentities(new ServiceIdentity("automation", "command-list", "Configuration commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.config_list = new ServiceEntity(name, "list", "List");
        this.config_list.addIdentities(new ServiceIdentity("automation", "command-list", "Config listings"));
        this.config_list.addFeatures(DEF_FEATURES);
        this.config_set = new ServiceEntity(name, "set", "Set");
        this.config_set.addIdentities(new ServiceIdentity("automation", "command-list", "Config settings"));
        this.config_set.addFeatures(DEF_FEATURES);
        ServiceEntity item = new ServiceEntity(this.getName(), "--none--", "Add new component...");
        item.addFeatures(CMD_FEATURES);
        item.addIdentities(new ServiceIdentity("automation", "command-node", "Add new component..."));
        this.config_set.addItems(item);
        this.serviceEntity.addItems(this.config_list, this.config_set);
    }

    public void parseArgs(String[] args) {
        String property_filename;
        this.defConfigParams.put("--test", Boolean.FALSE);
        this.defConfigParams.put("config-type", "--gen-config-default");
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String key = null;
                Object val = null;
                if (args[i].startsWith("--gen-config")) {
                    key = "config-type";
                    val = args[i];
                }
                if (args[i].startsWith("--test")) {
                    key = args[i];
                    val = Boolean.TRUE;
                }
                if (args[i].equals("--user-db") || args[i].equals("--user-db-uri") || args[i].equals("--auth-db") || args[i].equals("--auth-db-uri") || args[i].startsWith("--comp-name") || args[i].startsWith("--comp-class") || args[i].startsWith("--ext-comp") || args[i].equals("--virt-hosts") || args[i].equals("--admins") || args[i].equals("--debug") || args[i].startsWith("--gen-") && !args[i].startsWith("--gen-config") || args[i].equals(PROPERTY_FILENAME_PROP_KEY)) {
                    key = args[i];
                    val = args[++i];
                }
                if (key == null) continue;
                this.defConfigParams.put(key, val);
                log.config("Setting defaults: " + key + "=" + val.toString());
            }
        }
        if ((property_filename = (String)this.defConfigParams.get(PROPERTY_FILENAME_PROP_KEY)) != null) {
            log.config("Loading initial properties from property file: " + property_filename);
            try {
                Properties defProps = new Properties();
                defProps.load(new FileReader(property_filename));
                Set<String> prop_keys = defProps.stringPropertyNames();
                for (String key : prop_keys) {
                    String value = defProps.getProperty(key);
                    if (key.startsWith("--") || key.equals("config-type")) {
                        this.defConfigParams.put(key, value);
                        log.config("Added default config parameter: (" + key + "=" + value + ")");
                        continue;
                    }
                    String[] val = value;
                    if (key.matches(".*\\[[LISBlisb]\\]$")) {
                        char c = key.charAt(key.length() - 2);
                        key = key.substring(0, key.length() - 3);
                        try {
                            switch (c) {
                                case 'L': {
                                    val = Long.decode(value);
                                    break;
                                }
                                case 'I': {
                                    val = Integer.decode(value);
                                    break;
                                }
                                case 'B': {
                                    val = Boolean.parseBoolean(value);
                                    break;
                                }
                                case 's': {
                                    val = value.split(",");
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.CONFIG, "Incorrect parameter modifier", e);
                        }
                    }
                    this.defProperties.put(key, val);
                }
            }
            catch (FileNotFoundException e) {
                log.warning("Given property file was not found: " + property_filename);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Can not read property file: " + property_filename, e);
            }
        }
    }

    public Configurator(String fileName, String[] args) {
        this.parseArgs(args);
        this.repository = ConfigRepository.getConfigRepository(fileName);
        this.defConfigParams.putAll(this.getAllProperties(null));
        Set<String> prop_keys = this.defProperties.keySet();
        for (String key : prop_keys) {
            int idx1 = key.indexOf("/");
            if (idx1 > 0) {
                String root = key.substring(0, idx1);
                String node = key.substring(idx1 + 1);
                String prop_key = null;
                int idx2 = node.lastIndexOf("/");
                if (idx2 > 0) {
                    prop_key = node.substring(idx2 + 1);
                    node = node.substring(0, idx2);
                } else {
                    prop_key = node;
                    node = null;
                }
                this.repository.set(root, node, prop_key, this.defProperties.get(key));
                log.config("Added default config property: (" + key + "=" + this.defProperties.get(key) + ")");
                continue;
            }
            log.warning("Ignoring default property, component part is missing: " + key);
        }
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof Configurable;
    }

    @Override
    public void componentAdded(Configurable component) {
        log.finer(" component: " + component.getName());
        ServiceEntity item = this.config_list.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.config_list.addItems(item);
        }
        if (this.config_set.findNode(component.getName()) == null) {
            this.config_set.addItems(item);
        }
        this.setup(component);
        if (component.getClass().getName().equals("tigase.server.MessageRouter")) {
            this.routerCompName = component.getName();
        }
    }

    @Override
    public void componentRemoved(Configurable component) {
    }

    public void setup(String name) {
        Configurable component = (Configurable)this.getComponent(name);
        this.setup(component);
    }

    public void setup(Configurable component) {
        String compId = component.getName();
        Map<String, Object> prop = this.repository.getProperties(compId);
        Map<String, Object> defs = component.getDefaults(this.defConfigParams);
        Set<Map.Entry<String, Object>> defs_entries = defs.entrySet();
        boolean modified = false;
        for (Map.Entry<String, Object> entry : defs_entries) {
            if (prop.containsKey(entry.getKey())) continue;
            prop.put(entry.getKey(), entry.getValue());
            modified = true;
        }
        if (modified) {
            this.repository.putProperties(compId, prop);
            try {
                this.repository.sync();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        component.setProperties(prop);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        TreeMap<String, Object> defaults = new TreeMap<String, Object>();
        defaults.put("logging/java.util.logging.ConsoleHandler.level", "WARNING");
        if (((Boolean)params.get("--test")).booleanValue()) {
            defaults.put("logging/.level", "WARNING");
            defaults.put("logging/java.util.logging.FileHandler.level", "INFO");
        } else {
            defaults.put("logging/.level", "INFO");
            defaults.put("logging/java.util.logging.FileHandler.level", "ALL");
        }
        defaults.put("logging/handlers", "java.util.logging.ConsoleHandler java.util.logging.FileHandler");
        defaults.put("logging/java.util.logging.ConsoleHandler.formatter", "tigase.util.LogFormatter");
        defaults.put("logging/java.util.logging.ConsoleHandler.level", "WARNING");
        defaults.put("logging/java.util.logging.FileHandler.append", "true");
        defaults.put("logging/java.util.logging.FileHandler.count", "5");
        defaults.put("logging/java.util.logging.FileHandler.formatter", "tigase.util.LogFormatter");
        defaults.put("logging/java.util.logging.FileHandler.limit", "10000000");
        defaults.put("logging/java.util.logging.FileHandler.pattern", "logs/tigase.log");
        defaults.put("logging/tigase.useParentHandlers", "true");
        if (params.get("--debug") != null) {
            String[] packs;
            defaults.put("logging/.level", "INFO");
            defaults.put("logging/java.util.logging.FileHandler.level", "ALL");
            defaults.put("logging/java.util.logging.ConsoleHandler.level", "FINER");
            for (String pack : packs = ((String)params.get("--debug")).split(",")) {
                defaults.put("logging/tigase." + pack + ".level", "ALL");
            }
        }
        defaults.put("demo-mode", this.demoMode);
        return defaults;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.setupLogManager(properties);
        this.demoMode = (Boolean)properties.get("demo-mode");
    }

    private void setupLogManager(Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> entries = properties.entrySet();
        StringBuilder buff = new StringBuilder();
        for (Map.Entry<String, Object> entry : entries) {
            File log_path;
            if (!entry.getKey().startsWith(LOGGING_KEY)) continue;
            String key = entry.getKey().substring(LOGGING_KEY.length());
            buff.append(key + "=" + entry.getValue() + "\n");
            if (!key.equals("java.util.logging.FileHandler.pattern") || (log_path = new File(entry.getValue().toString()).getParentFile()).exists()) continue;
            log_path.mkdirs();
        }
        Configurator.loadLogManagerConfig(buff.toString());
        log.warning("DONE");
    }

    public static void loadLogManagerConfig(String config) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(config.getBytes());
            LogManager.getLogManager().readConfiguration(bis);
            bis.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Can not configure logManager", e);
        }
    }

    public Map<String, Object> getProperties(String nodeId) {
        return this.repository.getProperties(nodeId);
    }

    public String[] getComponents() {
        return this.repository.getSubnodes();
    }

    public Map<String, Object> getAllProperties(String key) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String[] comps = this.getComponents();
        if (comps != null) {
            for (String comp : comps) {
                Map<String, Object> prop = this.getProperties(comp);
                for (Map.Entry<String, Object> entry : prop.entrySet()) {
                    String entry_key = comp + "/" + entry.getKey();
                    if (key == null) {
                        result.put(entry_key, entry.getValue());
                        continue;
                    }
                    if (!entry_key.startsWith(key)) continue;
                    result.put(entry_key, entry.getValue());
                }
            }
        }
        return result;
    }

    private boolean parseBoolean(String val) {
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on");
    }

    public Object setValue(String node_key, String value, boolean add, boolean feedback, Map<String, Object> orig) throws Exception {
        int root_idx = node_key.indexOf(47);
        String root = root_idx > 0 ? node_key.substring(0, root_idx) : "";
        int key_idx = node_key.lastIndexOf(47);
        String key = key_idx > 0 ? node_key.substring(key_idx + 1) : node_key;
        String subnode = null;
        if (root_idx != key_idx) {
            subnode = node_key.substring(root_idx + 1, key_idx);
        }
        Object old_val = null;
        old_val = orig == null ? this.repository.get(root, subnode, key, null) : orig.get(node_key);
        if (old_val != null) {
            Object[] new_val = null;
            Types.DataType type = Types.DataType.valueof((String)old_val.getClass().getSimpleName());
            switch (type) {
                case INTEGER: {
                    new_val = Integer.decode(value);
                    break;
                }
                case INTEGER_ARR: {
                    if (add) {
                        int old_len = ((int[])old_val).length;
                        new_val = Arrays.copyOf((int[])old_val, old_len + 1);
                        ((int[])new_val)[old_len] = Integer.decode(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new int[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((int[])new_val)[i] = Integer.decode(spl[i].trim());
                    }
                    break;
                }
                case LONG: {
                    new_val = Long.decode(value);
                    break;
                }
                case LONG_ARR: {
                    if (add) {
                        int old_len = ((long[])old_val).length;
                        new_val = Arrays.copyOf((long[])old_val, old_len + 1);
                        ((long[])new_val)[old_len] = Long.decode(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new long[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((long[])new_val)[i] = Long.decode(spl[i].trim());
                    }
                    break;
                }
                case STRING: {
                    new_val = value;
                    break;
                }
                case STRING_ARR: {
                    if (add) {
                        int old_len = ((String[])old_val).length;
                        new_val = Arrays.copyOf((String[])old_val, old_len + 1);
                        new_val[old_len] = value;
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new String[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        new_val[i] = spl[i].trim();
                    }
                    break;
                }
                case DOUBLE: {
                    new_val = new Double(Double.parseDouble(value));
                    break;
                }
                case DOUBLE_ARR: {
                    if (add) {
                        int old_len = ((double[])old_val).length;
                        new_val = Arrays.copyOf((double[])old_val, old_len + 1);
                        ((double[])new_val)[old_len] = Double.parseDouble(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new double[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((double[])new_val)[i] = Double.parseDouble(spl[i].trim());
                    }
                    break;
                }
                case BOOLEAN: {
                    new_val = this.parseBoolean(value);
                    break;
                }
                case BOOLEAN_ARR: {
                    if (add) {
                        int old_len = ((boolean[])old_val).length;
                        new_val = Arrays.copyOf((boolean[])old_val, old_len + 1);
                        ((boolean[])new_val)[old_len] = this.parseBoolean(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new boolean[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((boolean[])new_val)[i] = this.parseBoolean(spl[i].trim());
                    }
                    break;
                }
                default: {
                    new_val = value;
                }
            }
            if (orig == null) {
                this.repository.set(root, subnode, key, new_val);
                this.repository.sync();
            } else {
                orig.put(node_key, new_val);
            }
            return new_val;
        }
        if (force) {
            if (orig == null) {
                this.repository.set(root, subnode, key, value);
                this.repository.sync();
            } else {
                orig.put(node_key, value);
            }
            if (feedback) {
                System.out.println("Forced to set new key=value: " + key + "=" + value);
            }
            return value;
        }
        if (feedback) {
            System.out.println("Error, given key does not exist in config yet.");
            System.out.println("You can only modify existing values, you can add new.");
            System.out.println("Use '-f' switch to force creation of the new property.");
        }
        return null;
    }

    private static String help() {
        return "\nParameters:\n -h             this help message\n -c file        configuration file\n -key key       node/key for the value to set\n -value value   value to set in configuration file\n -set           set given value for given key\n -add           add given value to the values list for given key\n -print         print content of all configuration settings or of given node/key\n -f             force creation of the new property - dangerous option...\nSamples:\n Setting admin account - overwriting any previous value(s)\n $ ./scripts/config.sh -c tigase-config.xml -print -set -key sess-man/admins -value admin1@localhost\n Adding next admin account leaving old value(s)\n $ ./scripts/config.sh -c tigase-config.xml -print -add -key sess-man/admins -value admin2@localhost\n\nNote: adding -print option is useful always, even with -set or -add\n      option as it prints set value afterwards.\n";
    }

    private static String objectToString(Object value) {
        String val_str = null;
        Types.DataType type = Types.DataType.valueof((String)value.getClass().getSimpleName());
        try {
            StringBuilder sb = new StringBuilder();
            switch (type) {
                case STRING_ARR: {
                    for (String s : (String[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case INTEGER_ARR: {
                    for (int s : (int[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case LONG_ARR: {
                    for (long s : (long[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case DOUBLE_ARR: {
                    for (double s : (double[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case BOOLEAN_ARR: {
                    for (boolean s : (boolean[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                default: {
                    val_str = value.toString();
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            log.warning("ERROR! Problem with type casting for property: " + key);
        }
        return val_str;
    }

    private static void print(String key, Object value) {
        System.out.println(key + " = " + Configurator.objectToString(value));
    }

    public static void main(String[] args) throws Exception {
        force = false;
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(Configurator.help());
                    System.exit(0);
                }
                if (args[i].equals("-c")) {
                    config_file = args[++i];
                }
                if (args[i].equals("-key")) {
                    key = args[++i];
                }
                if (args[i].equals("-value")) {
                    value = args[++i];
                }
                if (args[i].equals("-set")) {
                    set = true;
                }
                if (args[i].equals("-add")) {
                    add = true;
                }
                if (args[i].equals("-print")) {
                    print = true;
                }
                if (!args[i].equals("-f")) continue;
                force = true;
            }
        }
        Configurator conf = new Configurator(config_file, args);
        if (set || add) {
            conf.setValue(key, value, add, true, null);
        }
        if (print) {
            Map<String, Object> allprop = conf.getAllProperties(key);
            for (Map.Entry<String, Object> entry : allprop.entrySet()) {
                Configurator.print(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (!packet.isCommand()) {
            return;
        }
        if (packet.getType() != null && packet.getType() == StanzaType.error) {
            log.warning("Ignoring error packet: " + packet.toString());
            return;
        }
        if (!packet.getTo().startsWith(this.getName() + ".")) {
            return;
        }
        String msg = "Please be careful, you are service admin and all changes you make are instantly applied to live system!";
        boolean admin = true;
        if (packet.getPermissions() != Permissions.ADMIN) {
            if (this.demoMode) {
                admin = false;
                msg = "You are not admin. You can safely play with the settings as you can not change anything.";
                if (packet.getStrCommand() != null && packet.getStrCommand().endsWith("sess-man")) {
                    Packet result = packet.commandResult("result");
                    Command.addFieldValue(result, "Note", msg, "fixed");
                    Command.addFieldValue(result, "Note", "Restricted area, only admin can see these settings.", "fixed");
                    results.offer(result);
                    return;
                }
            } else {
                try {
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized for this action.", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
                return;
            }
        }
        log.finest("Command received: " + packet.getStringData());
        String action = Command.getAction(packet);
        if (action != null && action.equals("cancel")) {
            Packet result = packet.commandResult(null);
            results.offer(result);
            return;
        }
        switch (packet.getCommand()) {
            case OTHER: {
                Packet result;
                String[] spl;
                if (packet.getStrCommand() == null) break;
                if (packet.getStrCommand().startsWith("config/list/")) {
                    spl = packet.getStrCommand().split("/");
                    result = packet.commandResult("result");
                    Command.addFieldValue(result, "Note", msg, "fixed");
                    Map<String, Object> allprop = this.getAllProperties(spl[2]);
                    for (Map.Entry<String, Object> entry : allprop.entrySet()) {
                        Command.addFieldValue(result, XMLUtils.escape((String)entry.getKey()), XMLUtils.escape((String)Configurator.objectToString(entry.getValue())));
                    }
                    results.offer(result);
                }
                if (!packet.getStrCommand().startsWith("config/set/")) break;
                spl = packet.getStrCommand().split("/");
                result = packet.commandResult("result");
                Command.addFieldValue(result, "Note", msg, "fixed");
                if (Command.getData(packet) == null) {
                    this.prepareConfigData(result, spl[2]);
                    results.offer(result);
                    break;
                }
                this.updateConfigChanges(packet, result, spl[2], admin);
                results.offer(result);
                break;
            }
        }
    }

    private void newComponentCommand(Packet result) {
        Command.addFieldValue(result, "Info", "Press:", "fixed");
        Command.addFieldValue(result, "Info", "'Next' to set all parameters for the new component.", "fixed");
        Command.setStatus(result, "executing");
        Command.addAction(result, "next");
        Command.addFieldValue(result, "Component name", "", "text-single", "Component name");
        try {
            Set receiv_cls = ClassUtil.getClassesImplementing(MessageReceiver.class);
            String[] receiv_cls_names = new String[receiv_cls.size() - 1];
            String[] receiv_cls_simple = new String[receiv_cls.size() - 1];
            int idx = 0;
            for (Class reciv : receiv_cls) {
                if (reciv.getName().equals("tigase.server.MessageRouter")) continue;
                receiv_cls_names[idx] = reciv.getName();
                receiv_cls_simple[idx++] = reciv.getSimpleName();
            }
            Command.addFieldValue(result, "Component class", "tigase.server.xmppcomponent.ComponentConnectionManager", "Component class", receiv_cls_simple, receiv_cls_names);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem loading MessageReceiver implementations", e);
            Command.addFieldValue(result, "Component class", "ERROR!! Problem loading MessageReceiver implementations, look in log file for details...", "text-single", "Component class");
        }
    }

    private boolean checkComponentName(Packet result, String name) {
        String[] comp_names;
        String msg = JIDUtils.checkNickName((String)name);
        if (msg != null) {
            Command.addFieldValue(result, "Info", "Note!! " + msg + ", please provide valid component name.", "fixed");
            this.newComponentCommand(result);
            return false;
        }
        for (String comp_name : comp_names = this.getComponents()) {
            if (!comp_name.equals(name)) continue;
            Command.addFieldValue(result, "Info", "Note!! Component with provided name already exists.", "fixed");
            Command.addFieldValue(result, "Info", "Please provide different component name.", "fixed");
            this.newComponentCommand(result);
            return false;
        }
        return true;
    }

    private void createNewComponent(Packet packet, Packet result, boolean admin) {
        String new_comp_name = Command.getFieldValue(packet, "Component name");
        String new_comp_class = Command.getFieldValue(packet, "Component class");
        try {
            MessageReceiver mr = (MessageReceiver)Class.forName(new_comp_class).newInstance();
            mr.setName(new_comp_name);
            if (mr instanceof Configurable) {
                Map<String, Object> comp_props = ((Configurable)((Object)mr)).getDefaults(this.defConfigParams);
                LinkedHashMap<String, Object> new_params = new LinkedHashMap<String, Object>(comp_props);
                for (Map.Entry<String, Object> entry : comp_props.entrySet()) {
                    String val = Command.getFieldValue(packet, XMLUtils.escape((String)entry.getKey()));
                    if (val == null) {
                        val = "";
                    }
                    val = XMLUtils.unescape((String)val);
                    log.info("New component value: " + entry.getKey() + "=" + val);
                    this.setValue(entry.getKey(), val, false, false, new_params);
                }
                if (admin) {
                    for (Map.Entry<String, Object> entry : new_params.entrySet()) {
                        String key = entry.getKey();
                        String subnode = null;
                        int key_idx = entry.getKey().lastIndexOf(47);
                        if (key_idx > 0) {
                            key = entry.getKey().substring(key_idx + 1);
                            subnode = entry.getKey().substring(0, key_idx);
                        }
                        log.info("Saving property to repository: root=" + new_comp_name + ", subnode=" + subnode + ", key=" + key + ", value=" + entry.getValue());
                        this.repository.set(new_comp_name, subnode, key, entry.getValue());
                    }
                    this.repository.set(this.routerCompName, "/components/msg-receivers", new_comp_name + ".class", new_comp_class);
                    this.repository.set(this.routerCompName, "/components/msg-receivers", new_comp_name + ".active", true);
                    this.setValue(this.routerCompName + "/components/msg-receivers/id-names", new_comp_name, true, false, null);
                    this.setup(this.routerCompName);
                }
            }
            Command.addNote(result, "New component created: " + new_comp_name);
            Command.addFieldValue(result, "Note", "New component created: " + new_comp_name, "fixed");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem instantiating component:", e);
            Command.addFieldValue(result, "Component class", "ERROR!! Problem instantiating component, look in log file for details...", "text-single", "Component class");
        }
    }

    private void newComponentCommand(Packet packet, Packet result, boolean admin) {
        String params_set = Command.getFieldValue(packet, "Params set");
        if (Command.getAction(packet) != null && Command.getAction(packet).equals("prev")) {
            this.newComponentCommand(result);
            return;
        }
        if (params_set != null) {
            this.createNewComponent(packet, result, admin);
            return;
        }
        String new_comp_name = Command.getFieldValue(packet, "Component name");
        String new_comp_class = Command.getFieldValue(packet, "Component class");
        if (!this.checkComponentName(result, new_comp_name)) {
            return;
        }
        Command.setStatus(result, "executing");
        Command.addFieldValue(result, "Component name", new_comp_name, "hidden");
        Command.addFieldValue(result, "Component class", new_comp_class, "hidden");
        Command.addFieldValue(result, "Info1", "Press:", "fixed");
        try {
            MessageReceiver mr = (MessageReceiver)Class.forName(new_comp_class).newInstance();
            Command.addFieldValue(result, "Info4", "Component name: " + new_comp_name + ", class: " + mr.getClass().getSimpleName(), "fixed");
            if (mr instanceof ConnectionManager) {
                String ports = Command.getFieldValue(packet, "TCP/IP ports");
                if (ports == null) {
                    Command.addFieldValue(result, "Info2", "1. 'Next' to set more component parameters.", "fixed");
                    Command.addFieldValue(result, "Info3", "2. 'Previous' to go back and select different component.", "fixed");
                    Command.addAction(result, "next");
                    Command.addAction(result, "prev");
                    Command.addFieldValue(result, "Info4", "This component uses TCP/IP ports, please provide port numbers:", "fixed");
                    Command.addFieldValue(result, "TCP/IP ports", "5557");
                    return;
                }
                String[] ports_arr = ports.split(",");
                int[] ports_i = new int[ports_arr.length];
                try {
                    for (int i = 0; i < ports_arr.length; ++i) {
                        ports_i[i] = Integer.decode(ports_arr[i].trim());
                    }
                    this.defConfigParams.put(new_comp_name + "/connections/ports", ports_i);
                }
                catch (Exception e) {
                    Command.addFieldValue(result, "Info2", "1. 'Next' to set more component parameters.", "fixed");
                    Command.addFieldValue(result, "Info3", "2. 'Previous' to go back and select different component.", "fixed");
                    Command.addAction(result, "next");
                    Command.addAction(result, "prev");
                    Command.addFieldValue(result, "Info4", "Incorrect TCP/IP ports provided, please provide port numbers:", "fixed");
                    Command.addFieldValue(result, "TCP/IP ports", ports);
                    return;
                }
            }
            Command.addFieldValue(result, "Info2", "1. 'Finish' to create component with this parameters.", "fixed");
            Command.addFieldValue(result, "Info3", "2. 'Previous' to go back and select different component.", "fixed");
            Command.addAction(result, "complete");
            Command.addAction(result, "prev");
            mr.setName(new_comp_name);
            if (mr instanceof Configurable) {
                TreeMap<String, Object> comp_props = new TreeMap<String, Object>(((Configurable)((Object)mr)).getDefaults(this.defConfigParams));
                for (Map.Entry entry : comp_props.entrySet()) {
                    Command.addFieldValue(result, XMLUtils.escape((String)((String)entry.getKey())), XMLUtils.escape((String)Configurator.objectToString(entry.getValue())));
                }
            } else {
                Command.addFieldValue(result, "Info6", "Component is not configurable, do you want to create it?", "fixed");
            }
            Command.addFieldValue(result, "Params set", "true", "hidden");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem instantiating component:", e);
            Command.addFieldValue(result, "Component class", "ERROR!! Problem instantiating component, look in log file for details...", "text-single", "Component class");
        }
    }

    private void prepareConfigData(Packet result, String comp_name) {
        if (comp_name.equals("--none--")) {
            this.newComponentCommand(result);
            return;
        }
        Command.setStatus(result, "executing");
        Command.addAction(result, "complete");
        TreeMap<String, Object> allprop = new TreeMap<String, Object>(this.getAllProperties(comp_name));
        for (Map.Entry entry : allprop.entrySet()) {
            Command.addFieldValue(result, XMLUtils.escape((String)((String)entry.getKey())), XMLUtils.escape((String)Configurator.objectToString(entry.getValue())));
        }
        Command.addFieldValue(result, XMLUtils.escape((String)"new-prop-name"), XMLUtils.escape((String)(comp_name + "/")), "text-single", "New property name");
        Command.addFieldValue(result, XMLUtils.escape((String)"new-prop-value"), "", "text-single", "New property value");
    }

    private void updateConfigChanges(Packet packet, Packet result, String comp_name, boolean admin) {
        if (comp_name.equals("--none--")) {
            this.newComponentCommand(packet, result, admin);
            return;
        }
        Command.addNote(result, "You changed following settings:");
        Command.addFieldValue(result, "Note", "You changed following settings:", "fixed");
        Map<String, Object> allprop = this.getAllProperties(comp_name);
        boolean changed = false;
        for (Map.Entry<String, Object> entry : allprop.entrySet()) {
            String old_val;
            String tmp_val = Command.getFieldValue(packet, XMLUtils.escape((String)entry.getKey()));
            String new_val = old_val = Configurator.objectToString(entry.getValue());
            if (tmp_val != null) {
                new_val = XMLUtils.unescape((String)tmp_val);
            }
            if (new_val == null || old_val == null || new_val.equals(old_val)) continue;
            this.defConfigParams.put(entry.getKey(), this.setPropertyValue(entry.getKey(), new_val, result, admin));
            changed = true;
        }
        String prop_value = Command.getFieldValue(packet, "new-prop-value");
        if (prop_value != null && prop_value.trim().length() > 0) {
            this.setPropertyValue(XMLUtils.unescape((String)Command.getFieldValue(packet, "new-prop-name")), XMLUtils.unescape((String)prop_value), result, admin);
            changed = true;
        }
        if (changed && admin) {
            this.setup(comp_name);
        }
    }

    public Object setPropertyValue(String key, String val, Packet result_pack, boolean admin) {
        Object result = null;
        try {
            if (admin) {
                result = this.setValue(key, val, false, false, null);
            }
            if (result != null) {
                Command.addFieldValue(result_pack, XMLUtils.escape((String)key), XMLUtils.escape((String)val));
            } else {
                Command.addFieldValue(result_pack, "Note", "You can not set new properties yet, you can just modify existing ones.", "fixed");
            }
        }
        catch (Exception e) {
            Command.addFieldValue(result_pack, "Note", "Error setting property: " + e, "fixed");
        }
        return result;
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && jid.startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        if (jid.startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoItems(node, jid);
        }
        return Arrays.asList(this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid));
    }
}

