/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class StartTLS
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.StartTLS");
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-tls";
    private static final String TLS_STARTED_KEY = "TLS-Started";
    public static final String TLS_REQUIRED_KEY = "tls-required";
    private static final String ID = "starttls";
    private static final String[] ELEMENTS = new String[]{"starttls", "proceed", "failure"};
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-tls", "urn:ietf:params:xml:ns:xmpp-tls", "urn:ietf:params:xml:ns:xmpp-tls"};
    private static final Element[] F_REQUIRED = new Element[]{new Element("starttls", new Element[]{new Element("required")}, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"})};
    private static final Element[] F_NOT_REQUIRED = new Element[]{new Element("starttls", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"})};
    private Element proceed = new Element("proceed");
    private Element failure = null;

    public StartTLS() {
        this.proceed.setXMLNS(XMLNS);
        this.failure = new Element("failure");
        this.failure.setXMLNS(XMLNS);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] supElements() {
        return Arrays.copyOf(ELEMENTS, ELEMENTS.length);
    }

    @Override
    public String[] supNamespaces() {
        return Arrays.copyOf(XMLNSS, XMLNSS.length);
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session.getSessionData(TLS_STARTED_KEY) == null) {
            if (session.getSessionData(TLS_REQUIRED_KEY) != null && session.getSessionData(TLS_REQUIRED_KEY).equals("true")) {
                return Arrays.copyOf(F_REQUIRED, F_REQUIRED.length);
            }
            return Arrays.copyOf(F_NOT_REQUIRED, F_NOT_REQUIRED.length);
        }
        return null;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null) {
            return;
        }
        if (packet.getElement().getName().equals(ID)) {
            session.putSessionData(TLS_STARTED_KEY, "true");
            Packet result = Command.STARTTLS.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, "1", "submit");
            Command.setData(result, new Element("proceed", new String[]{"xmlns"}, new String[]{XMLNS}));
            results.offer(result);
        } else {
            log.warning("Unknown TLS element: " + packet.getStringData());
            results.offer(packet.swapFromTo(this.failure));
            results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, "1"));
        }
    }
}

