/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class SaslAuth
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.SaslAuth");
    private static final String ID = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final String[] ELEMENTS = new String[]{"auth", "response", "challenge", "failure", "success", "abort"};
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return Arrays.copyOf(DISCO_FEATURES, DISCO_FEATURES.length);
    }

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-sasl";
    }

    @Override
    public String[] supElements() {
        return Arrays.copyOf(ELEMENTS, ELEMENTS.length);
    }

    @Override
    public String[] supNamespaces() {
        return Arrays.copyOf(XMLNSS, XMLNSS.length);
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session.isAuthorized()) {
            return null;
        }
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("protocol", "sasl");
        session.queryAuth(query);
        String[] auth_mechs = (String[])query.get("result");
        Element[] mechs = new Element[auth_mechs.length];
        int idx = 0;
        for (String mech : auth_mechs) {
            mechs[idx++] = new Element("mechanism", mech);
        }
        return new Element[]{new Element("mechanisms", mechs, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null) {
            return;
        }
        Element request = packet.getElement();
        HashMap<String, Object> authProps = (HashMap<String, Object>)session.getSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
        if (authProps == null) {
            authProps = new HashMap<String, Object>();
            authProps.put("protocol", "sasl");
            authProps.put("mechanism", request.getAttribute("/auth", "mechanism"));
            authProps.put("realm", session.getDomain());
            authProps.put("server-name", session.getDomain());
            session.putSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps", authProps);
        }
        authProps.put("data", request.getCData());
        try {
            Authorization result = session.loginOther(authProps);
            String challenge_data = (String)authProps.get("result");
            if (result == Authorization.AUTHORIZED) {
                results.offer(packet.swapFromTo(this.createReply(ElementType.success, challenge_data)));
                authProps.clear();
            } else {
                results.offer(packet.swapFromTo(this.createReply(ElementType.challenge, challenge_data)));
            }
        }
        catch (Exception e) {
            results.offer(packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>")));
        }
    }

    private Element createReply(ElementType type, String cdata) {
        Element reply = new Element(type.toString());
        reply.setXMLNS("urn:ietf:params:xml:ns:xmpp-sasl");
        if (cdata != null) {
            reply.setCData(cdata);
        }
        return reply;
    }

    public static enum ElementType {
        auth,
        abort,
        response,
        challenge,
        failure,
        success;

    }
}

