/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.Roster;

public class Presence
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc {
    private static final String PRESENCE_KEY = "user-presence";
    private static final String DIRECT_PRESENCE = "direct-presences";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Presence");
    private static final String ID = "presence";
    private static final String[] ELEMENTS = new String[]{"presence"};
    private static final String[] XMLNSS = new String[]{"jabber:client"};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] supElements() {
        return Arrays.copyOf(ELEMENTS, ELEMENTS.length);
    }

    @Override
    public String[] supNamespaces() {
        return Arrays.copyOf(XMLNSS, XMLNSS.length);
    }

    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results) {
        Element pres = (Element)session.getSessionData(PRESENCE_KEY);
        if (pres == null || pres.getAttribute("type") == null || !pres.getAttribute("type").equals("unavailable")) {
            try {
                this.sendPresenceBroadcast(StanzaType.unavailable, session, Roster.FROM_SUBSCRIBED, results, null);
                this.updateOfflineChange(session, results);
            }
            catch (NotAuthorizedException e) {
                // empty catch block
            }
        }
    }

    protected void sendPresenceBroadcast(StanzaType t, XMPPResourceConnection session, EnumSet<Roster.SubscriptionType> subscrs, Queue<Packet> results, Element pres) throws NotAuthorizedException {
        Set direct_presences;
        String[] buddies = Roster.getBuddies(session, subscrs);
        if (buddies != null) {
            for (String buddy : buddies) {
                this.sendPresence(t, buddy, session.getJID(), results, pres);
            }
        }
        if ((direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE)) != null) {
            for (String buddy : direct_presences) {
                log.finest("Updating direct presence for: " + buddy);
                this.sendPresence(t, buddy, session.getJID(), results, pres);
            }
        }
    }

    protected void updateOfflineChange(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            log.finer("Update presence change to: " + conn.getJID());
            if (conn != session && conn.getResource() != null && !conn.getResource().equals(session.getResource())) {
                Element pres_update = new Element(ID);
                pres_update.setAttribute("from", session.getJID());
                pres_update.setAttribute("to", conn.getJID());
                pres_update.setAttribute("type", StanzaType.unavailable.toString());
                Packet pack_update = new Packet(pres_update);
                pack_update.setTo(conn.getConnectionId());
                results.offer(pack_update);
                continue;
            }
            log.finer("Skipping presence update to: " + conn.getJID());
        }
    }

    protected void updateUserResources(Element presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            log.finer("Update presence change to: " + conn.getJID());
            if (conn != session) {
                Element pres_update = presence.clone();
                pres_update.setAttribute("from", session.getJID());
                pres_update.setAttribute("to", conn.getJID());
                Packet pack_update = new Packet(pres_update);
                pack_update.setTo(conn.getConnectionId());
                results.offer(pack_update);
                Element presence_el = (Element)conn.getSessionData(PRESENCE_KEY);
                if (presence_el == null) continue;
                pres_update = presence_el.clone();
                pres_update.setAttribute("to", session.getJID());
                pres_update.setAttribute("from", conn.getJID());
                pack_update = new Packet(pres_update);
                pack_update.setTo(session.getConnectionId());
                results.offer(pack_update);
                continue;
            }
            log.finer("Skipping presence update to: " + conn.getJID());
        }
    }

    protected void updatePresenceChange(Element presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            log.finer("Update presence change to: " + conn.getJID());
            Element pres_update = presence.clone();
            pres_update.setAttribute("to", conn.getJID());
            Packet pack_update = new Packet(pres_update);
            pack_update.setTo(conn.getConnectionId());
            results.offer(pack_update);
        }
    }

    protected void forwardPresence(Queue<Packet> results, Packet packet, String from) {
        Element result = packet.getElement().clone();
        log.finest("\n\nFORWARD presence: " + result.toString());
        results.offer(new Packet(result));
    }

    protected final void sendPresence(StanzaType t, String to, String from, Queue<Packet> results, Element pres) {
        Element presence = null;
        if (pres == null) {
            presence = new Element(ID);
            if (t != null) {
                presence.setAttribute("type", t.toString());
            } else {
                presence.setAttribute("type", StanzaType.unavailable.toString());
            }
        } else {
            presence = pres.clone();
        }
        presence.setAttribute("to", to);
        presence.setAttribute("from", from);
        Packet packet = new Packet(presence);
        log.finest("Sending presence info: " + packet.getStringData());
        results.offer(packet);
    }

    protected void addDirectPresenceJID(String jid, XMPPResourceConnection session) {
        HashSet<String> direct_presences = (HashSet<String>)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences == null) {
            direct_presences = new HashSet<String>();
            session.putSessionData(DIRECT_PRESENCE, direct_presences);
        }
        direct_presences.add(jid);
        log.finest("Added direct presence jid: " + jid);
    }

    protected void removeDirectPresenceJID(String jid, XMPPResourceConnection session) {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null) {
            direct_presences.remove(jid);
        }
        log.finest("Added direct presence jid: " + jid);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            String jid = session.getJID();
            Roster.PresenceType pres_type = Roster.getPresenceType(session, packet);
            if (pres_type == null) {
                log.warning("Invalid presence found: " + packet.getStringData());
                return;
            }
            StanzaType type = packet.getType();
            if (type == null) {
                type = StanzaType.available;
            }
            log.finest((Object)((Object)pres_type) + " presence found: " + packet.toString());
            boolean subscr_changed = false;
            switch (pres_type) {
                case out_initial: {
                    if (packet.getElemTo() != null) {
                        Element result = packet.getElement().clone();
                        results.offer(new Packet(result));
                        if (packet.getType() != null && packet.getType() == StanzaType.unavailable) {
                            this.removeDirectPresenceJID(packet.getElemTo(), session);
                            break;
                        }
                        this.addDirectPresenceJID(packet.getElemTo(), session);
                        break;
                    }
                    boolean first = false;
                    if (session.getSessionData(PRESENCE_KEY) == null) {
                        first = true;
                    }
                    session.putSessionData(PRESENCE_KEY, packet.getElement());
                    String priority = packet.getElemCData("/presence/priority");
                    if (priority != null) {
                        int pr = 1;
                        try {
                            pr = Integer.decode(priority);
                        }
                        catch (NumberFormatException e) {
                            log.finer("Incorrect priority value: " + priority + ", setting 1 as default.");
                            pr = 1;
                        }
                        session.setPriority(pr);
                    }
                    if (first && type == StanzaType.available) {
                        this.sendPresenceBroadcast(StanzaType.probe, session, Roster.TO_SUBSCRIBED, results, null);
                    }
                    this.sendPresenceBroadcast(type, session, Roster.FROM_SUBSCRIBED, results, packet.getElement());
                    this.updateUserResources(packet.getElement(), session, results);
                    break;
                }
                case out_subscribe: 
                case out_unsubscribe: {
                    Roster.SubscriptionType current_subscription;
                    if (pres_type == Roster.PresenceType.out_subscribe && (current_subscription = Roster.getBuddySubscription(session, packet.getElemTo())) == null) {
                        Roster.addBuddy(session, packet.getElemTo());
                    }
                    if (subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemTo())) {
                        Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemTo()));
                    }
                    this.forwardPresence(results, packet, session.getUserId());
                    break;
                }
                case out_subscribed: 
                case out_unsubscribed: {
                    subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemTo());
                    if (subscr_changed) {
                        Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemTo()));
                        this.forwardPresence(results, packet, session.getUserId());
                        this.sendPresence(StanzaType.available, packet.getElemTo(), session.getJID(), results, null);
                    }
                    break;
                }
                case in_initial: {
                    if (Roster.isSubscribedTo(session, packet.getElemFrom())) {
                        this.updatePresenceChange(packet.getElement(), session, results);
                        break;
                    }
                    Element elem = packet.getElement().clone();
                    Packet result = new Packet(elem);
                    result.setTo(session.getConnectionId());
                    result.setFrom(packet.getTo());
                    results.offer(result);
                    break;
                }
                case in_subscribe: {
                    if (Roster.isSubscribedFrom(session, packet.getElemFrom())) {
                        this.sendPresence(StanzaType.subscribed, packet.getElemFrom(), session.getJID(), results, null);
                        break;
                    }
                    Roster.SubscriptionType curr_sub = Roster.getBuddySubscription(session, packet.getElemFrom());
                    if (curr_sub == null) {
                        curr_sub = Roster.SubscriptionType.none;
                        Roster.addBuddy(session, packet.getElemFrom());
                    }
                    if (subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom())) {
                        this.updatePresenceChange(packet.getElement(), session, results);
                    }
                    break;
                }
                case in_unsubscribe: {
                    subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom());
                    if (subscr_changed) {
                        this.sendPresence(StanzaType.unsubscribed, packet.getElemFrom(), session.getJID(), results, null);
                        this.updatePresenceChange(packet.getElement(), session, results);
                        Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemFrom()));
                    }
                    break;
                }
                case in_subscribed: {
                    Roster.SubscriptionType curr_sub = Roster.getBuddySubscription(session, packet.getElemFrom());
                    if (curr_sub == null) {
                        curr_sub = Roster.SubscriptionType.none;
                        Roster.addBuddy(session, packet.getElemFrom());
                    }
                    if (subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom())) {
                        this.updatePresenceChange(packet.getElement(), session, results);
                        Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemFrom()));
                    }
                    break;
                }
                case in_unsubscribed: {
                    Roster.SubscriptionType curr_sub = Roster.getBuddySubscription(session, packet.getElemFrom());
                    if (curr_sub != null && (subscr_changed = Roster.updateBuddySubscription(session, pres_type, packet.getElemFrom()))) {
                        this.updatePresenceChange(packet.getElement(), session, results);
                        Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, packet.getElemFrom()));
                    }
                    break;
                }
                case in_probe: {
                    Roster.SubscriptionType buddy_subscr = Roster.getBuddySubscription(session, packet.getElemFrom());
                    if (buddy_subscr == null) {
                        buddy_subscr = Roster.SubscriptionType.none;
                    }
                    switch (buddy_subscr) {
                        case none: 
                        case none_pending_out: 
                        case to: {
                            results.offer(Authorization.FORBIDDEN.getResponseMessage(packet, "Presence information is forbidden.", false));
                            break;
                        }
                        case none_pending_in: 
                        case none_pending_out_in: 
                        case to_pending_in: {
                            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to get presence information.", false));
                            break;
                        }
                    }
                    if (Roster.isSubscribedFrom(session, packet.getElemFrom())) {
                        for (XMPPResourceConnection conn : session.getActiveSessions()) {
                            Element pres = (Element)conn.getSessionData(PRESENCE_KEY);
                            this.sendPresence(null, packet.getElemFrom(), conn.getJID(), results, pres);
                        }
                    }
                    break;
                }
                case error: {
                    Element elem = packet.getElement().clone();
                    Packet result = new Packet(elem);
                    result.setTo(session.getConnectionId());
                    result.setFrom(packet.getTo());
                    results.offer(result);
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received roster request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

