/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class Jingle
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.Jingle");
    private static final String ID = "http://jabber.org/protocol/jingle";
    private static final String[] ELEMENTS = new String[]{"jingle", "jingle", "jingle", "session"};
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/jingle", "http://www.xmpp.org/extensions/xep-0166.html#ns", "http://www.xmpp.org/extensions/xep-0167.html#ns", "http://www.google.com/session"};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] supElements() {
        return Arrays.copyOf(ELEMENTS, ELEMENTS.length);
    }

    @Override
    public String[] supNamespaces() {
        return Arrays.copyOf(XMLNSS, XMLNSS.length);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository nonAuthUserRepo, Queue<Packet> results) throws XMPPException {
        if (conn == null) {
            return;
        }
        try {
            log.finest("Received packet: " + packet.getStringData());
            String id = JIDUtils.getNodeID((String)packet.getElemTo());
            if (id.equals(conn.getUserId())) {
                List<XMPPResourceConnection> res = conn.getParentSession().getActiveResources();
                XMPPResourceConnection session = conn;
                if (res != null && res.size() > 1) {
                    for (XMPPResourceConnection sess : res) {
                        if (sess.getSessionData("jingle") == null) continue;
                        session = sess;
                        break;
                    }
                }
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId());
                result.setFrom(packet.getTo());
                results.offer(result);
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

