/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Roster;

public class JabberIqRoster
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqRoster");
    private static final String XMLNS = "jabber:iq:roster";
    private static final String ID = "jabber:iq:roster";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:roster"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster"})};

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return Arrays.copyOf(DISCO_FEATURES, DISCO_FEATURES.length);
    }

    @Override
    public String id() {
        return "jabber:iq:roster";
    }

    @Override
    public String[] supElements() {
        return Arrays.copyOf(ELEMENTS, ELEMENTS.length);
    }

    @Override
    public String[] supNamespaces() {
        return Arrays.copyOf(XMLNSS, XMLNSS.length);
    }

    private void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        Element request = packet.getElement();
        String buddy = JIDUtils.getNodeID((String)request.getAttribute("/iq/query/item", "jid"));
        Element item = request.findChild("/iq/query/item");
        String subscription = item.getAttribute("subscription");
        if (subscription != null && subscription.equals("remove")) {
            Roster.SubscriptionType sub = Roster.getBuddySubscription(session, buddy);
            if (sub != null && sub != Roster.SubscriptionType.none) {
                Element it = new Element("item");
                it.setAttribute("jid", buddy);
                it.setAttribute("subscription", "remove");
                Roster.updateBuddyChange(session, results, it);
                Element pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getUserId());
                pres.setAttribute("type", "unsubscribe");
                results.offer(new Packet(pres));
                pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getUserId());
                pres.setAttribute("type", "unsubscribed");
                results.offer(new Packet(pres));
                pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getJID());
                pres.setAttribute("type", "unavailable");
                results.offer(new Packet(pres));
            }
            Roster.removeBuddy(session, buddy);
            results.offer(packet.okResult((String)null, 0));
        } else {
            List groups;
            String name = request.getAttribute("/iq/query/item", "name");
            if (name == null) {
                name = buddy;
            }
            Roster.setBuddyName(session, buddy, name);
            if (Roster.getBuddySubscription(session, buddy) == null) {
                Roster.setBuddySubscription(session, Roster.SubscriptionType.none, buddy);
            }
            if ((groups = item.getChildren()) != null && groups.size() > 0) {
                String[] gr = new String[groups.size()];
                int cnt = 0;
                for (Element group : groups) {
                    gr[cnt++] = group.getCData();
                }
                session.setDataList(Roster.groupNode(buddy), "groups", gr);
            } else {
                session.removeData(Roster.groupNode(buddy), "groups");
            }
            results.offer(packet.okResult((String)null, 0));
            Roster.updateBuddyChange(session, results, Roster.getBuddyItem(session, buddy));
        }
    }

    private void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        String[] buddies = Roster.getBuddies(session);
        if (buddies != null) {
            StringBuilder items = new StringBuilder();
            for (String buddy : buddies) {
                items.append(Roster.getBuddyItem(session, buddy));
            }
            results.offer(packet.okResult(items.toString(), 1));
        } else {
            results.offer(packet.okResult((String)null, 1));
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            if (packet.getElemFrom() != null && !session.getUserId().equals(JIDUtils.getNodeID((String)packet.getElemFrom()))) {
                log.warning("Roster request 'from' attribute doesn't match session userid: " + session.getUserId() + ", request: " + packet.getStringData());
                return;
            }
            StanzaType type = packet.getType();
            switch (type) {
                case get: {
                    this.processGetRequest(packet, session, results);
                    break;
                }
                case set: {
                    this.processSetRequest(packet, session, results);
                    break;
                }
                case result: {
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    break;
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received roster request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

