/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqCommand
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqCommand");
    private static final String XMLNS = "http://jabber.org/protocol/commands";
    private static final String ID = "http://jabber.org/protocol/commands";
    private static final String[] ELEMENTS = new String[]{"command"};
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/commands"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/commands"})};

    @Override
    public String id() {
        return "http://jabber.org/protocol/commands";
    }

    @Override
    public String[] supElements() {
        return Arrays.copyOf(ELEMENTS, ELEMENTS.length);
    }

    @Override
    public String[] supNamespaces() {
        return Arrays.copyOf(XMLNSS, XMLNSS.length);
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return Arrays.copyOf(DISCO_FEATURES, DISCO_FEATURES.length);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!packet.isCommand() || packet.getCommand() != Command.OTHER) {
            return;
        }
        try {
            log.finest("Received packet: " + packet.getStringData());
            String id = JIDUtils.getNodeID((String)packet.getElemTo());
            if (id.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId());
                result.setFrom(packet.getTo());
                results.offer(result);
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

