/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.auth.LoginHandler;
import tigase.db.AuthorizationException;
import tigase.db.UserAuthRepository;
import tigase.db.UserRepository;
import tigase.util.JIDUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.RepositoryAccess;
import tigase.xmpp.XMPPSession;

public class XMPPResourceConnection
extends RepositoryAccess {
    private static final Logger log = Logger.getLogger("tigase.xmpp.XMPPResourceConnection");
    private LoginHandler loginHandler = null;
    private XMPPSession parentSession = null;
    private String sessionId = null;
    private String resource = null;
    private long lastAccessed = 0L;
    private String domain = null;
    private String connectionId = null;
    private int priority = 0;
    private boolean dummy = false;
    private String userJid = null;
    private String userId = null;
    private Map<String, Object> sessionData = null;

    public XMPPResourceConnection(String connectionId, UserRepository rep, UserAuthRepository authRepo, LoginHandler loginHandler) {
        super(rep, authRepo);
        this.connectionId = connectionId;
        this.loginHandler = loginHandler;
        this.sessionData = new HashMap<String, Object>();
    }

    public final void putSessionData(String key, Object value) {
        this.lastAccessed = System.currentTimeMillis();
        this.sessionData.put(key, value);
    }

    public final Object getSessionData(String key) {
        this.lastAccessed = System.currentTimeMillis();
        return this.sessionData.get(key);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void streamClosed() {
        if (this.parentSession != null) {
            this.parentSession.streamClosed(this);
        }
        this.parentSession = null;
        this.resource = null;
        this.sessionId = null;
    }

    public void setParentSession(XMPPSession parent) {
        this.parentSession = parent;
        if (this.parentSession != null) {
            this.userId = JIDUtils.getNodeID((String)this.parentSession.getUserName(), (String)this.domain);
        }
    }

    public XMPPSession getParentSession() {
        return this.parentSession;
    }

    public final String getJID() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid;
    }

    @Override
    public final String getUserId() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userId;
    }

    @Override
    public final String getUserName() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getUserName();
    }

    public List<XMPPResourceConnection> getActiveSessions() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getActiveResources();
    }

    public String[] getAllResourcesJIDs() throws NotAuthorizedException {
        if (this.parentSession == null) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getJIDs();
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String argSessionId) {
        this.sessionId = argSessionId;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String argResource) throws NotAuthorizedException {
        this.resource = argResource;
        this.parentSession.resourceSet(this);
        this.userJid = this.getUserId() + (this.resource != null ? "/" + this.resource : "");
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long argLastAccessed) {
        this.lastAccessed = argLastAccessed;
    }

    public String getConnectionId() {
        this.lastAccessed = System.currentTimeMillis();
        return this.connectionId;
    }

    @Override
    public final void logout() throws NotAuthorizedException {
        this.loginHandler.handleLogout(this.getUserName(), this);
        this.streamClosed();
        super.logout();
    }

    @Override
    public Authorization unregister(String name_param) throws NotAuthorizedException {
        Authorization auth_res = super.unregister(name_param);
        if (auth_res == Authorization.AUTHORIZED) {
            List<XMPPResourceConnection> res_conn = this.parentSession.getActiveResources();
            for (XMPPResourceConnection res : res_conn) {
                if (res == this) continue;
                res.logout();
            }
            this.logout();
        }
        return auth_res;
    }

    @Override
    public final Authorization loginPlain(String user, String password) throws NotAuthorizedException, AuthorizationException {
        Authorization result = super.loginPlain(user, password);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final Authorization loginDigest(String user, String digest, String id, String alg) throws NotAuthorizedException, AuthorizationException {
        Authorization result = super.loginDigest(user, digest, id, alg);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final Authorization loginOther(Map<String, Object> props) throws NotAuthorizedException, AuthorizationException {
        Authorization result = super.loginOther(props);
        if (result == Authorization.AUTHORIZED) {
            String user = (String)props.get("user-id");
            String nick = JIDUtils.getNodeNick((String)user);
            if (nick == null) {
                nick = user;
            }
            this.loginHandler.handleLogin(nick, this);
        }
        return result;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }
}

