/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.XMPPDomBuilderHandler;
import tigase.xmpp.XMPPIOServiceListener;

public class XMPPIOService
extends IOService {
    private static final Logger log = Logger.getLogger("tigase.xmpp.XMPPIOService");
    private XMPPDomBuilderHandler domHandler = null;
    private SimpleParser parser = SingletonFactory.getParserInstance();
    private XMPPIOServiceListener serviceListener = null;
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Packet> receivedPackets = new ConcurrentLinkedQueue();

    public XMPPIOService() {
        this.domHandler = new XMPPDomBuilderHandler(this);
    }

    public void setIOServiceListener(XMPPIOServiceListener sl) {
        this.serviceListener = sl;
        super.setIOServiceListener(sl);
    }

    protected void xmppStreamOpened(Map<String, String> attribs) {
        if (this.serviceListener != null) {
            String response = this.serviceListener.streamOpened(this, attribs);
            try {
                log.finest("Sending data: " + response);
                this.writeRawData(response);
                assert (this.debug(response, "--SENT:"));
                if (response != null && response.endsWith("</stream:stream>")) {
                    this.stop();
                }
            }
            catch (IOException e) {
                log.warning("Error sending stream open data: " + e);
                this.stop();
            }
        }
    }

    public void xmppStreamOpen(String data) {
        try {
            log.finest("Sending data: " + data);
            this.writeRawData(data);
            assert (this.debug(data, "--SENT:"));
        }
        catch (IOException e) {
            log.warning("Error sending stream open data: " + e);
            this.stop();
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    protected void xmppStreamClosed() {
        if (this.serviceListener != null) {
            this.serviceListener.streamClosed(this);
        }
        try {
            log.finest("Sending data: </stream:stream>");
            this.writeRawData("</stream:stream>");
        }
        catch (IOException e) {
            log.warning("Error sending stream closed data: " + e);
        }
    }

    public void addPacketToSend(Packet packet) {
        this.waitingPackets.offer(packet);
    }

    public Queue<Packet> getReceivedPackets() {
        return this.receivedPackets;
    }

    @Override
    public void processWaitingPackets() throws IOException {
        Packet packet = null;
        while ((packet = this.waitingPackets.poll()) != null) {
            log.finer("Processing packet: " + packet.getElemName() + ", type: " + (Object)((Object)packet.getType()));
            log.finest("Sending packet: " + packet.getStringData());
            this.writeRawData(packet.getStringData());
            assert (this.debug(packet.getStringData(), "--SENT:"));
        }
    }

    public void writeRawData(String data) throws IOException {
        this.writeData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSocketData() throws IOException {
        block7: {
            if (!this.isConnected()) break block7;
            char[] data = this.readData();
            if (!this.isConnected() || data == null) break block7;
            log.finest("READ:\n" + new String(data));
            assert (this.debug(new String(data), "--RECEIVED:"));
            try {
                this.parser.parse((SimpleHandler)this.domHandler, data, 0, data.length);
                Queue<Element> elems = this.domHandler.getParsedElements();
                if (elems.size() > 0) {
                    this.readCompleted();
                }
                Element elem = null;
                while ((elem = elems.poll()) != null) {
                    log.finer("Read element: " + elem.getName());
                    log.finest("Read packet: " + elem.toString());
                    this.addReceivedPacket(new Packet(elem));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.stop();
            }
        }
    }

    @Override
    protected int receivedPackets() {
        return this.receivedPackets.size();
    }

    private void addReceivedPacket(Packet packet) {
        this.receivedPackets.offer(packet);
    }
}

