/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Map;
import tigase.util.DNSResolver;

public class SessionManagerConfig {
    public static final String USER_REPO_CLASS_PROP_KEY = "user-repo-class";
    public static final String USER_REPO_URL_PROP_KEY = "user-repo-url";
    public static final String AUTH_REPO_CLASS_PROP_KEY = "auth-repo-class";
    public static final String AUTH_REPO_URL_PROP_KEY = "auth-repo-url";
    public static final String PLUGINS_PROP_KEY = "plugins";
    private static final String[] PLUGINS_NO_REG_PROP_VAL = new String[]{"jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "presence", "msgoffline", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping"};
    private static final String[] PLUGINS_FULL_PROP_VAL = new String[]{"jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "presence", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "msgoffline", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping"};
    private static String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    private static String[] ADMINS_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};

    public static void getDefaults(Map<String, Object> props, Map<String, Object> params) {
        boolean full_comps = true;
        String user_repo_class = "tigase.db.xml.XMLRepository";
        String user_repo_url = "user-repository.xml";
        String auth_repo_class = "tigase.db.xml.XMLRepository";
        String auth_repo_url = "user-repository.xml";
        if (params.get("--user-db") != null) {
            if (params.get("--user-db").equals("mysql")) {
                user_repo_class = "tigase.db.jdbc.JDBCRepository";
                user_repo_url = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (params.get("--user-db").equals("pgsql")) {
                user_repo_class = "tigase.db.jdbc.JDBCRepository";
                user_repo_url = "jdbc:postgresql://localhost/tigase?user=tigase";
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
        }
        if (params.get("--user-db-uri") != null) {
            auth_repo_url = user_repo_url = (String)params.get("--user-db-uri");
        }
        if (params.get("--auth-db") != null) {
            if (params.get("--auth-db").equals("mysql")) {
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (params.get("--auth-db").equals("pgsql")) {
                auth_repo_class = "tigase.db.jdbc.JDBCRepository";
                auth_repo_url = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
            if (params.get("--auth-db").equals("drupal")) {
                auth_repo_class = "tigase.db.jdbc.DrupalAuth";
                auth_repo_url = "jdbc:mysql://localhost/drupal?user=root&password=mypass";
                user_repo_url = user_repo_url + "&autoCreateUser=true";
                full_comps = false;
            }
            if (params.get("--auth-db").equals("libresource")) {
                auth_repo_class = "tigase.db.jdbc.LibreSourceAuth";
                auth_repo_url = "jdbc:postgresql://localhost/libresource?user=demo";
                user_repo_url = user_repo_url + "&autoCreateUser=true";
                full_comps = false;
            }
        }
        if (params.get("--auth-db-uri") != null) {
            auth_repo_url = (String)params.get("--auth-db-uri");
        }
        props.put(USER_REPO_CLASS_PROP_KEY, user_repo_class);
        props.put(USER_REPO_URL_PROP_KEY, user_repo_url);
        props.put(AUTH_REPO_CLASS_PROP_KEY, auth_repo_class);
        props.put(AUTH_REPO_URL_PROP_KEY, auth_repo_url);
        if (full_comps) {
            props.put(PLUGINS_PROP_KEY, PLUGINS_FULL_PROP_VAL);
        } else {
            props.put(PLUGINS_PROP_KEY, PLUGINS_NO_REG_PROP_VAL);
        }
        HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        props.put("hostnames", HOSTNAMES_PROP_VAL);
        if (params.get("--admins") != null) {
            ADMINS_PROP_VAL = ((String)params.get("--admins")).split(",");
        } else {
            ADMINS_PROP_VAL = new String[HOSTNAMES_PROP_VAL.length];
            for (int i = 0; i < ADMINS_PROP_VAL.length; ++i) {
                SessionManagerConfig.ADMINS_PROP_VAL[i] = "admin@" + HOSTNAMES_PROP_VAL[i];
            }
        }
        props.put("admins", ADMINS_PROP_VAL);
    }
}

