/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ssender;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.ssender.SenderTask;
import tigase.server.ssender.StanzaHandler;

public class JDBCTask
extends SenderTask {
    private static final Logger log = Logger.getLogger("tigase.server.ssender.JDBCTask");
    private StanzaHandler handler = null;
    private String db_conn = null;
    private Connection conn = null;
    private PreparedStatement get_all_stanzas = null;
    private PreparedStatement remove_stanza = null;
    private PreparedStatement conn_valid_st = null;
    private String tableName = "xmpp_stanza";
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;

    private void release(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean checkConnection() throws SQLException {
        try {
            long tmp = System.currentTimeMillis();
            if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                this.conn_valid_st.executeQuery();
                this.lastConnectionValidated = tmp;
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    private void findTableName(String db_str) {
        String[] params;
        for (String par : params = db_str.split("&")) {
            if (!par.startsWith("table=")) continue;
            this.tableName = par.substring("table=".length(), par.length());
            break;
        }
    }

    private void initRepo() throws SQLException {
        this.conn = DriverManager.getConnection(this.db_conn);
        this.conn.setAutoCommit(true);
        String query = "select localtime";
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "select id, stanza from " + this.tableName;
        this.get_all_stanzas = this.conn.prepareStatement(query);
        query = "delete from " + this.tableName + " where id = ?";
        this.remove_stanza = this.conn.prepareStatement(query);
    }

    @Override
    public void init(StanzaHandler handler, String initString) throws IOException {
        this.handler = handler;
        this.db_conn = initString;
        this.findTableName(this.db_conn);
        try {
            this.initRepo();
        }
        catch (SQLException e) {
            throw new IOException("Problem initializing SenderTask.", e);
        }
    }

    @Override
    public String getInitString() {
        return this.db_conn;
    }

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        try {
            this.conn_valid_st.close();
            this.get_all_stanzas.close();
            this.remove_stanza.close();
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet rs = null;
        try {
            this.checkConnection();
            rs = this.get_all_stanzas.executeQuery();
            HashSet<Long> ids_to_delete = new HashSet<Long>();
            while (rs.next()) {
                ids_to_delete.add(rs.getLong("id"));
                String stanza = rs.getString("stanza");
                this.handler.handleStanza(stanza);
                log.finest("Sent stanza found in database: " + stanza);
            }
            Iterator i$ = ids_to_delete.iterator();
            while (i$.hasNext()) {
                long id = (Long)i$.next();
                this.remove_stanza.setLong(1, id);
                this.remove_stanza.executeUpdate();
            }
            this.release(rs);
            rs = null;
        }
        catch (SQLException e) {
            try {
                log.log(Level.WARNING, "Error retrieving stanzas from database: ", e);
                this.release(rs);
                rs = null;
            }
            catch (Throwable throwable) {
                this.release(rs);
                rs = null;
                throw throwable;
            }
        }
    }
}

