/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class BoshSession {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshSession");
    private static final long SECOND = 1000L;
    private UUID sid = null;
    private Queue<BoshIOService> connections = new LinkedList<BoshIOService>();
    private Queue<Packet> waiting_packets = new LinkedList<Packet>();
    private BoshSessionTaskHandler handler = null;
    private long max_wait = 60L;
    private long min_polling = 10L;
    private long max_inactivity = 60L;
    private int concurrent_requests = 2;
    private int hold_requests = 1;
    private long max_pause = 120L;
    private String content_type = "text/xml; charset=utf-8";
    private String domain = null;
    private String sessionId = null;
    private boolean terminate = false;
    private Map<TimerTask, TimedTask> task_enum = new LinkedHashMap<TimerTask, TimedTask>();
    private EnumMap<TimedTask, TimerTask> enum_task = new EnumMap(TimedTask.class);

    public BoshSession(String def_domain, BoshSessionTaskHandler handler) {
        this.sid = UUID.randomUUID();
        this.domain = def_domain;
        this.handler = handler;
    }

    public void init(Packet packet, BoshIOService service, long max_wait, long min_polling, long max_inactivity, int concurrent_requests, int hold_requests, long max_pause, Queue<Packet> out_results) {
        long wait_l = max_wait;
        String wait_s = packet.getAttribute("wait");
        if (wait_s != null) {
            try {
                wait_l = Long.parseLong(wait_s);
            }
            catch (NumberFormatException e) {
                wait_l = max_wait;
            }
        }
        this.max_wait = Math.min(wait_l, max_wait);
        int hold_i = hold_requests;
        String hold_s = packet.getAttribute("hold");
        if (hold_s != null) {
            try {
                hold_i = Integer.parseInt(hold_s);
            }
            catch (NumberFormatException e) {
                hold_i = hold_requests;
            }
        }
        this.hold_requests = Math.max(hold_i, hold_requests);
        if (packet.getAttribute("to") != null) {
            this.domain = packet.getAttribute("to");
        }
        this.min_polling = min_polling;
        this.max_inactivity = max_inactivity;
        this.concurrent_requests = concurrent_requests;
        this.max_pause = max_pause;
        if (packet.getAttribute("content") != null) {
            this.content_type = packet.getAttribute("content");
        }
        service.setContentType(this.content_type);
        Element body = new Element("body", new String[]{"wait", "inactivity", "polling", "requests", "hold", "maxpause", "sid", "ver", "from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{Long.valueOf(this.max_wait).toString(), Long.valueOf(this.max_inactivity).toString(), Long.valueOf(this.min_polling).toString(), Integer.valueOf(this.concurrent_requests).toString(), Integer.valueOf(this.hold_requests).toString(), Long.valueOf(this.max_pause).toString(), this.sid.toString(), "1.6", this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
        this.sessionId = UUID.randomUUID().toString();
        body.setAttribute("authid", this.sessionId);
        body.setXMLNS("http://jabber.org/protocol/httpbind");
        this.sendBody(service, body);
        Packet streamOpen = Command.STREAM_OPENED.getPacket(null, null, StanzaType.set, "sess1", "submit");
        Command.addFieldValue(streamOpen, "session-id", this.sessionId);
        Command.addFieldValue(streamOpen, "hostname", this.domain);
        out_results.offer(streamOpen);
        out_results.offer(Command.GETFEATURES.getPacket(null, null, StanzaType.get, "sess1", null));
    }

    public UUID getSid() {
        return this.sid;
    }

    public String getDomain() {
        return this.domain;
    }

    public synchronized void processPacket(Packet packet, Queue<Packet> out_results) {
        if (packet != null) {
            log.finest("[" + this.connections.size() + "] Processing packet: " + packet.toString());
            this.waiting_packets.offer(packet);
        }
        if (this.connections.size() > 0 && this.waiting_packets.size() > 0) {
            BoshIOService serv = this.connections.poll();
            this.sendBody(serv, null);
        }
    }

    private void sendBody(BoshIOService serv, Element body_par) {
        Element body = body_par;
        if (body == null) {
            body = new Element("body", new String[]{"from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
            body.setXMLNS("http://jabber.org/protocol/httpbind");
            for (Packet pack : this.waiting_packets) {
                body.addChild(pack.getElement());
            }
        }
        try {
            if (this.terminate) {
                body.setAttribute("type", StanzaType.terminate.toString());
            }
            serv.writeRawData(body.toString());
            this.waiting_packets.clear();
            serv.stop();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "[" + this.connections.size() + "] Exception during writing to socket", e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "[" + this.connections.size() + "] Exception during writing to socket", e);
        }
        serv.setSid(null);
        this.disconnected(serv);
        TimerTask tt = this.enum_task.remove((Object)TimedTask.EMPTY_RESP);
        if (tt != null) {
            this.task_enum.remove(tt);
            this.handler.cancelTask(tt);
        }
    }

    public synchronized void processSocketPacket(Packet packet, BoshIOService service, Queue<Packet> out_results) {
        log.finest("[" + this.connections.size() + "] Processing socket packet: " + packet.toString());
        TimerTask tt = this.enum_task.remove((Object)TimedTask.STOP);
        if (tt != null) {
            this.task_enum.remove(tt);
            this.handler.cancelTask(tt);
        }
        service.setContentType(this.content_type);
        service.setSid(this.sid);
        this.connections.offer(service);
        if (packet.getElemName().equals("body")) {
            List<Element> children;
            if (packet.getType() != null && packet.getType() == StanzaType.terminate) {
                this.max_pause = 2L;
                this.terminate = true;
            }
            if ((children = packet.getElemChildren("body")) != null) {
                for (Element el : children) {
                    if (el.getXMLNS().equals("http://jabber.org/protocol/httpbind")) {
                        el.setXMLNS("jabber:client");
                    }
                    Packet result = new Packet(el);
                    log.finest("Sending out packet: " + result.toString());
                    out_results.offer(result);
                }
            }
        } else {
            log.warning("[" + this.connections.size() + "] Unexpected packet from the network: " + packet.toString());
        }
        this.processPacket(null, out_results);
        if (this.connections.size() > 1) {
            BoshIOService serv = this.connections.poll();
            this.sendBody(serv, null);
        }
        tt = this.enum_task.get((Object)TimedTask.EMPTY_RESP);
        if (this.connections.size() > 0 && this.waiting_packets.size() == 0 && tt == null) {
            tt = this.handler.scheduleTask(this, this.max_wait * 1000L);
            this.task_enum.put(tt, TimedTask.EMPTY_RESP);
            this.enum_task.put(TimedTask.EMPTY_RESP, tt);
        }
    }

    public synchronized void disconnected(BoshIOService bios) {
        if (bios != null) {
            this.connections.remove(bios);
        }
        TimerTask tt = this.enum_task.get((Object)TimedTask.STOP);
        if (this.connections.size() == 0 && tt == null) {
            tt = this.handler.scheduleTask(this, this.max_pause * 1000L);
            this.task_enum.put(tt, TimedTask.STOP);
            this.enum_task.put(TimedTask.STOP, tt);
        }
    }

    public synchronized boolean task(Queue<Packet> out_results, TimerTask tt) {
        block10: {
            block9: {
                TimedTask ttask = this.task_enum.remove(tt);
                if (ttask == null) break block9;
                this.enum_task.remove((Object)ttask);
                switch (ttask) {
                    case STOP: {
                        for (TimerTask ttemp : this.task_enum.keySet()) {
                            this.handler.cancelTask(ttemp);
                        }
                        for (Packet packet : this.waiting_packets) {
                            try {
                                out_results.offer(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "Bosh = disconnected", true));
                            }
                            catch (PacketErrorTypeException e) {
                                log.warning("Packet processing exception: " + e);
                            }
                        }
                        Packet command2 = Command.STREAM_CLOSED.getPacket(null, null, StanzaType.set, "sess1");
                        out_results.offer(command2);
                        return true;
                    }
                    case EMPTY_RESP: {
                        BoshIOService serv = this.connections.poll();
                        if (serv != null) {
                            this.sendBody(serv, null);
                            break;
                        }
                        break block10;
                    }
                    default: {
                        log.warning("[" + this.connections.size() + "] Uknown TimedTask value: " + ttask.toString());
                        break;
                    }
                }
                break block10;
            }
            log.warning("[" + this.connections.size() + "] TimedTask enum is null for scheduled task....");
        }
        return false;
    }

    private static enum TimedTask {
        EMPTY_RESP,
        STOP;

    }
}

