/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.IOException;
import java.util.UUID;
import java.util.logging.Logger;
import tigase.xmpp.XMPPIOService;

public class BoshIOService
extends XMPPIOService {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshIOService");
    private UUID sid = null;
    private static final String EOL = "\r\n";
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK\r\n";
    private static final String CONTENT_TYPE_HEADER = "Content-Type: ";
    private static final String CONTENT_TYPE_LENGTH = "Content-Length: ";
    private String content_type = "text/xml; charset=utf-8";

    public void setContentType(String ct) {
        this.content_type = ct;
    }

    @Override
    public void writeRawData(String data) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(HTTP_RESPONSE);
        sb.append(CONTENT_TYPE_HEADER + this.content_type + EOL);
        sb.append(CONTENT_TYPE_LENGTH + data.getBytes().length + EOL);
        sb.append(EOL);
        sb.append(data);
        log.finest("Writing to socket:\n" + sb.toString());
        super.writeRawData(sb.toString());
    }

    public void setSid(UUID sid) {
        this.sid = sid;
    }

    public UUID getSid() {
        return this.sid;
    }
}

