/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.ComponentRegistrator;
import tigase.server.MessageReceiver;
import tigase.server.MessageRouterConfig;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.stats.StatRecord;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class MessageRouter
extends AbstractMessageReceiver {
    public static final String INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    public static final String ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    private static final Logger log = Logger.getLogger("tigase.server.MessageRouter");
    private static final long startupTime = System.currentTimeMillis();
    private Set<String> localAddresses = new CopyOnWriteArraySet<String>();
    private ComponentRegistrator config = null;
    private ServiceEntity serviceEntity = null;
    private Map<String, XMPPService> xmppServices = new ConcurrentSkipListMap<String, XMPPService>();
    private Map<String, ServerComponent> components = new ConcurrentSkipListMap<String, ServerComponent>();
    private Map<String, ComponentRegistrator> registrators = new ConcurrentSkipListMap<String, ComponentRegistrator>();
    private Map<String, MessageReceiver> receivers = new ConcurrentSkipListMap<String, MessageReceiver>();
    private boolean inProperties = false;

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        String to = packet.getTo();
        for (ServerComponent comp : this.components.values()) {
            if (comp == this) continue;
            comp.processPacket(packet, results);
        }
        if (packet.isXMLNS("/iq/query", INFO_XMLNS) || packet.isXMLNS("/iq/query", ITEMS_XMLNS) && packet.getType() != null && packet.getType() == StanzaType.get) {
            this.processDiscoQuery(packet, results);
        }
        if (!to.startsWith(this.getName())) {
            return;
        }
        if (packet.getPermissions() != Permissions.ADMIN) {
            try {
                Packet res = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized for this action.", true);
                results.offer(res);
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        log.finest("Command received: " + packet.getStringData());
        switch (packet.getCommand()) {
            case OTHER: {
                String[] spl;
                String cmd;
                if (packet.getStrCommand() == null || !packet.getStrCommand().startsWith("controll/") || !(cmd = (spl = packet.getStrCommand().split("/"))[1]).equals("stop")) break;
                Packet result = packet.commandResult("result");
                results.offer(result);
                new Timer("Stopping...", true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }, 2000L);
                break;
            }
        }
    }

    private String isToLocalComponent(String jid) {
        for (String name : this.components.keySet()) {
            for (String hostname : this.localAddresses) {
                if (!jid.equals(name + "." + hostname)) continue;
                return name;
            }
        }
        return null;
    }

    private boolean isLocalDomain(String domain) {
        return this.localAddresses.contains(domain);
    }

    @Override
    public void processPacket(Packet packet) {
        if (packet.getTo() == null) {
            log.warning("Packet with TO attribute set to NULL: " + packet.getStringData());
            return;
        }
        if (packet.getTo() == "NULL") {
            log.info("NULL routing, it is normal if server doesn't know how to process packet: " + packet.toString());
            try {
                Packet error = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not supported yet.", true);
                this.addOutPacketNB(error);
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        log.finer("Processing packet: " + packet.getElemName() + ", type: " + (Object)((Object)packet.getType()));
        log.finest("Processing packet: " + packet.getStringData() + ", to: " + packet.getTo() + ", from: " + packet.getFrom());
        String id = JIDUtils.getNodeID((String)packet.getTo());
        String local_comp_name = this.isToLocalComponent(id);
        if (this.localAddresses.contains(id) || local_comp_name != null) {
            if (packet.getFrom() != null && packet.getFrom().equals(packet.getTo()) || packet.getFrom() == "NULL" && packet.getElemFrom() != null && packet.getElemFrom().equals(packet.getTo())) {
                log.warning("Possible infinite loop, dropping packet: " + packet.toString());
                return;
            }
            log.finest("This packet is addressed to server itself.");
            LinkedList<Packet> results = new LinkedList<Packet>();
            this.processPacket(packet, results);
            if (results.size() > 0) {
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
                return;
            }
        }
        String host = JIDUtils.getNodeHost((String)packet.getTo());
        String nick = JIDUtils.getNodeNick((String)packet.getTo());
        MessageReceiver first = null;
        if (nick != null) {
            first = this.receivers.get(nick);
        }
        if (first != null) {
            Set<String> routings = first.getRoutings();
            if (routings != null) {
                log.finest(first.getName() + ": Looking for host: " + host + " in " + routings.toString());
                if (routings.contains(host)) {
                    log.finest("Found receiver: " + first.getName());
                    first.addPacket(packet);
                    return;
                }
            } else {
                log.severe("Routings are null for: " + first.getName());
            }
        }
        MessageReceiver s2s = null;
        for (MessageReceiver mr : this.receivers.values()) {
            Set<String> routings = mr.getRoutings();
            if (routings != null) {
                log.finest(mr.getName() + ": Looking for host: " + host + " in " + routings.toString());
                if (routings.contains(host) || routings.contains(id)) {
                    log.finest("Found receiver: " + mr.getName());
                    mr.addPacket(packet);
                    return;
                }
                if (mr.isInRegexRoutings(id)) {
                    log.finest("Found receiver: " + mr.getName());
                    mr.addPacket(packet);
                    return;
                }
                if (!routings.contains("*")) continue;
                s2s = mr;
                continue;
            }
            log.severe("Routings are null for: " + mr.getName());
        }
        if (this.localAddresses.contains(JIDUtils.getNodeHost((String)packet.getTo())) || local_comp_name != null) {
            try {
                this.addOutPacketNB(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Your request can not be processed.", true));
            }
            catch (PacketErrorTypeException e) {
                log.warning("Can't process packet to local domain, dropping..." + packet.toString());
            }
            return;
        }
        if (s2s != null) {
            s2s.addPacket(packet);
        }
    }

    public void setConfig(ComponentRegistrator config) {
        this.components.put(this.getName(), this);
        this.config = config;
        this.addRegistrator(config);
    }

    public void addRegistrator(ComponentRegistrator registr) {
        log.info("Adding registrator: " + registr.getClass().getSimpleName());
        this.registrators.put(registr.getName(), registr);
        this.addComponent(registr);
        for (ServerComponent comp : this.components.values()) {
            registr.addComponent(comp);
        }
    }

    public void addRouter(MessageReceiver receiver) {
        log.info("Adding receiver: " + receiver.getClass().getSimpleName());
        this.addComponent(receiver);
        this.receivers.put(receiver.getName(), receiver);
    }

    public void addComponent(ServerComponent component) {
        log.info("Adding component: " + component.getClass().getSimpleName());
        for (ComponentRegistrator registr : this.registrators.values()) {
            if (registr == component) continue;
            log.finer("Adding: " + component.getName() + " component to " + registr.getName() + " registrator.");
            registr.addComponent(component);
        }
        this.components.put(component.getName(), component);
        if (component instanceof XMPPService) {
            this.xmppServices.put(component.getName(), (XMPPService)component);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        MessageRouterConfig.getDefaults(defs, params, this.getName());
        return defs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Map<String, Object> props) {
        if (this.inProperties) {
            return;
        }
        this.inProperties = true;
        this.serviceEntity = new ServiceEntity("Tigase", "server", "Session manager");
        this.serviceEntity.addIdentities(new ServiceIdentity("server", "im", "Tigase ver. " + XMPPServer.getImplementationVersion()));
        this.serviceEntity.addFeatures(XMPPService.DEF_FEATURES);
        try {
            String[] msgrcv_names;
            String[] reg_names;
            super.setProperties(props);
            String[] localAddresses = (String[])props.get("hostnames");
            this.localAddresses.clear();
            if (localAddresses != null && localAddresses.length > 0) {
                Collections.addAll(this.localAddresses, localAddresses);
            }
            Map<String, ComponentRegistrator> tmp_reg = this.registrators;
            Map<String, MessageReceiver> tmp_rec = this.receivers;
            this.components = new TreeMap<String, ServerComponent>();
            this.registrators = new TreeMap<String, ComponentRegistrator>();
            this.receivers = new TreeMap<String, MessageReceiver>();
            this.setConfig(this.config);
            MessageRouterConfig conf = new MessageRouterConfig(props);
            for (String name : reg_names = conf.getRegistrNames()) {
                ComponentRegistrator cr = tmp_reg.remove(name);
                String cls_name = (String)props.get("components/registrators/" + name + ".class");
                try {
                    if (cr == null || !cr.getClass().getName().equals(cls_name)) {
                        if (cr != null) {
                            cr.release();
                        }
                        cr = conf.getRegistrInstance(name);
                        cr.setName(name);
                    }
                    this.addRegistrator(cr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (ComponentRegistrator cr : tmp_reg.values()) {
                cr.release();
            }
            tmp_reg.clear();
            for (String name : msgrcv_names = conf.getMsgRcvNames()) {
                log.finer("Loading and registering message receiver: " + name);
                MessageReceiver mr = tmp_rec.remove(name);
                String cls_name = (String)props.get("components/msg-receivers/" + name + ".class");
                try {
                    if (mr == null || !mr.getClass().getName().equals(cls_name)) {
                        if (mr != null) {
                            mr.release();
                        }
                        mr = conf.getMsgRcvInstance(name);
                        mr.setParent(this);
                        mr.setName(name);
                        mr.start();
                    }
                    this.addRouter(mr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (MessageReceiver mr : tmp_rec.values()) {
                mr.release();
            }
            tmp_rec.clear();
        }
        finally {
            this.inProperties = false;
        }
    }

    private void processDiscoQuery(Packet packet, Queue<Packet> results) {
        String jid = packet.getElemTo();
        String node = packet.getAttribute("/iq/query", "node");
        Element query = packet.getElement().getChild("query").clone();
        if (packet.isXMLNS("/iq/query", INFO_XMLNS)) {
            if (this.isLocalDomain(jid)) {
                query = this.getDiscoInfo(node, jid);
                for (XMPPService comp : this.xmppServices.values()) {
                    List<Element> features = comp.getDiscoFeatures();
                    if (features == null) continue;
                    query.addChildren(features);
                }
            } else {
                for (XMPPService comp : this.xmppServices.values()) {
                    Element resp = comp.getDiscoInfo(node, jid);
                    if (resp == null) continue;
                    query = resp;
                    break;
                }
            }
        }
        if (packet.isXMLNS("/iq/query", ITEMS_XMLNS)) {
            boolean localDomain = this.isLocalDomain(jid);
            for (XMPPService comp : this.xmppServices.values()) {
                List<Element> items;
                if (!localDomain && !jid.startsWith(comp.getName() + ".") || (items = comp.getDiscoItems(node, jid)) == null || items.size() <= 0) continue;
                query.addChildren(items);
            }
        }
        results.offer(packet.okResult(query, 0));
    }

    public Element getDiscoInfo(String node, String jid) {
        Element query = this.serviceEntity.getDiscoInfo(null);
        log.finest("Returing disco-info: " + query.toString());
        return query;
    }

    public List<Element> getDiscoItems(String node, String jid) {
        return null;
    }

    @Override
    public List<StatRecord> getStatistics() {
        List<StatRecord> stats = super.getStatistics();
        long uptime = System.currentTimeMillis() - startupTime;
        long days = uptime / 86400000L;
        long hours = (uptime - days * 24L * 3600000L) / 3600000L;
        long minutes = (uptime - (days * 24L * 3600000L + hours * 3600000L)) / 60000L;
        long seconds = (uptime - (days * 24L * 3600000L + hours * 3600000L + minutes * 60000L)) / 1000L;
        stats.add(new StatRecord(this.getName(), "Uptime", "time", "" + (days > 0L ? days + " day, " : "") + (hours > 0L ? hours + " hour, " : "") + (minutes > 0L ? minutes + " min, " : "") + (seconds > 0L ? seconds + " sec" : ""), Level.INFO));
        return stats;
    }
}

