/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.conf.Configurable;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.util.DNSResolver;

public abstract class AbstractMessageReceiver
implements StatisticsContainer,
MessageReceiver,
Configurable {
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private String DEF_HOSTNAME_PROP_VAL = "localhost";
    public static final String MAX_QUEUE_SIZE_PROP_KEY = "max-queue-size";
    public static final Integer MAX_QUEUE_SIZE_PROP_VAL = 1000;
    private static final Logger log = Logger.getLogger("tigase.server.AbstractMessageReceiver");
    private int maxQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    private String defHostname = this.DEF_HOSTNAME_PROP_VAL;
    private MessageReceiver parent = null;
    private LinkedBlockingQueue<QueueElement> in_queue = new LinkedBlockingQueue(this.maxQueueSize);
    private LinkedBlockingQueue<QueueElement> out_queue = new LinkedBlockingQueue(this.maxQueueSize);
    private Timer receiverTasks = null;
    private Thread in_thread = null;
    private Thread out_thread = null;
    private boolean stopped = false;
    private String name = null;
    private Set<String> routings = new CopyOnWriteArraySet<String>();
    private Set<Pattern> regexRoutings = new CopyOnWriteArraySet<Pattern>();
    private long curr_second = 0L;
    private long curr_minute = 0L;
    private long curr_hour = 0L;
    private long[] seconds = new long[60];
    private int sec_idx = 0;
    private long[] minutes = new long[60];
    private int min_idx = 0;
    private long statAddedMessagesOk = 0L;
    private long statAddedMessagesEr = 0L;

    public String myDomain() {
        return this.getName() + "." + this.defHostname;
    }

    @Override
    public boolean addPacket(Packet packet) {
        return this.prAddPacket(packet);
    }

    @Override
    public boolean addPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.prAddPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean prAddPacket(Packet packet) {
        try {
            this.in_queue.put(new QueueElement(QueueElementType.IN_QUEUE, packet));
            ++this.statAddedMessagesOk;
            ++this.curr_second;
        }
        catch (InterruptedException e) {
            ++this.statAddedMessagesEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPacket(Packet packet) {
        try {
            this.out_queue.put(new QueueElement(QueueElementType.OUT_QUEUE, packet));
            ++this.statAddedMessagesOk;
            ++this.curr_second;
        }
        catch (InterruptedException e) {
            ++this.statAddedMessagesEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPacketNB(Packet packet) {
        log.finest(">" + this.getName() + "<  " + "Adding packet to outQueue: " + packet.getStringData());
        boolean result = this.out_queue.offer(new QueueElement(QueueElementType.OUT_QUEUE, packet));
        if (result) {
            ++this.statAddedMessagesOk;
            ++this.curr_second;
        } else {
            ++this.statAddedMessagesEr;
        }
        return result;
    }

    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addOutPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    public abstract void processPacket(Packet var1);

    @Override
    public List<StatRecord> getStatistics() {
        LinkedList<StatRecord> stats = new LinkedList<StatRecord>();
        stats.add(new StatRecord(this.getName(), "Last second packets", "int", this.seconds[this.sec_idx == 0 ? 59 : this.sec_idx - 1], Level.FINE));
        stats.add(new StatRecord(this.getName(), "Last minute packets", "int", this.minutes[this.min_idx == 0 ? 59 : this.min_idx - 1], Level.FINE));
        stats.add(new StatRecord(this.getName(), "Last hour packets", "int", this.curr_hour, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.MSG_RECEIVED_OK, this.statAddedMessagesOk, Level.FINE));
        stats.add(new StatRecord(this.getName(), StatisticType.QUEUE_SIZE, this.in_queue.size() + this.out_queue.size(), Level.FINEST));
        stats.add(new StatRecord(this.getName(), StatisticType.QUEUE_OVERFLOW, this.statAddedMessagesEr, Level.FINEST));
        return stats;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        int queueSize = (Integer)properties.get(MAX_QUEUE_SIZE_PROP_KEY);
        this.setMaxQueueSize(queueSize);
        this.defHostname = (String)properties.get("def-hostname");
        this.addRouting(this.myDomain());
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (this.maxQueueSize != maxQueueSize) {
            LinkedBlockingQueue<QueueElement> newQueue;
            this.stopThreads();
            this.maxQueueSize = maxQueueSize;
            if (this.in_queue != null) {
                newQueue = new LinkedBlockingQueue<QueueElement>(maxQueueSize);
                newQueue.addAll(this.in_queue);
                this.in_queue = newQueue;
            }
            if (this.out_queue != null) {
                newQueue = new LinkedBlockingQueue(maxQueueSize);
                newQueue.addAll(this.out_queue);
                this.out_queue = newQueue;
            }
            this.startThreads();
        }
    }

    protected Integer getDefMaxQueueSize() {
        return MAX_QUEUE_SIZE_PROP_VAL;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        defs.put(MAX_QUEUE_SIZE_PROP_KEY, this.getDefMaxQueueSize());
        this.DEF_HOSTNAME_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",")[0] : DNSResolver.getDefHostNames()[0];
        defs.put("def-hostname", this.DEF_HOSTNAME_PROP_VAL);
        return defs;
    }

    @Override
    public void release() {
        this.stop();
    }

    @Override
    public void setParent(MessageReceiver parent) {
        this.parent = parent;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void stopThreads() {
        this.stopped = true;
        try {
            if (this.in_thread != null) {
                this.in_thread.interrupt();
                while (this.in_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
            if (this.out_thread != null) {
                this.out_thread.interrupt();
                while (this.out_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.in_thread = null;
        this.out_thread = null;
        this.receiverTasks.cancel();
        this.receiverTasks = null;
    }

    private void startThreads() {
        if (this.in_thread == null || !this.in_thread.isAlive()) {
            this.stopped = false;
            this.in_thread = new Thread(new QueueListener(this.in_queue));
            this.in_thread.setName("in_" + this.name);
            this.in_thread.start();
        }
        if (this.out_thread == null || !this.out_thread.isAlive()) {
            this.stopped = false;
            this.out_thread = new Thread(new QueueListener(this.out_queue));
            this.out_thread.setName("out_" + this.name);
            this.out_thread.start();
        }
        this.receiverTasks = new Timer(this.getName() + " tasks", true);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.curr_minute -= AbstractMessageReceiver.this.seconds[AbstractMessageReceiver.this.sec_idx];
                ((AbstractMessageReceiver)AbstractMessageReceiver.this).seconds[((AbstractMessageReceiver)AbstractMessageReceiver.this).sec_idx] = AbstractMessageReceiver.this.curr_second;
                AbstractMessageReceiver.this.curr_second = 0L;
                AbstractMessageReceiver.this.curr_minute += AbstractMessageReceiver.this.seconds[AbstractMessageReceiver.this.sec_idx++];
                if (AbstractMessageReceiver.this.sec_idx >= 60) {
                    AbstractMessageReceiver.this.sec_idx = 0;
                }
            }
        }, 1000L, 1000L);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.curr_hour -= AbstractMessageReceiver.this.minutes[AbstractMessageReceiver.this.min_idx];
                ((AbstractMessageReceiver)AbstractMessageReceiver.this).minutes[((AbstractMessageReceiver)AbstractMessageReceiver.this).min_idx] = AbstractMessageReceiver.this.curr_minute;
                AbstractMessageReceiver.this.curr_hour += AbstractMessageReceiver.this.minutes[AbstractMessageReceiver.this.min_idx++];
                if (AbstractMessageReceiver.this.min_idx >= 60) {
                    AbstractMessageReceiver.this.min_idx = 0;
                }
            }
        }, 60000L, 60000L);
    }

    @Override
    public void start() {
        log.finer(this.getName() + ": starting queue management threads ...");
        this.startThreads();
    }

    public void stop() {
        log.finer(this.getName() + ": stopping queue management threads ...");
        this.stopThreads();
    }

    @Override
    public String getDefHostName() {
        return this.defHostname;
    }

    @Override
    public Set<String> getRoutings() {
        return this.routings;
    }

    public Set<Pattern> getRegexRoutings() {
        return this.regexRoutings;
    }

    public void addRouting(String address) {
        this.routings.add(address);
        log.fine(this.getName() + " - added routing: " + address);
    }

    public boolean removeRouting(String address) {
        return this.routings.remove(address);
    }

    public void clearRoutings() {
        this.routings.clear();
    }

    public boolean isInRoutings(String host) {
        return this.routings.contains(host);
    }

    public void addRegexRouting(String address) {
        this.regexRoutings.add(Pattern.compile(address, 2));
    }

    public boolean removeRegexRouting(String address) {
        return this.regexRoutings.remove(Pattern.compile(address, 2));
    }

    public void clearRegexRoutings() {
        this.regexRoutings.clear();
    }

    @Override
    public boolean isInRegexRoutings(String address) {
        for (Pattern pat : this.regexRoutings) {
            if (!pat.matcher(address).matches()) continue;
            log.finest(this.getName() + " matched against pattern: " + pat.toString());
            return true;
        }
        return false;
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
    }

    private class QueueListener
    implements Runnable {
        private LinkedBlockingQueue<QueueElement> queue = null;

        private QueueListener(LinkedBlockingQueue<QueueElement> q) {
            this.queue = q;
        }

        @Override
        public void run() {
            block7: while (!AbstractMessageReceiver.this.stopped) {
                try {
                    QueueElement qel = this.queue.take();
                    switch (qel.type) {
                        case IN_QUEUE: {
                            AbstractMessageReceiver.this.processPacket(qel.packet);
                            continue block7;
                        }
                        case OUT_QUEUE: {
                            if (AbstractMessageReceiver.this.parent != null) {
                                AbstractMessageReceiver.this.parent.addPacket(qel.packet);
                                continue block7;
                            }
                            AbstractMessageReceiver.this.prAddPacket(qel.packet);
                            continue block7;
                        }
                    }
                    log.severe("Unknown queue element type: " + (Object)((Object)qel.type));
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception during packet processing: ", e);
                }
            }
        }
    }

    private static class QueueElement {
        private QueueElementType type = null;
        private Packet packet = null;

        private QueueElement(QueueElementType type, Packet packet) {
            this.type = type;
            this.packet = packet;
        }
    }

    private static enum QueueElementType {
        IN_QUEUE,
        OUT_QUEUE;

    }
}

