/*
 * Decompiled with CFR 0.152.
 */
package tigase.net;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import tigase.io.BufferUnderflowException;
import tigase.io.IOInterface;
import tigase.io.SocketIO;
import tigase.io.TLSIO;
import tigase.io.TLSUtil;
import tigase.io.TLSWrapper;
import tigase.net.ConnectionType;
import tigase.net.IOServiceListener;

public abstract class IOService
implements Callable<IOService> {
    private static final Logger log = Logger.getLogger("tigase.net.IOService");
    public static final String SESSION_ID_KEY = "sessionID";
    public static final String PORT_TYPE_PROP_KEY = "type";
    public static final String HOSTNAME_KEY = "hostname-key";
    private IOInterface socketIO = null;
    private String sslId = null;
    private String id = null;
    private ConnectionType connectionType = null;
    private String local_address = null;
    private String remote_address = null;
    private long lastTransferTime = 0L;
    private IOServiceListener serviceListener = null;
    private ConcurrentMap<String, Object> sessionData = new ConcurrentHashMap<String, Object>();
    private ByteBuffer socketInput = null;
    private CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
    private CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();

    public synchronized void setSSLId(String id) {
        this.sslId = id;
    }

    public long getLastTransferTime() {
        return this.lastTransferTime;
    }

    private void setLastTransferTime() {
        this.lastTransferTime = System.currentTimeMillis();
    }

    public synchronized void startSSL(boolean clientMode) throws IOException {
        this.socketIO = new TLSIO(this.socketIO, new TLSWrapper(TLSUtil.getSSLContext(this.sslId, "SSL", (String)this.sessionData.get(HOSTNAME_KEY)), null, clientMode));
        this.setLastTransferTime();
    }

    public synchronized void startTLS(boolean clientMode) throws IOException {
        this.socketIO = new TLSIO(this.socketIO, new TLSWrapper(TLSUtil.getSSLContext(this.sslId, "TLS", (String)this.sessionData.get(HOSTNAME_KEY)), null, clientMode));
        this.setLastTransferTime();
    }

    public void setIOServiceListener(IOServiceListener sl) {
        this.serviceListener = sl;
    }

    public String getUniqueId() {
        return this.id;
    }

    public ConnectionType connectionType() {
        return this.connectionType;
    }

    public ConcurrentMap<String, Object> getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Map<String, Object> props) {
        this.sessionData = new ConcurrentHashMap<String, Object>(props);
        this.connectionType = ConnectionType.valueOf(this.sessionData.get(PORT_TYPE_PROP_KEY).toString());
    }

    public synchronized boolean isConnected() {
        return this.socketIO == null ? false : this.socketIO.isConnected();
    }

    public String getRemoteAddress() {
        return this.remote_address;
    }

    public String getLocalAddress() {
        return this.local_address;
    }

    public synchronized void accept(SocketChannel socketChannel) throws IOException {
        if (socketChannel.isConnectionPending()) {
            socketChannel.finishConnect();
        }
        this.socketIO = new SocketIO(socketChannel);
        this.socketInput = ByteBuffer.allocate(this.socketIO.getInputPacketSize());
        Socket sock = this.socketIO.getSocketChannel().socket();
        this.local_address = sock.getLocalAddress().getHostAddress();
        this.remote_address = sock.getInetAddress().getHostAddress();
        this.id = this.local_address + "_" + sock.getLocalPort() + "_" + this.remote_address + "_" + sock.getPort();
        this.setLastTransferTime();
    }

    public SocketChannel getSocketChannel() {
        return this.socketIO.getSocketChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        try {
            this.socketIO.stop();
        }
        catch (Exception exception) {
        }
        finally {
            if (this.serviceListener != null) {
                this.serviceListener.serviceStopped(this);
            }
        }
    }

    @Override
    public IOService call() throws IOException {
        this.processSocketData();
        if (this.receivedPackets() > 0 && this.serviceListener != null) {
            this.serviceListener.packetsReady(this);
        }
        return this;
    }

    public abstract void processWaitingPackets() throws IOException;

    protected abstract void processSocketData() throws IOException;

    protected abstract int receivedPackets();

    private void resizeInputBuffer() throws IOException {
        int netSize = this.socketIO.getInputPacketSize();
        if (netSize > this.socketInput.remaining()) {
            log.fine("Resizing buffer to " + (netSize + this.socketInput.capacity()) + " bytes.");
            ByteBuffer b = ByteBuffer.allocate(netSize + this.socketInput.capacity());
            b.put(this.socketInput);
            this.socketInput = b;
        }
    }

    protected void readCompleted() {
        this.decoder.reset();
    }

    protected synchronized char[] readData() throws IOException {
        this.setLastTransferTime();
        CharBuffer cb = null;
        try {
            ByteBuffer tmpBuffer = this.socketIO.read(this.socketInput);
            if (this.socketIO.bytesRead() > 0) {
                tmpBuffer.flip();
                cb = this.decoder.decode(tmpBuffer);
                tmpBuffer.clear();
            }
        }
        catch (BufferUnderflowException underfl) {
            this.resizeInputBuffer();
            return null;
        }
        catch (Exception eof) {
            this.stop();
        }
        return cb != null ? cb.array() : null;
    }

    protected synchronized void writeData(String data) throws IOException {
        if (data != null && data.length() > 0) {
            ByteBuffer dataBuffer = null;
            this.encoder.reset();
            dataBuffer = this.encoder.encode(CharBuffer.wrap(data));
            this.encoder.flush(dataBuffer);
            this.socketIO.write(dataBuffer);
        }
        this.setLastTransferTime();
    }

    protected boolean debug(char[] msg) {
        if (msg != null) {
            System.out.print(new String(msg));
        }
        return true;
    }

    protected boolean debug(String msg, String prefix) {
        if (msg != null && msg.trim().length() > 0) {
            String log_msg = "\n" + (this.connectionType() != null ? this.connectionType().toString() : "null-type") + " " + prefix + "\n" + msg + "\n";
            log.finest(log_msg);
        }
        return true;
    }
}

