/*
 * Decompiled with CFR 0.152.
 */
package tigase.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionOpenListener;

public class ConnectionOpenThread
implements Runnable {
    private static final Logger log = Logger.getLogger("tigase.net.ConnectionOpenThread");
    private static final int RECEIVE_BUFFER_SIZE = 2048;
    protected long accept_counter = 0L;
    private static ConnectionOpenThread acceptThread = null;
    private boolean stopping = false;
    private Selector selector = null;
    private ConcurrentLinkedQueue<ConnectionOpenListener> waiting = new ConcurrentLinkedQueue();

    private ConnectionOpenThread() {
        try {
            this.selector = Selector.open();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Server I/O error, can't continue my work.", e);
            this.stopping = true;
        }
    }

    public static ConnectionOpenThread getInstance() {
        if (acceptThread == null) {
            acceptThread = new ConnectionOpenThread();
            Thread thrd = new Thread(acceptThread);
            thrd.setName("ConnectionOpenThread");
            thrd.start();
            log.finer("ConnectionOpenThread started.");
        }
        return acceptThread;
    }

    public void addConnectionOpenListener(ConnectionOpenListener al) {
        this.waiting.offer(al);
        this.selector.wakeup();
    }

    public void removeConnectionOpenListener(ConnectionOpenListener al) {
        for (SelectionKey key : this.selector.keys()) {
            if (al != key.attachment()) continue;
            try {
                key.cancel();
                SelectableChannel channel = key.channel();
                channel.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception during removing connection listener.", e);
            }
            break;
        }
    }

    private void addPort(ConnectionOpenListener al) throws IOException {
        if (al.getIfcs() == null || al.getIfcs().length == 0 || al.getIfcs()[0].equals("ifc") || al.getIfcs()[0].equals("*")) {
            this.addISA(new InetSocketAddress(al.getPort()), al);
        } else {
            for (String ifc : al.getIfcs()) {
                this.addISA(new InetSocketAddress(ifc, al.getPort()), al);
            }
        }
    }

    private void addISA(InetSocketAddress isa, ConnectionOpenListener al) throws IOException {
        switch (al.getConnectionType()) {
            case accept: {
                log.finest("Setting up 'accept' channel...");
                ServerSocketChannel ssc = ServerSocketChannel.open();
                ssc.socket().setReceiveBufferSize(2048);
                ssc.configureBlocking(false);
                ssc.socket().bind(isa);
                ssc.register(this.selector, 16, al);
                break;
            }
            case connect: {
                log.finest("Setting up 'connect' channel for: " + isa.getAddress() + "/" + isa.getPort());
                SocketChannel sc = SocketChannel.open();
                sc.socket().setReceiveBufferSize(2048);
                sc.configureBlocking(false);
                sc.connect(isa);
                sc.register(this.selector, 8, al);
                break;
            }
            default: {
                log.warning("Unknown connection type: " + (Object)((Object)al.getConnectionType()));
            }
        }
    }

    private void addAllWaiting() throws IOException {
        ConnectionOpenListener al = null;
        while ((al = this.waiting.poll()) != null) {
            try {
                this.addPort(al);
            }
            catch (SocketException e) {
                log.warning("Error: " + e + " creating connection for: " + al.getPort());
            }
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            try {
                this.selector.select();
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey sk = i.next();
                    i.remove();
                    SocketChannel sc = null;
                    if ((sk.readyOps() & 0x10) != 0) {
                        ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                        sc = nextReady.accept();
                        log.finest("OP_ACCEPT");
                    }
                    if ((sk.readyOps() & 8) != 0) {
                        sk.cancel();
                        sc = (SocketChannel)sk.channel();
                        log.finest("OP_CONNECT");
                    }
                    if (sc != null) {
                        sc.configureBlocking(false);
                        sc.socket().setSoLinger(false, 0);
                        sc.socket().setReuseAddress(true);
                        log.finer("Registered new client socket: " + sc);
                        ConnectionOpenListener al = (ConnectionOpenListener)sk.attachment();
                        al.accept(sc);
                    } else {
                        log.warning("Can't obtain socket channel from selection key.");
                    }
                    ++this.accept_counter;
                }
                this.addAllWaiting();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Server I/O error, can't continue my work.", e);
                this.stopping = true;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Other service exception, can't continue my work.", e);
                this.stopping = true;
            }
        }
        System.exit(1);
    }

    public void start() {
        Thread t = new Thread(this);
        t.setName("ConnectionOpenThread");
        t.start();
    }

    public void stop() {
        this.stopping = true;
        this.selector.wakeup();
    }
}

