/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.xml;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserAuthRepositoryImpl;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.xml.db.NodeExistsException;
import tigase.xml.db.NodeNotFoundException;
import tigase.xml.db.XMLDB;

public class XMLRepository
implements UserAuthRepository,
UserRepository {
    private static final String USER_STR = "User: ";
    private static final String NOT_FOUND_STR = " has not been found in repository.";
    private static final Logger log = Logger.getLogger("tigase.db.xml.XMLRepository");
    private XMLDB xmldb = null;
    private UserAuthRepository auth = null;

    @Override
    public void initRepository(String file_name) {
        try {
            this.auth = new UserAuthRepositoryImpl(this);
            this.xmldb = new XMLDB(file_name);
        }
        catch (Exception e) {
            log.warning("Can not open existing user repository file, creating new one, " + e);
            this.xmldb = XMLDB.createDB((String)file_name, (String)"users", (String)"user");
        }
    }

    @Override
    public String getResourceUri() {
        return this.xmldb.getDBFileName();
    }

    @Override
    public final void addUser(String user) throws UserExistsException {
        try {
            this.xmldb.addNode1(user);
        }
        catch (NodeExistsException e) {
            throw new UserExistsException(USER_STR + user + " already exists.", e);
        }
    }

    @Override
    public final void removeUser(String user) throws UserNotFoundException {
        try {
            this.xmldb.removeNode1(user);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public List<String> getUsers() {
        return this.xmldb.getAllNode1s();
    }

    @Override
    public long getUsersCount() {
        return this.xmldb.getAllNode1sCount();
    }

    @Override
    public final void setData(String user, String subnode, String key, String value) throws UserNotFoundException {
        try {
            this.xmldb.setData(user, subnode, key, (Object)value);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final void setData(String user, String key, String value) throws UserNotFoundException {
        this.setData(user, null, key, value);
    }

    @Override
    public final void setDataList(String user, String subnode, String key, String[] list) throws UserNotFoundException {
        try {
            this.xmldb.setData(user, subnode, key, (Object)list);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final void addDataList(String user, String subnode, String key, String[] list) throws UserNotFoundException {
        try {
            String[] old_data = this.getDataList(user, subnode, key);
            String[] all = null;
            if (old_data != null) {
                all = new String[old_data.length + list.length];
                System.arraycopy(old_data, 0, all, 0, old_data.length);
                System.arraycopy(list, 0, all, old_data.length, list.length);
                this.xmldb.setData(user, subnode, key, (Object)all);
            } else {
                this.xmldb.setData(user, subnode, key, (Object)list);
            }
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final String[] getDataList(String user, String subnode, String key) throws UserNotFoundException {
        try {
            return this.xmldb.getDataList(user, subnode, key);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final String getData(String user, String subnode, String key, String def) throws UserNotFoundException {
        try {
            return (String)this.xmldb.getData(user, subnode, key, (Object)def);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final String getData(String user, String subnode, String key) throws UserNotFoundException {
        return this.getData(user, subnode, key, null);
    }

    @Override
    public final String getData(String user, String key) throws UserNotFoundException {
        return this.getData(user, null, key, null);
    }

    @Override
    public final String[] getSubnodes(String user, String subnode) throws UserNotFoundException {
        try {
            return this.xmldb.getSubnodes(user, subnode);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final String[] getSubnodes(String user) throws UserNotFoundException {
        return this.getSubnodes(user, null);
    }

    @Override
    public final String[] getKeys(String user, String subnode) throws UserNotFoundException {
        try {
            return this.xmldb.getKeys(user, subnode);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final String[] getKeys(String user) throws UserNotFoundException {
        return this.getKeys(user, null);
    }

    @Override
    public final void removeData(String user, String subnode, String key) throws UserNotFoundException {
        try {
            this.xmldb.removeData(user, subnode, key);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public final void removeData(String user, String key) throws UserNotFoundException {
        this.removeData(user, null, key);
    }

    @Override
    public final void removeSubnode(String user, String subnode) throws UserNotFoundException {
        try {
            this.xmldb.removeSubnode(user, subnode);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public boolean plainAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.plainAuth(user, password);
    }

    @Override
    public boolean digestAuth(String user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.digestAuth(user, digest, id, alg);
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(props);
    }

    @Override
    public void logout(String user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    @Override
    public void updatePassword(String user, String password) throws UserExistsException, TigaseDBException {
        this.auth.updatePassword(user, password);
    }

    @Override
    public void addUser(String user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }
}

