/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserAuthRepositoryImpl;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.util.SimpleCache;

public class JDBCRepository
implements UserAuthRepository,
UserRepository {
    private static final Logger log = Logger.getLogger("tigase.db.jdbc.JDBCRepository");
    public static final String DEF_USERS_TBL = "tig_users";
    public static final String DEF_NODES_TBL = "tig_nodes";
    public static final String DEF_PAIRS_TBL = "tig_pairs";
    public static final String DEF_MAXIDS_TBL = "tig_max_ids";
    public static final String DEF_ROOT_NODE = "root";
    private static final String USER_STR = "User: ";
    private String users_tbl = "tig_users";
    private String nodes_tbl = "tig_nodes";
    private String pairs_tbl = "tig_pairs";
    private String root_node = "root";
    private UserAuthRepository auth = null;
    private String db_conn = null;
    private Connection conn = null;
    private PreparedStatement uid_st = null;
    private PreparedStatement node_add_st = null;
    private PreparedStatement data_for_node_st = null;
    private PreparedStatement keys_for_node_st = null;
    private PreparedStatement nodes_for_node_st = null;
    private PreparedStatement insert_key_val_st = null;
    private PreparedStatement remove_key_data_st = null;
    private PreparedStatement conn_valid_st = null;
    private Map<String, Object> cache = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;
    private boolean autoCreateUser = false;
    private static long var_max_uid = 0L;
    private static long var_max_nid = 0L;

    private long getMaxUid() {
        return System.currentTimeMillis() * 100L + var_max_uid++ % 100L;
    }

    private long getMaxNid() {
        return System.currentTimeMillis() * 100L + var_max_nid++ % 100L;
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean checkConnection() throws SQLException {
        try {
            long tmp = System.currentTimeMillis();
            if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                this.conn_valid_st.executeQuery();
                this.lastConnectionValidated = tmp;
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUserUID(String user_id) throws SQLException, UserNotFoundException {
        Long cache_res = (Long)this.cache.get(user_id);
        if (cache_res != null) {
            return cache_res;
        }
        ResultSet rs = null;
        long result = -1L;
        try {
            this.uid_st.setString(1, user_id);
            rs = this.uid_st.executeQuery();
            if (rs.next()) {
                result = rs.getLong(1);
            } else if (this.autoCreateUser) {
                result = this.addUserRepo(user_id);
            } else {
                throw new UserNotFoundException("User does not exist: " + user_id);
            }
            this.release(null, rs);
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        this.cache.put(user_id, result);
        return result;
    }

    private String buildNodeQuery(long uid, String node_path) {
        String query = "select nid as nid1 from " + this.nodes_tbl + " where (uid = " + uid + ")" + " AND (parent_nid is null)" + " AND (node = '" + this.root_node + "')";
        if (node_path == null) {
            return query;
        }
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        int cnt = 1;
        String subquery = query;
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            subquery = "select nid as nid" + ++cnt + ", node as node" + cnt + " from " + this.nodes_tbl + ", (" + subquery + ") nodes" + (cnt - 1) + " where (parent_nid = nid" + (cnt - 1) + ")" + " AND (node = '" + token + "')";
        }
        return subquery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNodeNID(long uid, String node_path) throws SQLException, UserNotFoundException {
        ResultSet rs;
        Statement stmt;
        block3: {
            String query = this.buildNodeQuery(uid, node_path);
            stmt = null;
            rs = null;
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery(query);
                if (!rs.next()) break block3;
                long l = rs.getLong(1);
                this.release(stmt, rs);
                stmt = null;
                rs = null;
                return l;
            }
            catch (Throwable throwable) {
                this.release(stmt, rs);
                stmt = null;
                rs = null;
                throw throwable;
            }
        }
        long l = -1L;
        this.release(stmt, rs);
        stmt = null;
        rs = null;
        return l;
    }

    private long getNodeNID(String user_id, String node_path) throws SQLException, UserNotFoundException {
        Long cache_res = (Long)this.cache.get(user_id + "/" + node_path);
        if (cache_res != null) {
            return cache_res;
        }
        long uid = this.getUserUID(user_id);
        long result = this.getNodeNID(uid, node_path);
        if (result > 0L) {
            this.cache.put(user_id + "/" + node_path, result);
        }
        return result;
    }

    private long addNode(long uid, long parent_nid, String node_name) throws SQLException {
        long new_nid = this.getMaxNid();
        this.node_add_st.setLong(1, new_nid);
        if (parent_nid < 0L) {
            this.node_add_st.setNull(2, -5);
        } else {
            this.node_add_st.setLong(2, parent_nid);
        }
        this.node_add_st.setLong(3, uid);
        this.node_add_st.setString(4, node_name);
        this.node_add_st.executeUpdate();
        return new_nid;
    }

    private long createNodePath(String user_id, String node_path) throws SQLException, UserNotFoundException {
        if (node_path == null) {
            return this.getNodeNID(user_id, null);
        }
        long uid = this.getUserUID(user_id);
        long nid = this.getNodeNID(uid, null);
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        StringBuilder built_path = new StringBuilder();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            built_path.append("/").append(token);
            long cur_nid = this.getNodeNID(uid, built_path.toString());
            if (cur_nid > 0L) {
                nid = cur_nid;
                continue;
            }
            nid = this.addNode(uid, nid, token);
        }
        return nid;
    }

    private void initPreparedStatements() throws SQLException {
        String query = "select uid from " + this.users_tbl + " where user_id = ?;";
        this.uid_st = this.conn.prepareStatement(query);
        query = "insert into " + this.nodes_tbl + " (nid, parent_nid, uid, node)" + " values (?, ?, ?, ?);";
        this.node_add_st = this.conn.prepareStatement(query);
        query = "select pval from " + this.pairs_tbl + " where (nid = ?) AND (pkey = ?);";
        this.data_for_node_st = this.conn.prepareStatement(query);
        query = "select pkey from " + this.pairs_tbl + " where (nid = ?);";
        this.keys_for_node_st = this.conn.prepareStatement(query);
        query = "select nid, node from " + this.nodes_tbl + " where parent_nid = ?;";
        this.nodes_for_node_st = this.conn.prepareStatement(query);
        query = "insert into " + this.pairs_tbl + " (nid, uid, pkey, pval) " + " values (?, ?, ?, ?)";
        this.insert_key_val_st = this.conn.prepareStatement(query);
        query = "delete from " + this.pairs_tbl + " where (nid = ?) AND (pkey = ?)";
        this.remove_key_data_st = this.conn.prepareStatement(query);
        query = "select localtime;";
        this.conn_valid_st = this.conn.prepareStatement(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        Statement stmt = null;
        Object rs = null;
        try {
            this.conn = DriverManager.getConnection(this.db_conn);
            this.conn.setAutoCommit(true);
            this.initPreparedStatements();
            this.auth = new UserAuthRepositoryImpl(this);
            stmt = this.conn.createStatement();
            this.cache = new SimpleCache(10000);
            this.release(stmt, rs);
            stmt = null;
            rs = null;
        }
        catch (Throwable throwable) {
            this.release(stmt, rs);
            stmt = null;
            rs = null;
            throw throwable;
        }
    }

    @Override
    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public void initRepository(String connection_str) throws DBInitException {
        this.db_conn = connection_str;
        if (this.db_conn.contains("autoCreateUser=true")) {
            this.autoCreateUser = true;
        }
        try {
            this.initRepo();
            log.info("Initialized database connection: " + connection_str);
        }
        catch (SQLException e) {
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM " + this.users_tbl);
            long users = -1L;
            if (rs.next()) {
                users = rs.getLong(1);
            }
            long l = users;
            this.release(stmt, rs);
            stmt = null;
            rs = null;
            return l;
        }
        catch (SQLException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.release(stmt, rs);
            stmt = null;
            rs = null;
        }
    }

    @Override
    public List<String> getUsers() throws TigaseDBException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT user_id FROM " + this.users_tbl);
            ArrayList<String> users = new ArrayList<String>();
            while (rs.next()) {
                users.add(rs.getString(1));
            }
            ArrayList<String> arrayList = users;
            this.release(stmt, rs);
            stmt = null;
            rs = null;
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new TigaseDBException("Problem loading user list from repository", e);
            }
            catch (Throwable throwable) {
                this.release(stmt, rs);
                stmt = null;
                rs = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addUserRepo(String user_id) throws SQLException {
        this.checkConnection();
        Statement stmt = null;
        String query = null;
        long uid = this.getMaxUid();
        try {
            stmt = this.conn.createStatement();
            query = "insert into " + this.users_tbl + " (uid, user_id) values (" + uid + ", '" + user_id + "');";
            stmt.executeUpdate(query);
            this.addNode(uid, -1L, this.root_node);
        }
        finally {
            this.release(stmt, null);
            stmt = null;
        }
        this.cache.put(user_id, uid);
        return uid;
    }

    @Override
    public void addUser(String user_id) throws UserExistsException, TigaseDBException {
        try {
            this.addUserRepo(user_id);
        }
        catch (SQLException e) {
            throw new UserExistsException("Error adding user to repository: ", e);
        }
    }

    @Override
    public void removeUser(String user_id) throws UserNotFoundException, TigaseDBException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            this.checkConnection();
            stmt = this.conn.createStatement();
            long uid = this.getUserUID(user_id);
            query = "delete from " + this.pairs_tbl + " where uid = " + uid;
            stmt.executeUpdate(query);
            query = "delete from " + this.nodes_tbl + " where uid = " + uid;
            stmt.executeUpdate(query);
            query = "delete from " + this.users_tbl + " where uid = " + uid;
            stmt.executeUpdate(query);
            this.release(stmt, rs);
            stmt = null;
            this.cache.remove(user_id);
        }
        catch (SQLException e) {
            try {
                throw new TigaseDBException("Error removing user from repository: " + query, e);
            }
            catch (Throwable throwable) {
                this.release(stmt, rs);
                stmt = null;
                this.cache.remove(user_id);
                throw throwable;
            }
        }
    }

    @Override
    public String[] getDataList(String user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (nid > 0L) {
                String[] result;
                ArrayList<String> results = new ArrayList<String>();
                this.data_for_node_st.setLong(1, nid);
                this.data_for_node_st.setString(2, key);
                rs = this.data_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                String[] stringArray = result = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                this.release(null, rs);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting data list.", e);
        }
        finally {
            this.release(null, rs);
        }
    }

    @Override
    public String[] getSubnodes(String user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (nid > 0L) {
                ArrayList<String> results = new ArrayList<String>();
                this.nodes_for_node_st.setLong(1, nid);
                rs = this.nodes_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(2));
                }
                String[] stringArray = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                this.release(null, rs);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
        finally {
            this.release(null, rs);
        }
    }

    @Override
    public String[] getSubnodes(String user_id) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user_id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubnode(long nid) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            stmt = this.conn.createStatement();
            query = "delete from " + this.pairs_tbl + " where nid = " + nid;
            stmt.executeUpdate(query);
            query = "delete from " + this.nodes_tbl + " where nid = " + nid;
            stmt.executeUpdate(query);
            query = "select nid from " + this.nodes_tbl + " where parent_nid = " + nid;
            rs = stmt.executeQuery(query);
            this.release(stmt, rs);
        }
        catch (Throwable throwable) {
            this.release(stmt, rs);
            throw throwable;
        }
    }

    @Override
    public void removeSubnode(String user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        if (subnode == null) {
            return;
        }
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (nid > 0L) {
                this.deleteSubnode(nid);
                this.cache.remove(user_id + "/" + subnode);
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    @Override
    public void setDataList(String user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        this.removeData(user_id, subnode, key);
        this.addDataList(user_id, subnode, key, list);
    }

    @Override
    public void addDataList(String user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            long uid = this.getUserUID(user_id);
            long nid = this.getNodeNID(uid, subnode);
            if (nid < 0L) {
                nid = this.createNodePath(user_id, subnode);
            }
            this.insert_key_val_st.setLong(1, nid);
            this.insert_key_val_st.setLong(2, uid);
            this.insert_key_val_st.setString(3, key);
            for (String val : list) {
                this.insert_key_val_st.setString(4, val);
                this.insert_key_val_st.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    @Override
    public String[] getKeys(String user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (nid > 0L) {
                ArrayList<String> results = new ArrayList<String>();
                this.keys_for_node_st.setLong(1, nid);
                rs = this.keys_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                String[] stringArray = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                this.release(null, rs);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
        finally {
            this.release(null, rs);
        }
    }

    @Override
    public String[] getKeys(String user_id) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user_id, null);
    }

    @Override
    public String getData(String user_id, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (nid > 0L) {
                String result = def;
                this.data_for_node_st.setLong(1, nid);
                this.data_for_node_st.setString(2, key);
                rs = this.data_for_node_st.executeQuery();
                if (rs.next()) {
                    result = rs.getString(1);
                }
                String string = result;
                this.release(null, rs);
                return string;
            }
            String string = def;
            return string;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting data list.", e);
        }
        finally {
            this.release(null, rs);
        }
    }

    @Override
    public String getData(String user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, subnode, key, null);
    }

    @Override
    public String getData(String user_id, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, null, key, null);
    }

    @Override
    public void setData(String user_id, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setDataList(user_id, subnode, key, new String[]{value});
    }

    @Override
    public void setData(String user_id, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user_id, null, key, value);
    }

    @Override
    public void removeData(String user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (nid > 0L) {
                this.remove_key_data_st.setLong(1, nid);
                this.remove_key_data_st.setString(2, key);
                this.remove_key_data_st.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    @Override
    public void removeData(String user_id, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(user_id, null, key);
    }

    @Override
    public boolean plainAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.plainAuth(user, password);
    }

    @Override
    public boolean digestAuth(String user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.digestAuth(user, digest, id, alg);
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(props);
    }

    @Override
    public void updatePassword(String user, String password) throws TigaseDBException {
        this.auth.updatePassword(user, password);
    }

    @Override
    public void logout(String user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    @Override
    public void addUser(String user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }
}

