/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import tigase.xml.db.NodeExistsException;
import tigase.xml.db.NodeNotFoundException;
import tigase.xml.db.XMLDB;

public class ConfigRepository {
    public static final String XMPP_CONFIG_FILE_PROPERTY_KEY = "xmpp.config.file";
    public static final String XMPP_CONFIG_FILE_PROPERTY_VAL = "xmpp_server.xml";
    public static final String ROOT_NODE = "tigase-config";
    public static final String COMPONENT_NODE = "component";
    private static final Logger log = Logger.getLogger("tigase.conf.ConfigRepository");
    private XMLDB xmldb = null;
    private String config_file = null;
    private static Map<String, ConfigRepository> configs = new LinkedHashMap<String, ConfigRepository>();
    private static ConfigRepository def_config = null;

    public static ConfigRepository getConfigRepository() {
        return ConfigRepository.getConfigRepository(null);
    }

    public static ConfigRepository getConfigRepository(String file_name) {
        return ConfigRepository.getConfigRepository(false, file_name);
    }

    public static ConfigRepository getConfigRepository(boolean debug, String file_name) {
        ConfigRepository config = null;
        config = file_name == null ? def_config : configs.get(file_name);
        if (config == null) {
            config = file_name == null ? new ConfigRepository(debug) : new ConfigRepository(debug, file_name);
        }
        return config;
    }

    private ConfigRepository(boolean debug, String file) {
        this.config_file = file;
        this.init();
    }

    private ConfigRepository(boolean debug) {
        this.config_file = System.getProperty(XMPP_CONFIG_FILE_PROPERTY_KEY, XMPP_CONFIG_FILE_PROPERTY_VAL);
        this.init();
        def_config = this;
    }

    private void init() {
        try {
            this.xmldb = new XMLDB(this.config_file);
        }
        catch (IOException e) {
            log.warning("Can not open existing configuration file, creating new one, " + e);
            this.xmldb = XMLDB.createDB((String)this.config_file, (String)ROOT_NODE, (String)COMPONENT_NODE);
        }
        configs.put(this.config_file, this);
    }

    public Map<String, Object> getProperties(String nodeId) {
        log.config("Reading properties for: " + nodeId);
        String root = nodeId;
        String subnode = "";
        int idx = nodeId.indexOf(47);
        if (idx >= 0) {
            root = nodeId.substring(0, idx);
            subnode = nodeId.substring(idx + 1);
        }
        log.config("Looking for properties for " + root + " in " + subnode + " node.");
        ArrayList<String> allNodes = new ArrayList<String>();
        this.getSubnodes(allNodes, root, subnode);
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        Object[] keys = this.getKeys(root, null);
        log.config("Found keys: " + Arrays.toString(keys));
        this.addVals(props, root, null, (String[])keys);
        for (String node : allNodes) {
            keys = this.getKeys(root, node);
            log.config("In node : '" + node + "' found keys: " + Arrays.toString(keys));
            this.addVals(props, root, node, (String[])keys);
        }
        return props;
    }

    private void addVals(Map<String, Object> props, String root, String node, String[] keys) {
        if (keys != null) {
            for (String key : keys) {
                String node_tmp = node == null || node.equals("") ? "" : node + "/";
                props.put(node_tmp + key, this.get(root, node, key, null));
            }
        }
    }

    public void putProperties(String nodeId, Map<String, ?> props) {
        log.config("Saving properties for: " + nodeId);
        String root = nodeId;
        String subnode = "";
        int idx = nodeId.indexOf(47);
        if (idx >= 0) {
            root = nodeId.substring(0, idx);
            subnode = nodeId.substring(idx + 1) + "/";
        }
        try {
            this.xmldb.addNode1(root);
        }
        catch (NodeExistsException e) {
            // empty catch block
        }
        for (Map.Entry<String, ?> entry : props.entrySet()) {
            String node = null;
            String key = subnode + entry.getKey();
            idx = key.lastIndexOf(47);
            if (idx >= 0) {
                node = key.substring(0, idx);
                key = key.substring(idx + 1);
            }
            Object value = entry.getValue();
            log.config("Setting property: root=" + root + ", node=" + node + ", key=" + key + ", value=" + value);
            this.set(root, node, key, value);
        }
    }

    private void getSubnodes(List<String> result, String root, String node) {
        String node_tmp;
        String[] subnodes = this.getSubnodes(root, node);
        String string = node_tmp = node.equals("") ? node : node + "/";
        if (subnodes != null) {
            for (String subnode : subnodes) {
                result.add(node_tmp + subnode);
                log.config("Adding subnode: " + node_tmp + subnode);
                this.getSubnodes(result, root, node_tmp + subnode);
            }
        }
    }

    public void sync() throws IOException {
        this.xmldb.sync();
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public Object get(String key, Object def) {
        return this.get(null, key, def);
    }

    public Object get(String node, String key, Object def) {
        return this.get(COMPONENT_NODE, node, key, def);
    }

    public Object get(String root, String node, String key, Object def) {
        Object result;
        try {
            result = this.xmldb.getData(root, node, key, def);
        }
        catch (NodeNotFoundException e) {
            result = def;
        }
        return result;
    }

    public void set(String key, Object value) {
        this.set(null, key, value);
    }

    public void set(String node, String key, Object value) {
        this.set(COMPONENT_NODE, node, key, value);
    }

    public void set(String root, String node, String key, Object value) {
        try {
            this.xmldb.setData(root, node, key, value);
        }
        catch (NodeNotFoundException e1) {
            try {
                this.xmldb.addNode1(root);
                this.xmldb.setData(root, node, key, value);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public String[] getSubnodes() {
        List comps = this.xmldb.getAllNode1s();
        if (comps != null) {
            return comps.toArray(new String[comps.size()]);
        }
        return null;
    }

    public String[] getSubnodes(String node) {
        return this.getSubnodes(COMPONENT_NODE, node);
    }

    public String[] getSubnodes(String root, String node) {
        try {
            return this.xmldb.getSubnodes(root, node);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    public String[] getKeys() {
        return this.getKeys(null);
    }

    public String[] getKeys(String node) {
        return this.getKeys(COMPONENT_NODE, node);
    }

    public String[] getKeys(String root, String node) {
        try {
            return this.xmldb.getKeys(root, node);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    public void removeData(String key) {
        this.removeData(null, key);
    }

    public void removeData(String node, String key) {
        this.removeData(COMPONENT_NODE, node, key);
    }

    public void removeData(String root, String node, String key) {
        try {
            this.xmldb.removeData(root, node, key);
        }
        catch (NodeNotFoundException e) {
            log.warning("Attempt to remove data for non-existen node: /" + root + "/" + node);
        }
    }

    public void removeSubnode(String node) {
        this.removeSubnode(COMPONENT_NODE, node);
    }

    public void removeSubnode(String root, String node) {
        try {
            this.xmldb.removeSubnode(root, node);
        }
        catch (NodeNotFoundException e) {
            log.warning("Attempt to remove non-existen node: /" + root + "/" + node);
        }
    }

    public String nodeForPackage(Class cls) {
        return cls.getPackage().getName().replace('.', '/');
    }
}

