/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2007 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 630 $
 * Last modified by $Author: kobit $
 * $Date: 2007-07-18 18:38:28 +0100 (Wed, 18 Jul 2007) $
 */
package tigase.io;

import java.util.Map;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import java.util.logging.Logger;

/**
 * Describe class TLSUtil here.
 *
 *
 * Created: Mon Jan 23 14:21:31 2006
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 630 $
 */
public abstract class TLSUtil {

  private static final Logger log = Logger.getLogger("tigase.io.TLSUtil");

	private static Map<String, SSLContextContainer> sslContexts =
		new HashMap<String, SSLContextContainer>();

  public static void configureSSLContext(String id,
		String k_store, String k_passwd, String t_store, String t_passwd,
		String def_cert_alias) {
		SSLContextContainer sslCC =
			new SSLContextContainer(k_store, k_passwd, t_store, t_passwd,
				def_cert_alias);
		sslContexts.put(id, sslCC);
  }

  public static void configureSSLContext(String id,
		String k_store, String k_passwd, String def_cert_alias) {
		SSLContextContainer sslCC =
			new SSLContextContainer(k_store, k_passwd, def_cert_alias);
		sslContexts.put(id, sslCC);
	}

  public static void configureSSLContext(String id) {
		SSLContextContainer sslCC =	new SSLContextContainer();
		sslContexts.put(id, sslCC);
	}

	public static SSLContext getSSLContext(String id, String protocol,
		String hostname) {
		return sslContexts.get(id).getSSLContext(protocol, hostname);
	}

} // TLSUtil