/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.Queue;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqRegister
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String ID = "jabber:iq:register";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:register"};
    private static final Element[] FEATURES = new Element[]{new Element("register", new String[]{"xmlns"}, new String[]{"http://jabber.org/features/iq-register"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:register"})};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] supElements() {
        return Arrays.copyOf(ELEMENTS, ELEMENTS.length);
    }

    @Override
    public String[] supNamespaces() {
        return Arrays.copyOf(XMLNSS, XMLNSS.length);
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return Arrays.copyOf(FEATURES, FEATURES.length);
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return Arrays.copyOf(DISCO_FEATURES, DISCO_FEATURES.length);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null) {
            return;
        }
        String id = session.getDomain();
        if (packet.getElemTo() != null) {
            id = JIDUtils.getNodeID((String)packet.getElemTo());
        }
        try {
            if ((id.equals(session.getDomain()) || id.equals(session.getUserId())) && packet.getFrom().equals(session.getConnectionId())) {
                Authorization result = Authorization.NOT_AUTHORIZED;
                Element request = packet.getElement();
                StanzaType type = packet.getType();
                switch (type) {
                    case set: {
                        Element elem = request.findChild("/iq/query/remove");
                        if (elem != null) {
                            elem = request.findChild("/iq/query");
                            if (elem.getChildren().size() > 1) {
                                result = Authorization.BAD_REQUEST;
                            } else {
                                try {
                                    result = session.unregister(packet.getElemFrom());
                                }
                                catch (NotAuthorizedException e) {
                                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                                }
                            }
                        } else {
                            String user_name = request.getChildCData("/iq/query/username");
                            String password = request.getChildCData("/iq/query/password");
                            String email = request.getChildCData("/iq/query/email");
                            result = session.register(user_name, password, email);
                        }
                        if (result == Authorization.AUTHORIZED) {
                            results.offer(result.getResponseMessage(packet, null, false));
                            break;
                        }
                        results.offer(result.getResponseMessage(packet, "Unsuccessful registration attempt", true));
                        break;
                    }
                    case get: {
                        results.offer(packet.okResult("<instructions>Choose a user name and password for use with this service.Please provide also your e-mail address.</instructions><username/><password/><email/>", 1));
                        break;
                    }
                    case result: {
                        Element elem_res = packet.getElement().clone();
                        Packet pack_res = new Packet(elem_res);
                        pack_res.setTo(session.getConnectionId());
                        results.offer(pack_res);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", true));
                        break;
                    }
                }
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to change registration settings.", true));
        }
    }
}

