/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import tigase.xml.DefaultElementFactory;
import tigase.xml.Element;
import tigase.xml.ElementFactory;
import tigase.xml.SimpleHandler;
import tigase.xmpp.XMPPIOService;

public class XMPPDomBuilderHandler
implements SimpleHandler {
    private static Logger log = Logger.getLogger("tigase.xmpp.XMPPDomBuilderHandler");
    private static final String ELEM_STREAM_STREAM = "stream:stream";
    private static ElementFactory defaultFactory = new DefaultElementFactory();
    private ElementFactory customFactory = null;
    private Object parserState = null;
    private String top_xmlns = null;
    private XMPPIOService service = null;
    private LinkedList<Element> all_roots = new LinkedList();
    private Stack<Element> el_stack = new Stack();
    private Map<String, String> namespaces = new TreeMap<String, String>();

    public XMPPDomBuilderHandler(XMPPIOService ioserv, ElementFactory factory) {
        this.customFactory = factory;
        this.service = ioserv;
    }

    public XMPPDomBuilderHandler(XMPPIOService ioserv) {
        this.customFactory = defaultFactory;
        this.service = ioserv;
    }

    public Queue<Element> getParsedElements() {
        return this.all_roots;
    }

    public void error(String errorMessage) {
        log.warning("XML content parse error.");
        log.warning(errorMessage);
    }

    private Element newElement(String name, String cdata, StringBuilder[] attnames, StringBuilder[] attvals) {
        return this.customFactory.elementInstance(name, cdata, attnames, attvals);
    }

    public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
        String tmp_name;
        log.finest("Start element name: " + name);
        log.finest("Element attributes names: " + Arrays.toString(attr_names));
        log.finest("Element attributes values: " + Arrays.toString(attr_values));
        if (attr_names != null) {
            for (int i = 0; i < attr_names.length && attr_names[i] != null; ++i) {
                if (!attr_names[i].toString().startsWith("xmlns:")) continue;
                this.namespaces.put(attr_names[i].substring("xmlns:".length(), attr_names[i].length()), attr_values[i].toString());
            }
        }
        if ((tmp_name = name.toString()).equals(ELEM_STREAM_STREAM)) {
            HashMap<String, String> attribs = new HashMap<String, String>();
            if (attr_names != null) {
                for (int i = 0; i < attr_names.length && attr_names[i] != null && attr_values[i] != null; ++i) {
                    attribs.put(attr_names[i].toString(), attr_values[i].toString());
                }
            }
            this.service.xmppStreamOpened(attribs);
            return;
        }
        String new_xmlns = null;
        String prefix = null;
        for (String pref : this.namespaces.keySet()) {
            if (!tmp_name.startsWith(pref)) continue;
            new_xmlns = this.namespaces.get(pref);
            tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
            prefix = pref;
        }
        Element elem = this.newElement(tmp_name, null, attr_names, attr_values);
        String ns = elem.getXMLNS();
        if (ns == null) {
            if (this.el_stack.isEmpty() || this.el_stack.peek().getXMLNS() == null) {
                elem.setDefXMLNS(this.top_xmlns);
            } else {
                elem.setDefXMLNS(this.el_stack.peek().getXMLNS());
            }
        }
        if (new_xmlns != null) {
            elem.setXMLNS(new_xmlns);
            elem.removeAttribute("xmlns:" + prefix);
        }
        this.el_stack.push(elem);
    }

    public void elementCData(StringBuilder cdata) {
        log.finest("Element CDATA: " + cdata);
        try {
            this.el_stack.peek().setCData(cdata.toString());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void endElement(StringBuilder name) {
        log.finest("End element name: " + name);
        String tmp_name = name.toString();
        if (tmp_name.equals(ELEM_STREAM_STREAM)) {
            this.service.xmppStreamClosed();
            return;
        }
        if (this.el_stack.isEmpty()) {
            this.el_stack.push(this.newElement(tmp_name, null, null, null));
        }
        Element elem = this.el_stack.pop();
        if (this.el_stack.isEmpty()) {
            this.all_roots.offer(elem);
            log.finest("Adding new request: " + elem.toString());
        } else {
            this.el_stack.peek().addChild(elem);
        }
    }

    public void otherXML(StringBuilder other) {
        log.finest("Other XML content: " + other);
    }

    public void saveParserState(Object state) {
        this.parserState = state;
    }

    public Object restoreParserState() {
        return this.parserState;
    }
}

