/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.net.SocketReadThread;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.util.RoutingsContainer;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class ClientConnectionManager
extends ConnectionManager<XMPPIOService> {
    private static final Logger log = Logger.getLogger("tigase.server.xmppclient.ClientConnectionManager");
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    private static final String ROUTING_ENTRY_PROP_VAL = "sess-man@localhost";
    public static final String HOSTNAMES_PROP_KEY = "hostnames";
    public String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    private RoutingsContainer routings = null;
    private Set<String> hostnames = new TreeSet<String>();
    private Map<String, XMPPProcessorIfc> processors = new ConcurrentSkipListMap<String, XMPPProcessorIfc>();

    @Override
    public void processPacket(Packet packet) {
        log.finer("Processing packet: " + packet.getElemName() + ", type: " + (Object)((Object)packet.getType()));
        log.finest("Processing packet: " + packet.getStringData());
        if (packet.isCommand() && packet.getCommand() != Command.OTHER) {
            this.processCommand(packet);
        } else {
            this.writePacketToSocket(packet);
        }
    }

    private void processCommand(Packet packet) {
        Object serv = this.getXMPPIOService(packet);
        switch (packet.getCommand()) {
            case GETFEATURES: {
                if (packet.getType() != StanzaType.result) break;
                List<Element> features = this.getFeatures(this.getXMPPSession(packet));
                Element elem_features = new Element("stream:features");
                elem_features.addChildren(features);
                elem_features.addChildren(Command.getData(packet));
                Packet result = new Packet(elem_features);
                result.setTo(packet.getTo());
                this.writePacketToSocket(result);
                break;
            }
            case STARTTLS: {
                if (serv != null) {
                    log.finer("Starting TLS for connection: " + ((IOService)serv).getUniqueId());
                    try {
                        Element proceed = Command.getData(packet, "proceed", null);
                        Packet p_proceed = new Packet(proceed);
                        SocketReadThread readThread = SocketReadThread.getInstance();
                        readThread.removeSocketService((IOService)serv);
                        ((XMPPIOService)serv).addPacketToSend(p_proceed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        ((IOService)serv).startTLS(false);
                        readThread.addSocketService((IOService)serv);
                    }
                    catch (IOException e) {
                        log.warning("Error starting TLS: " + e);
                    }
                    break;
                }
                log.warning("Can't find sevice for STARTTLS command: " + packet.getStringData());
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                if (serv != null) {
                    ((XMPPIOService)serv).stop();
                    break;
                }
                log.fine("Attempt to stop non-existen service for packet: " + packet.getStringData() + ", Service already stopped?");
                break;
            }
        }
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService serv) {
        String id = this.getUniqueId(serv);
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
            log.finest("Processing socket data: " + p.getStringData());
            p.setFrom(this.getFromAddress(id));
            p.setTo(this.routings.computeRouting(p.getElemTo()));
            this.addOutPacket(p);
        }
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        props.put(HOSTNAMES_PROP_KEY, this.HOSTNAMES_PROP_VAL);
        props.put("routings/multi-mode", true);
        if (params.get("config-type").equals("--gen-config-cs") && params.get("--ext-comp") != null) {
            String[] comp_params = ((String)params.get("--ext-comp")).split(",");
            props.put("routings/.+", "sess-man@" + comp_params[1]);
        } else {
            props.put("routings/.+", "sess-man@" + this.HOSTNAMES_PROP_VAL[0]);
        }
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        boolean routing_mode = (Boolean)props.get("routings/multi-mode");
        this.routings = new RoutingsContainer(routing_mode);
        int idx = "routings/".length();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("routings/") || entry.getKey().equals("routings/multi-mode")) continue;
            this.routings.addRouting(entry.getKey().substring(idx), (String)entry.getValue());
        }
        String[] hnames = (String[])props.get(HOSTNAMES_PROP_KEY);
        this.clearRoutings();
        this.hostnames.clear();
        for (String host : hnames) {
            this.addRouting(this.getName() + "@" + host);
            this.hostnames.add(host);
        }
    }

    private XMPPResourceConnection getXMPPSession(Packet p) {
        Object serv = this.getXMPPIOService(p);
        return serv == null ? null : (XMPPResourceConnection)((IOService)serv).getSessionData().get("xmpp-session");
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (XMPPProcessorIfc proc : this.processors.values()) {
            Element[] features = proc.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5222};
    }

    @Override
    protected int[] getDefSSLPorts() {
        return new int[]{5223};
    }

    private String getFromAddress(String id) {
        return JIDUtils.getJID((String)this.getName(), (String)this.getDefHostName(), (String)id);
    }

    @Override
    public String xmppStreamOpened(XMPPIOService serv, Map<String, String> attribs) {
        log.finer("Stream opened: " + attribs.toString());
        String hostname = attribs.get("to");
        String id = UUID.randomUUID().toString();
        if (hostname == null) {
            return "<stream:stream version='1.0' xml:lang='en' from='" + this.getDefHostName() + "'" + " id='" + id + "'" + " xmlns='jabber:client'" + " xmlns:stream='http://etherx.jabber.org/streams'>" + "<stream:error>" + "<improper-addressing xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
        }
        if (!this.hostnames.contains(hostname)) {
            return "<stream:stream version='1.0' xml:lang='en' from='" + this.getDefHostName() + "'" + " id='" + id + "'" + " xmlns='jabber:client'" + " xmlns:stream='http://etherx.jabber.org/streams'>" + "<stream:error>" + "<host-unknown xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
        }
        try {
            serv.writeRawData("<stream:stream version='1.0' xml:lang='en' from='" + hostname + "'" + " id='" + id + "'" + " xmlns='jabber:client'" + " xmlns:stream='http://etherx.jabber.org/streams'>");
            serv.getSessionData().put("sessionID", id);
            serv.getSessionData().put("hostname-key", hostname);
            Packet streamOpen = Command.STREAM_OPENED.getPacket(this.getFromAddress(this.getUniqueId(serv)), this.routings.computeRouting(hostname), StanzaType.set, "sess1", "submit");
            Command.addFieldValue(streamOpen, "session-id", id);
            Command.addFieldValue(streamOpen, "hostname", hostname);
            this.addOutPacket(streamOpen);
            if (attribs.get("version") != null) {
                this.addOutPacket(Command.GETFEATURES.getPacket(this.getFromAddress(this.getUniqueId(serv)), this.routings.computeRouting(null), StanzaType.get, "sess2", null));
            }
        }
        catch (IOException e) {
            serv.stop();
        }
        return null;
    }

    @Override
    public void serviceStopped(XMPPIOService service) {
        super.serviceStopped(service);
        Packet command2 = Command.STREAM_CLOSED.getPacket(this.getFromAddress(this.getUniqueId(service)), this.routings.computeRouting(null), StanzaType.set, "sess1");
        this.addOutPacket(command2);
        log.fine("Service stopped, sending packet: " + command2.getStringData());
    }

    @Override
    public void xmppStreamClosed(XMPPIOService serv) {
        log.finer("Stream closed.");
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000L;
    }

    @Override
    protected XMPPIOService getXMPPIOServiceInstance() {
        return new XMPPIOService();
    }
}

