/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSession;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.util.RoutingsContainer;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;

public class BoshConnectionManager
extends ConnectionManager<BoshIOService>
implements BoshSessionTaskHandler {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshConnectionManager");
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    private static final String ROUTING_ENTRY_PROP_VAL = "sess-man@localhost";
    private static final int DEF_PORT_NO = 5280;
    private int[] PORTS = new int[]{5280};
    private static final String HOSTNAMES_PROP_KEY = "hostnames";
    private String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    private RoutingsContainer routings = null;
    private Set<String> hostnames = new TreeSet<String>();
    private long max_wait = 60L;
    private long min_polling = 10L;
    private long max_inactivity = 60L;
    private int concurrent_requests = 2;
    private int hold_requests = 1;
    private long max_pause = 120L;
    private Map<UUID, BoshSession> sessions = new LinkedHashMap<UUID, BoshSession>();
    private Timer boshTasks = new Timer("BoshTasks");

    @Override
    public void processPacket(Packet packet) {
        log.finer("Processing packet: " + packet.getElemName() + ", type: " + (Object)((Object)packet.getType()));
        log.finest("Processing packet: " + packet.toString());
        UUID sid = UUID.fromString(JIDUtils.getNodeResource((String)packet.getTo()));
        BoshSession session = this.sessions.get(sid);
        if (session != null) {
            if (packet.isCommand() && packet.getCommand() != Command.OTHER) {
                this.processCommand(packet, session);
            } else {
                LinkedList<Packet> out_results = new LinkedList<Packet>();
                session.processPacket(packet, out_results);
                this.addOutPackets(out_results, session);
            }
        } else {
            log.warning("Session does not exist for packet: " + packet.toString());
        }
    }

    private void processCommand(Packet packet, BoshSession session) {
        Object serv = this.getXMPPIOService(packet);
        switch (packet.getCommand()) {
            case GETFEATURES: {
                if (packet.getType() != StanzaType.result) break;
                Element elem_features = new Element("stream:features");
                elem_features.addChildren(Command.getData(packet));
                session.processPacket(new Packet(elem_features), null);
                break;
            }
        }
    }

    @Override
    public Queue<Packet> processSocketData(BoshIOService serv) {
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
            log.finest("Processing socket data: " + p.toString());
            String sid_str = p.getAttribute("sid");
            UUID sid = null;
            try {
                LinkedList<Packet> out_results = new LinkedList<Packet>();
                BoshSession bs = null;
                if (sid_str == null) {
                    bs = new BoshSession(this.getDefHostName(), this);
                    sid = bs.getSid();
                    this.sessions.put(sid, bs);
                    bs.init(p, serv, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, out_results);
                } else {
                    sid = UUID.fromString(sid_str);
                    bs = this.sessions.get(sid);
                    if (bs != null) {
                        bs.processSocketPacket(p, serv, out_results);
                    } else {
                        log.warning("There is no session with given SID. Ignoring for now...");
                    }
                }
                this.addOutPackets(out_results, bs);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem processing socket data for sid =  " + sid, e);
            }
        }
        return null;
    }

    private void addOutPackets(Queue<Packet> out_results, BoshSession bs) {
        for (Packet res : out_results) {
            res.setFrom(this.getFromAddress(bs.getSid().toString()));
            res.setTo(this.routings.computeRouting(bs.getDomain()));
            this.addOutPacket(res);
        }
        out_results.clear();
    }

    private String getFromAddress(String id) {
        return JIDUtils.getJID((String)this.getName(), (String)this.getDefHostName(), (String)id);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        props.put(HOSTNAMES_PROP_KEY, this.HOSTNAMES_PROP_VAL);
        props.put("routings/multi-mode", true);
        if (params.get("config-type").equals("--gen-config-cs") && params.get("--ext-comp") != null) {
            String[] comp_params = ((String)params.get("--ext-comp")).split(",");
            props.put("routings/.+", "sess-man@" + comp_params[1]);
        } else {
            props.put("routings/.+", "sess-man@" + this.HOSTNAMES_PROP_VAL[0]);
        }
        props.put("max-wait", 60L);
        props.put("min-polling", 10L);
        props.put("max-inactivity", 60L);
        props.put("concurrent-requests", 2);
        props.put("hold-requests", 1);
        props.put("max-inactivity", 120L);
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        boolean routing_mode = (Boolean)props.get("routings/multi-mode");
        this.routings = new RoutingsContainer(routing_mode);
        int idx = "routings/".length();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("routings/") || entry.getKey().equals("routings/multi-mode")) continue;
            this.routings.addRouting(entry.getKey().substring(idx), (String)entry.getValue());
        }
        String[] hnames = (String[])props.get(HOSTNAMES_PROP_KEY);
        this.clearRoutings();
        this.hostnames.clear();
        for (String host : hnames) {
            this.addRouting(this.getName() + "@" + host);
            this.hostnames.add(host);
        }
        this.max_wait = (Long)props.get("max-wait");
        this.min_polling = (Long)props.get("min-polling");
        this.max_inactivity = (Long)props.get("max-inactivity");
        this.concurrent_requests = (Integer)props.get("concurrent-requests");
        this.hold_requests = (Integer)props.get("hold-requests");
        this.max_pause = (Long)props.get("max-inactivity");
    }

    @Override
    protected int[] getDefPlainPorts() {
        return this.PORTS;
    }

    @Override
    public void serviceStopped(BoshIOService service) {
        BoshSession bs;
        super.serviceStopped(service);
        UUID sid = service.getSid();
        if (sid != null && (bs = this.sessions.get(sid)) != null) {
            bs.disconnected(service);
        }
    }

    @Override
    public void serviceStarted(BoshIOService service) {
        super.serviceStarted(service);
    }

    @Override
    protected long getMaxInactiveTime() {
        return 600000L;
    }

    @Override
    public void xmppStreamClosed(BoshIOService serv) {
        log.finer("Stream closed.");
    }

    @Override
    public String xmppStreamOpened(BoshIOService serv, Map<String, String> attribs) {
        return null;
    }

    @Override
    protected BoshIOService getXMPPIOServiceInstance() {
        return new BoshIOService();
    }

    @Override
    public TimerTask scheduleTask(BoshSession bs, long delay) {
        BoshTask bt = new BoshTask(bs);
        this.boshTasks.schedule((TimerTask)bt, delay);
        return bt;
    }

    @Override
    public void cancelTask(TimerTask tt) {
        tt.cancel();
    }

    private class BoshTask
    extends TimerTask {
        private BoshSession bs = null;

        public BoshTask(BoshSession bs) {
            this.bs = bs;
        }

        @Override
        public void run() {
            LinkedList<Packet> out_results = new LinkedList<Packet>();
            if (this.bs.task(out_results, this)) {
                BoshConnectionManager.this.sessions.remove(this.bs.getSid());
            }
            BoshConnectionManager.this.addOutPackets(out_results, this.bs);
        }
    }
}

