/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import tigase.conf.Configurator;
import tigase.server.MessageRouter;
import tigase.server.ThreadExceptionHandler;

public class XMPPServer {
    public static final String NAME = "Tigase";
    private static String config_file = "tigase-config.xml";
    private static String server_name = "message-router";
    private static boolean debug = false;
    private static boolean monit = false;
    private static String tigaseVersion = null;
    private static boolean gen_config = false;

    protected XMPPServer() {
    }

    public static String help() {
        return "\nParameters:\n -h                this help message\n -v                prints server version info\n -c file           location of configuration file\n -d [true|false]   turn on|off debug mode\n -m                turn on server monitor\n -n server-name    sets server name\n";
    }

    public static String getImplementationVersion() {
        return XMPPServer.class.getPackage().getImplementationVersion();
    }

    public static String version() {
        return "\n-- \nTigase XMPP Server, version: " + XMPPServer.getImplementationVersion() + "\n" + "Author:\tArtur Hefczyc <artur.hefczyc@tigase.org>\n" + "-- \n";
    }

    public static void parseParams(String[] args) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(XMPPServer.help());
                    System.exit(0);
                }
                if (args[i].equals("-v")) {
                    System.out.print(XMPPServer.version());
                    System.exit(0);
                }
                if (args[i].equals("-c")) {
                    if (i + 1 == args.length) {
                        System.out.print(XMPPServer.help());
                        System.exit(1);
                    } else {
                        config_file = args[++i];
                    }
                }
                if (args[i].equals("-n")) {
                    if (i + 1 == args.length) {
                        System.out.print(XMPPServer.help());
                        System.exit(1);
                    } else {
                        server_name = args[++i];
                    }
                }
                if (args[i].equals("-d")) {
                    if (i + 1 == args.length) {
                        debug = true;
                    } else {
                        boolean bl = debug = args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
                    }
                }
                if (args[i].equals("-m")) {
                    monit = true;
                }
                if (!args[i].startsWith("--gen-config")) continue;
                gen_config = true;
            }
        }
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new ThreadExceptionHandler());
        XMPPServer.parseParams(args);
        String initial_config = ".level=ALL\nhandlers=java.util.logging.ConsoleHandler\njava.util.logging.ConsoleHandler.formatter=tigase.util.LogFormatter\n";
        Configurator.loadLogManagerConfig(initial_config);
        Configurator config = new Configurator(config_file, args);
        config.setName("basic-conf");
        MessageRouter router = new MessageRouter();
        router.setName(server_name);
        router.setConfig(config);
        router.start();
    }
}

