/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import tigase.io.IOInterface;

public class SocketIO
implements IOInterface {
    private static Logger log = Logger.getLogger("tigase.io.SocketIO");
    private SocketChannel channel = null;
    private int bytesRead = 0;

    public SocketIO(SocketChannel sock) throws IOException {
        this.channel = sock;
        this.channel.configureBlocking(false);
        this.channel.socket().setSoLinger(false, 0);
        this.channel.socket().setReuseAddress(true);
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    @Override
    public void stop() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public int write(ByteBuffer buff) throws IOException {
        int result = 0;
        while (buff.hasRemaining()) {
            int res = this.channel.write(buff);
            if (res == -1) {
                throw new EOFException("Channel has been closed.");
            }
            result += res;
        }
        log.finer("Wrote to channel " + result + " bytes.");
        return result;
    }

    @Override
    public ByteBuffer read(ByteBuffer buff) throws IOException {
        this.bytesRead = this.channel.read(buff);
        log.finer("Read from channel " + this.bytesRead + " bytes.");
        if (this.bytesRead == -1) {
            throw new EOFException("Channel has been closed.");
        }
        return buff;
    }

    @Override
    public int bytesRead() {
        return this.bytesRead;
    }

    @Override
    public int getInputPacketSize() throws IOException {
        return this.channel.socket().getReceiveBufferSize();
    }
}

