/*
 * Decompiled with CFR 0.152.
 */
package tigase.disco;

import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.xml.Element;

public abstract class XMPPServiceCollector
extends AbstractComponentRegistrator<XMPPService> {
    private static final Logger log = Logger.getLogger("tigase.server.XMPPServiceCollector");
    public static final String INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    public static final String ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    private ServiceEntity serviceEntity = new ServiceEntity("Tigase", "server", "Session manager");

    public XMPPServiceCollector() {
        this.serviceEntity.addIdentities(new ServiceIdentity("server", "im", "Tigase ver. " + XMPPServer.getImplementationVersion()));
    }

    @Override
    public void componentAdded(XMPPService component) {
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof XMPPService;
    }

    @Override
    public void componentRemoved(XMPPService component) {
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (packet.isXMLNS("/iq/query", INFO_XMLNS) || packet.isXMLNS("/iq/query", ITEMS_XMLNS)) {
            String jid = packet.getElemTo();
            String node = packet.getAttribute("/iq/query", "node");
            Element query = packet.getElement().getChild("query").clone();
            if (packet.isXMLNS("/iq/query", INFO_XMLNS)) {
                for (XMPPService comp : this.components.values()) {
                    Element resp = comp.getDiscoInfo(node, jid);
                    if (resp == null) continue;
                    query = resp;
                    break;
                }
            }
            if (packet.isXMLNS("/iq/query", ITEMS_XMLNS)) {
                for (XMPPService comp : this.components.values()) {
                    List<Element> items = comp.getDiscoItems(node, jid);
                    if (items == null || items.size() <= 0) continue;
                    query.addChildren(items);
                }
            }
            results.offer(packet.okResult(query, 0));
        }
    }
}

