/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.util.JIDUtils;

public class LibreSourceAuth
implements UserAuthRepository {
    private static final Logger log = Logger.getLogger("tigase.db.jdbc.LibreSourceAuth");
    private static final String[] non_sasl_mechs = new String[]{"password", "digest"};
    private static final String[] sasl_mechs = new String[]{"PLAIN", "DIGEST-MD5", "CRAM-MD5"};
    public static final String DEF_USERS_TBL = "casusers_";
    public static final String DEF_PROFILES_TBL = "profileresource_";
    private String users_tbl = "casusers_";
    private String profiles_tbl = "profileresource_";
    private String db_conn = null;
    private Connection conn = null;
    private PreparedStatement pass_st = null;
    private PreparedStatement status_st = null;
    private PreparedStatement conn_valid_st = null;
    private PreparedStatement update_password = null;
    private PreparedStatement update_last_login_st = null;
    private PreparedStatement update_online_status = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;

    private void initPreparedStatements() throws SQLException {
        String query = "select passworddigest_ from " + this.users_tbl + " where username_ = ?;";
        this.pass_st = this.conn.prepareStatement(query);
        query = "select accountstatus_ from " + this.profiles_tbl + " where id_ = ?;";
        this.status_st = this.conn.prepareStatement(query);
        query = "select localtime;";
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "update " + this.users_tbl + " set passworddigest_ = ? where username_ = ?;";
        this.update_password = this.conn.prepareStatement(query);
        query = "update " + this.profiles_tbl + " set lastlogintime_ = ? where id_ = ?;";
        this.update_last_login_st = this.conn.prepareStatement(query);
        query = "update " + this.profiles_tbl + " set onlinestatus_ = ? where id_ = ?;";
        this.update_online_status = this.conn.prepareStatement(query);
    }

    private boolean checkConnection() throws SQLException {
        try {
            long tmp = System.currentTimeMillis();
            if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                this.conn_valid_st.executeQuery();
                this.lastConnectionValidated = tmp;
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void updateLastLogin(String user) throws TigaseDBException {
        try {
            this.update_last_login_st.setDate(1, new Date(System.currentTimeMillis()));
            this.update_last_login_st.setString(2, JIDUtils.getNodeNick((String)user));
            this.update_last_login_st.executeUpdate();
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error accessin repository.", e);
        }
    }

    private void updateOnlineStatus(String user, int status) throws TigaseDBException {
        try {
            this.update_online_status.setInt(1, status);
            this.update_online_status.setString(2, JIDUtils.getNodeNick((String)user));
            this.update_online_status.executeUpdate();
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error accessin repository.", e);
        }
    }

    private boolean isActive(String user) throws SQLException, UserNotFoundException {
        block3: {
            ResultSet rs = null;
            try {
                this.status_st.setString(1, JIDUtils.getNodeNick((String)user));
                rs = this.status_st.executeQuery();
                if (!rs.next()) break block3;
                int res = rs.getInt(1);
                boolean bl = rs.wasNull() || res == 0;
                this.release(null, rs);
                return bl;
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
        throw new UserNotFoundException("User does not exist: " + user);
    }

    private String getPassword(String user) throws SQLException, UserNotFoundException {
        block3: {
            ResultSet rs = null;
            try {
                this.pass_st.setString(1, JIDUtils.getNodeNick((String)user));
                rs = this.pass_st.executeQuery();
                if (!rs.next()) break block3;
                String string = rs.getString(1);
                this.release(null, rs);
                return string;
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
        throw new UserNotFoundException("User does not exist: " + user);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", non_sasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", sasl_mechs);
        }
    }

    private void initRepo() throws SQLException {
        this.conn = DriverManager.getConnection(this.db_conn);
        this.initPreparedStatements();
    }

    @Override
    public void initRepository(String connection_str) throws DBInitException {
        this.db_conn = connection_str;
        try {
            this.initRepo();
        }
        catch (SQLException e) {
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
    }

    @Override
    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public boolean plainAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        try {
            this.checkConnection();
            if (!this.isActive(user)) {
                throw new AuthorizationException("User account has been blocked.");
            }
            String db_password = this.getPassword(user);
            boolean login_ok = db_password.equals(password);
            if (login_ok) {
                this.updateLastLogin(user);
                this.updateOnlineStatus(user, 1);
            }
            return login_ok;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Override
    public void logout(String user) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            this.updateOnlineStatus(user, 0);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Override
    public boolean digestAuth(String user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        try {
            this.checkConnection();
            if (!this.isActive(user)) {
                throw new AuthorizationException("User account has been blocked.");
            }
            String db_password = this.getPassword(user);
            String digest_db_pass = Algorithms.hexDigest((String)id, (String)db_password, (String)alg);
            log.finest("Comparing passwords, given: " + digest + ", db: " + digest_db_pass);
            return digest.equals(digest_db_pass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthorizationException("No such algorithm.", e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            boolean login_ok = this.saslAuth(props);
            if (login_ok) {
                String user = (String)props.get("user-id");
                this.updateLastLogin(user);
                this.updateOnlineStatus(user, 1);
            }
            return login_ok;
        }
        throw new AuthorizationException("Protocol is not supported: " + proto);
    }

    @Override
    public void addUser(String user, String password) throws UserExistsException, TigaseDBException {
        Statement stmt = null;
        try {
            this.checkConnection();
            stmt = this.conn.createStatement();
            String query = "insert into " + this.users_tbl + " (username_, passworddigest_)" + " values ('" + JIDUtils.getNodeNick((String)user) + "', '" + password + "');";
            stmt.executeUpdate(query);
            query = "insert into " + this.profiles_tbl + " (id_, accountstatus_)" + " values ('" + JIDUtils.getNodeNick((String)user) + "', 0);";
            stmt.executeUpdate(query);
            this.release(stmt, null);
            stmt = null;
        }
        catch (SQLException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", e);
            }
            catch (Throwable throwable) {
                this.release(stmt, null);
                stmt = null;
                throw throwable;
            }
        }
    }

    @Override
    public void updatePassword(String user, String password) throws UserExistsException, TigaseDBException {
        try {
            this.checkConnection();
            this.update_password.setString(1, password);
            this.update_password.setString(2, JIDUtils.getNodeNick((String)user));
            this.update_password.executeUpdate();
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error accessin repository.", e);
        }
    }

    @Override
    public void removeUser(String user) throws UserNotFoundException, TigaseDBException {
        Statement stmt = null;
        try {
            this.checkConnection();
            stmt = this.conn.createStatement();
            String query = "delete from " + this.users_tbl + " where (username_ = '" + JIDUtils.getNodeNick((String)user) + "');";
            stmt.executeUpdate(query);
            query = "delete from " + this.profiles_tbl + " where (id_ = '" + JIDUtils.getNodeNick((String)user) + "');";
            stmt.executeUpdate(query);
            this.release(stmt, null);
            stmt = null;
        }
        catch (SQLException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", e);
            }
            catch (Throwable throwable) {
                this.release(stmt, null);
                stmt = null;
                throw throwable;
            }
        }
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            String data_str;
            SaslServer ss = (SaslServer)props.get("SaslServer");
            if (ss == null) {
                TreeMap<String, String> sasl_props = new TreeMap<String, String>();
                sasl_props.put("javax.security.sasl.qop", "auth");
                ss = Sasl.createSaslServer((String)props.get("mechanism"), "xmpp", (String)props.get("server-name"), sasl_props, new SaslCallbackHandler(props));
                props.put("SaslServer", ss);
            }
            byte[] in_data = (data_str = (String)props.get("data")) != null ? Base64.decode((String)data_str) : new byte[]{};
            byte[] challenge = ss.evaluateResponse(in_data);
            log.finest("challenge: " + (challenge != null ? new String(challenge) : "null"));
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode((byte[])challenge) : null;
            props.put("result", challenge_str);
            return ss.isComplete();
        }
        catch (SaslException e) {
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    private class SaslCallbackHandler
    implements CallbackHandler {
        private Map<String, Object> options = null;

        private SaslCallbackHandler(Map<String, Object> options) {
            this.options = options;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String jid = null;
            for (int i = 0; i < callbacks.length; ++i) {
                log.finest("Callback: " + callbacks[i].getClass().getSimpleName());
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    String realm = (String)this.options.get("realm");
                    if (realm != null) {
                        rc.setText(realm);
                    }
                    log.finest("RealmCallback: " + realm);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String user_name = nc.getName();
                    if (user_name == null) {
                        user_name = nc.getDefaultName();
                    }
                    jid = JIDUtils.getNodeID((String)user_name, (String)((String)this.options.get("realm")));
                    this.options.put("user-id", jid);
                    log.finest("NameCallback: " + user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    try {
                        String passwd = LibreSourceAuth.this.getPassword(jid);
                        pc.setPassword(passwd.toCharArray());
                        log.finest("PasswordCallback: " + passwd);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Password retrieving problem.", e);
                    }
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    log.finest("AuthorizeCallback: authenId: " + authenId);
                    String authorId = authCallback.getAuthorizationID();
                    log.finest("AuthorizeCallback: authorId: " + authorId);
                    if (!authenId.equals(authorId)) continue;
                    authCallback.setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

