/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db.derby;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

public class StoredProcedures {
    private static final Logger log = Logger.getLogger(StoredProcedures.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF-8");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addJid(BareJID bareJid, String jidSha1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try (ResultSet rs = null;){
            PreparedStatement ps = conn.prepareStatement("insert into tig_ma_jids (jid, \"domain\", jid_sha1) select ?, ?, ? from sysibm.sysdummy1 where not exists (select 1 from tig_ma_jids where jid_sha1 = ?)", 1);
            ps.setString(1, bareJid.toString());
            ps.setString(2, bareJid.getDomain());
            ps.setString(3, jidSha1);
            ps.setString(4, jidSha1);
            ps.executeUpdate();
        }
    }

    public static void addMessage(String ownerJid, String buddyJid, Timestamp ts, String stableId, String stanzaId, String refStableId, String body, String msg) throws SQLException {
        long ownerId = StoredProcedures.ensureJid(ownerJid);
        long buddyId = StoredProcedures.ensureJid(buddyJid);
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("insert into tig_ma_msgs (owner_id, buddy_id, ts, stable_id, stanza_id, is_ref, ref_stable_id, body, msg) select ?, ?, ?, ?, ?, ?, ?, ?, ? from SYSIBM.SYSDUMMY1 where not exists ( select 1 from tig_ma_msgs where owner_id = ? and stable_id = ?)", 1);
            int i = 0;
            ps.setLong(++i, ownerId);
            ps.setLong(++i, buddyId);
            ps.setTimestamp(++i, ts);
            ps.setString(++i, stableId);
            ps.setString(++i, stanzaId);
            ps.setShort(++i, (short)(refStableId != null ? 1 : 0));
            ps.setString(++i, refStableId);
            ps.setString(++i, body);
            ps.setString(++i, msg);
            ps.setLong(++i, ownerId);
            ps.setString(++i, stableId);
            ps.execute();
        }
    }

    public static void addTagToMessage(String ownerJid, String stableId, String tag) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Long ownerId = StoredProcedures.ensureJid(ownerJid);
            PreparedStatement ps = conn.prepareStatement("select tag_id from tig_ma_tags where owner_id = ? and tag = ?");
            ps.setLong(1, ownerId);
            ps.setString(2, tag);
            ResultSet rs = ps.executeQuery();
            long tagId = -1L;
            if (!rs.next()) {
                rs.close();
                ps = conn.prepareStatement("insert into tig_ma_tags (owner_id, tag) values (?,?)", 1);
                ps.setLong(1, ownerId);
                ps.setString(2, tag);
                ps.execute();
                rs = ps.getGeneratedKeys();
                rs.next();
            }
            tagId = rs.getLong(1);
            rs.close();
            ps = conn.prepareStatement("insert into tig_ma_msgs_tags (msg_owner_id, msg_stable_id, tag_id) select ?, ?, ? from SYSIBM.SYSDUMMY1 where not exists (select 1 from tig_ma_msgs_tags mt where mt.msg_owner_id = ? and mt.msg_stable_id = ? and mt.tag_id = ?)");
            ps.setLong(1, ownerId);
            ps.setString(2, stableId);
            ps.setLong(3, tagId);
            ps.setLong(4, ownerId);
            ps.setString(5, stableId);
            ps.setLong(6, tagId);
            ps.executeUpdate();
        }
    }

    protected static StringBuilder appendContainsQuery(StringBuilder sb, String contains) {
        if (contains != null) {
            sb.append(" and m.body like ").append(contains.replace("','", "' and m.body like '"));
        }
        return sb;
    }

    protected static StringBuilder appendTagsQuery(StringBuilder sb, String tags) {
        if (tags != null) {
            sb.append(" and exists(select 1 from tig_ma_msgs_tags mt inner join tig_ma_tags t on mt.tag_id = t.tag_id where m.owner_id = mt.msg_owner_id and m.stable_id = mt.msg_stable_id and t.owner_id = o.jid_id and t.tag IN (").append(tags).append("))");
        }
        return sb;
    }

    private static int countMessages(Connection conn) throws SQLException {
        ResultSet rs = conn.prepareStatement("select count(1) from tig_ma_msgs").executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        return -1;
    }

    public static void deleteExpiredMessages(String domain, Timestamp before) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_ma_msgs where ts <= ? and exists (select 1 from tig_ma_jids o where owner_id = o.jid_id and o.\"domain\" = ?)");
            ps.setTimestamp(1, before);
            ps.setString(2, domain);
            ps.execute();
            ps = conn.prepareStatement("delete from tig_ma_jids where  not exists (    select 1 from tig_ma_msgs m where m.owner_id = jid_id  )  and not exists (    select 1 from tig_ma_msgs m where m.buddy_id = jid_id  )");
            ps.execute();
        }
    }

    public static synchronized Long ensureJid(String jid) throws SQLException {
        BareJID bareJid = BareJID.bareJIDInstanceNS((String)jid);
        String jidSha1 = StoredProcedures.sha1OfLower(jid);
        StoredProcedures.addJid(bareJid, jidSha1);
        return StoredProcedures.getJidId(bareJid, jidSha1);
    }

    public static void getCollections(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder sb = new StringBuilder();
            sb.append("select min(m.ts), b.jid");
            sb.append(" from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                sb.append(" and b.jid_sha1 = ?");
            }
            sb.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            if (from != null) {
                sb.append(" and m.ts >= ?");
            }
            if (to != null) {
                sb.append(" and m.ts <= ?");
            }
            StoredProcedures.appendTagsQuery(sb, tags);
            StoredProcedures.appendContainsQuery(sb, contains);
            sb.append(" group by date(m.ts), m.buddy_id, b.jid");
            sb.append(" order by min(m.ts), b.jid");
            sb.append(" offset ? rows fetch next ? rows only");
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            int i = 0;
            ps.setString(++i, StoredProcedures.sha1OfLower(ownerJid));
            if (buddyJid != null) {
                ps.setString(++i, StoredProcedures.sha1OfLower(buddyJid));
            }
            if (from != null) {
                ps.setTimestamp(++i, from);
            }
            if (to != null) {
                ps.setTimestamp(++i, to);
            }
            ps.setInt(++i, offset);
            ps.setInt(++i, limit);
            data[0] = ps.executeQuery();
        }
    }

    public static void getCollectionsCount(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder sb = new StringBuilder();
            sb.append("select count(1) from (select min(m.ts), b.jid");
            sb.append(" from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                sb.append(" and b.jid_sha1 = ?");
            }
            sb.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            if (from != null) {
                sb.append(" and m.ts >= ?");
            }
            if (to != null) {
                sb.append(" and m.ts <= ?");
            }
            StoredProcedures.appendTagsQuery(sb, tags);
            StoredProcedures.appendContainsQuery(sb, contains);
            sb.append(" group by date(m.ts), m.buddy_id, b.jid");
            sb.append(") x");
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            int i = 0;
            ps.setString(++i, StoredProcedures.sha1OfLower(ownerJid));
            if (buddyJid != null) {
                ps.setString(++i, StoredProcedures.sha1OfLower(buddyJid));
            }
            if (from != null) {
                ps.setTimestamp(++i, from);
            }
            if (to != null) {
                ps.setTimestamp(++i, to);
            }
            data[0] = ps.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getJidId(BareJID bareJid, String jidSha1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try (ResultSet rs = null;){
            PreparedStatement ps = conn.prepareStatement("select jid_id from tig_ma_jids where jid_sha1 = ?");
            ps.setString(1, jidSha1);
            rs = ps.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            Long l = null;
            return l;
        }
    }

    public static void getMessagePosition(String ownerJid, String buddyJid, Timestamp from, Timestamp to, short refType, String tags, String contains, String stableId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder sb = new StringBuilder();
            sb.append("select m.stable_id, row_number() over () as position from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                sb.append(" and b.jid_sha1 = ?");
            }
            if (refType == 1) {
                sb.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            } else {
                sb.append(" and (m.is_ref = 0)");
            }
            if (from != null) {
                sb.append(" and m.ts >= ?");
            }
            if (to != null) {
                sb.append(" and m.ts <= ?");
            }
            StoredProcedures.appendTagsQuery(sb, tags);
            StoredProcedures.appendContainsQuery(sb, contains);
            sb.append(" order by m.ts");
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            int i = 0;
            ps.setString(++i, StoredProcedures.sha1OfLower(ownerJid));
            if (buddyJid != null) {
                ps.setString(++i, StoredProcedures.sha1OfLower(buddyJid));
            }
            if (from != null) {
                ps.setTimestamp(++i, from);
            }
            if (to != null) {
                ps.setTimestamp(++i, to);
            }
            i = 0;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!stableId.equals(rs.getString(1))) continue;
                i = rs.getInt(2);
                break;
            }
            rs.close();
            String q = "select " + i + " as position from SYSIBM.SYSDUMMY1 where " + i + " <> 0";
            data[0] = conn.prepareStatement(q).executeQuery();
        }
    }

    public static void getMessage(String ownerJid, String stableId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder sb = new StringBuilder();
            sb.append("select m.msg, m.ts, b.jid, m.stable_id, m.ref_stable_id from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where m.stable_id = ? and o.jid_sha1 = ?");
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            int i = 0;
            ps.setString(++i, stableId);
            ps.setString(++i, StoredProcedures.sha1OfLower(ownerJid));
            data[0] = ps.executeQuery();
        }
    }

    public static void getMessages(String ownerJid, String buddyJid, Timestamp from, Timestamp to, short refType, String tags, String contains, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder sb = new StringBuilder();
            sb.append("select m.msg, m.ts, b.jid, m.stable_id, m.ref_stable_id from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                sb.append(" and b.jid_sha1 = ?");
            }
            if (refType == 1) {
                sb.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            } else {
                sb.append(" and (m.is_ref = 0)");
            }
            if (from != null) {
                sb.append(" and m.ts >= ?");
            }
            if (to != null) {
                sb.append(" and m.ts <= ?");
            }
            StoredProcedures.appendTagsQuery(sb, tags);
            StoredProcedures.appendContainsQuery(sb, contains);
            sb.append(" order by m.ts");
            sb.append(" offset ? rows fetch next ? rows only");
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            int i = 0;
            ps.setString(++i, StoredProcedures.sha1OfLower(ownerJid));
            if (buddyJid != null) {
                ps.setString(++i, StoredProcedures.sha1OfLower(buddyJid));
            }
            if (from != null) {
                ps.setTimestamp(++i, from);
            }
            if (to != null) {
                ps.setTimestamp(++i, to);
            }
            ps.setInt(++i, offset);
            ps.setInt(++i, limit);
            data[0] = ps.executeQuery();
        }
    }

    public static void getMessagesCount(String ownerJid, String buddyJid, Timestamp from, Timestamp to, short refType, String tags, String contains, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder sb = new StringBuilder();
            sb.append("select count(1) from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                sb.append(" and b.jid_sha1 = ?");
            }
            if (refType == 1) {
                sb.append(" and (m.is_ref = 0 or m.is_ref = 1)");
            } else {
                sb.append(" and (m.is_ref = 0)");
            }
            if (from != null) {
                sb.append(" and m.ts >= ?");
            }
            if (to != null) {
                sb.append(" and m.ts <= ?");
            }
            StoredProcedures.appendTagsQuery(sb, tags);
            StoredProcedures.appendContainsQuery(sb, contains);
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            int i = 0;
            ps.setString(++i, StoredProcedures.sha1OfLower(ownerJid));
            if (buddyJid != null) {
                ps.setString(++i, StoredProcedures.sha1OfLower(buddyJid));
            }
            if (from != null) {
                ps.setTimestamp(++i, from);
            }
            if (to != null) {
                ps.setTimestamp(++i, to);
            }
            data[0] = ps.executeQuery();
        }
    }

    public static void getTagsForUser(String ownerJid, String tagStartsWith, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select t.tag from tig_ma_tags t inner join tig_ma_jids o on o.jid_id = t.owner_id where o.jid_sha1 = ? and t.tag like ? order by t.tag offset ? rows fetch next ? rows only");
            ps.setString(1, StoredProcedures.sha1OfLower(ownerJid));
            ps.setString(2, tagStartsWith);
            ps.setInt(3, offset);
            ps.setInt(4, limit);
            data[0] = ps.executeQuery();
        }
    }

    public static void getTagsForUserCount(String ownerJid, String tagStartsWith, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select count(t.tag_id) from tig_ma_tags t inner join tig_ma_jids o on o.jid_id = t.owner_id where o.jid_sha1 = ? and t.tag like ?");
            ps.setString(1, StoredProcedures.sha1OfLower(ownerJid));
            ps.setString(2, tagStartsWith);
            data[0] = ps.executeQuery();
        }
    }

    public static void removeMessages(String ownerJid, String buddyJid, Timestamp from, Timestamp to) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Long ownerId = StoredProcedures.getJidId(BareJID.bareJIDInstanceNS((String)ownerJid), StoredProcedures.sha1OfLower(ownerJid));
            if (ownerId == null) {
                return;
            }
            if (buddyJid != null) {
                Long buddyId = StoredProcedures.getJidId(BareJID.bareJIDInstanceNS((String)buddyJid), StoredProcedures.sha1OfLower(buddyJid));
                if (buddyId == null) {
                    return;
                }
                StringBuilder sb = new StringBuilder("delete from tig_ma_msgs where owner_id = ? and buddy_id = ?");
                if (from != null) {
                    sb.append(" and ts >= ?");
                }
                if (to != null) {
                    sb.append(" and ts <= ?");
                }
                PreparedStatement ps = conn.prepareStatement(sb.toString());
                int i = 1;
                ps.setLong(i++, ownerId);
                ps.setLong(i++, buddyId);
                if (from != null) {
                    ps.setTimestamp(i++, from);
                }
                if (to != null) {
                    ps.setTimestamp(i++, to);
                }
                ps.execute();
                ps = conn.prepareStatement("delete from tig_ma_jids where jid_id = ? and not exists (  select 1 from tig_ma_msgs m where m.buddy_id = jid_id ) and not exists (  select 1 from tig_ma_msgs m where m.owner_id = jid_id )");
                ps.setLong(1, buddyId);
                ps.execute();
            } else {
                StringBuilder sb = new StringBuilder("delete from tig_ma_msgs where owner_id = ?");
                if (from != null) {
                    sb.append(" and ts >= ?");
                }
                if (to != null) {
                    sb.append(" and ts <= ?");
                }
                PreparedStatement ps = conn.prepareStatement(sb.toString());
                int i = 1;
                ps.setLong(i++, ownerId);
                if (from != null) {
                    ps.setTimestamp(i++, from);
                }
                if (to != null) {
                    ps.setTimestamp(i++, to);
                }
                ps.execute();
            }
            PreparedStatement ps = conn.prepareStatement("delete from tig_ma_jids where jid_id = ? and not exists (  select 1 from tig_ma_msgs m where m.buddy_id = jid_id ) and not exists (  select 1 from tig_ma_msgs m where m.owner_id = jid_id )");
            ps.setLong(1, ownerId);
            ps.execute();
        }
    }

    protected static String sha1OfLower(String data) throws SQLException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(data.toLowerCase().getBytes(UTF8));
            return Algorithms.bytesToHex((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(e);
        }
    }
}

