/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.io.Writer;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.db.util.importexport.Exporter;
import tigase.db.util.importexport.RepositoryManager;
import tigase.db.util.importexport.RepositoryManagerExtensionBase;
import tigase.server.Message;
import tigase.util.ui.console.CommandlineParameter;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.util.MAMRepositoryManagerExtensionHelper;

public class MAMRepositoryManagerExtension
extends RepositoryManagerExtensionBase {
    private static final Logger log = Logger.getLogger(MAMRepositoryManagerExtension.class.getSimpleName());
    private final CommandlineParameter NO_USER_MAM = new CommandlineParameter.Builder(null, "exclude-user-mam").description("Exclude users MAM archives").type(Boolean.class).defaultValue("false").requireArguments(false).build();

    public Stream<CommandlineParameter> getExportParameters() {
        return Stream.concat(super.getExportParameters(), Stream.of(this.NO_USER_MAM, Exporter.EXPORT_MAM_SINCE, Exporter.EXPORT_MAM_BATCH_SIZE));
    }

    public Stream<CommandlineParameter> getImportParameters() {
        return Stream.concat(super.getImportParameters(), Stream.of(this.NO_USER_MAM));
    }

    public void exportDomainData(String domain, Writer writer) throws Exception {
    }

    public void exportUserData(Path userDirPath, BareJID user, Writer writer) throws Exception {
        if (!RepositoryManager.isSet((CommandlineParameter)this.NO_USER_MAM)) {
            log.info("exporting user " + user + " MAM archive...");
            MAMRepository mamRepository = (MAMRepository)this.getRepository(AbstractMessageArchiveRepository.class, user.getDomain());
            this.exportInclude(writer, userDirPath.resolve("archive.xml"), archiveWriter -> MAMRepositoryManagerExtensionHelper.exportDataFromRepository((MAMRepository)mamRepository, (BareJID)user, (BareJID)user, (Writer)archiveWriter));
        }
    }

    public tigase.db.util.importexport.ImporterExtension startImportUserData(BareJID user, String name, Map<String, String> attrs) throws Exception {
        if (!"archive".equals(name)) {
            return null;
        }
        if (!"urn:xmpp:pie:0#mam".equals(attrs.get("xmlns"))) {
            return null;
        }
        MessageArchiveRepository mamRepository = (MessageArchiveRepository)this.getRepository(AbstractMessageArchiveRepository.class, user.getDomain());
        return new ImporterExtension(mamRepository, user, RepositoryManager.isSet((CommandlineParameter)this.NO_USER_MAM));
    }

    private static class ImporterExtension
    extends MAMRepositoryManagerExtensionHelper.AbstractImporterExtension {
        private final MessageArchiveRepository mamRepository;
        private final boolean skipImport;
        private final BareJID user;

        private ImporterExtension(MessageArchiveRepository mamRepository, BareJID user, boolean skipImport) {
            this.mamRepository = mamRepository;
            this.user = user;
            this.skipImport = skipImport;
            if (!skipImport) {
                log.info("importing user " + user + " MAM archive...");
            }
        }

        protected boolean handleMessage(Message message, String stableId, Date timestamp, Element source) {
            if (!this.skipImport) {
                JID buddy = null;
                if (message.getStanzaFrom() != null && !this.user.equals((Object)message.getStanzaFrom().getBareJID())) {
                    buddy = message.getStanzaFrom();
                }
                if (buddy == null && message.getStanzaTo() != null) {
                    buddy = message.getStanzaTo();
                }
                this.mamRepository.archiveMessage(this.user, buddy, timestamp, message.getElement(), stableId, null);
            }
            return true;
        }

        public void close() throws Exception {
            if (!this.skipImport) {
                log.finest("finished import of MAM archive for " + this.user + ".");
            }
            super.close();
        }
    }
}

