/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.resolve;

import gg.jte.CodeResolver;
import gg.jte.TemplateNotFoundException;
import gg.jte.compiler.IoUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

public class DirectoryCodeResolver
implements CodeResolver {
    private final Path root;

    public DirectoryCodeResolver(Path root) {
        this.root = root;
    }

    public String resolve(String name) {
        try {
            return this.resolveRequired(name);
        }
        catch (TemplateNotFoundException e) {
            return null;
        }
    }

    public String resolveRequired(String name) throws TemplateNotFoundException {
        Path file = this.root.resolve(name);
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (NoSuchFileException e) {
            throw new TemplateNotFoundException(name + " not found (tried to load file at " + String.valueOf(file.toAbsolutePath()) + ")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean exists(String name) {
        Path file = this.root.resolve(name);
        return Files.exists(file, new LinkOption[0]);
    }

    public long getLastModified(String name) {
        return this.getLastModified(this.root.resolve(name));
    }

    private long getLastModified(Path file) {
        return file.toFile().lastModified();
    }

    public List<String> resolveAllTemplateNames() {
        List<String> list;
        block8: {
            Stream<Path> stream = Files.walk(this.root, FileVisitOption.FOLLOW_LINKS);
            try {
                list = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> this.root.relativize((Path)p).toString().replace('\\', '/')).filter(IoUtils::isTemplateFile).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to resolve all templates in " + String.valueOf(this.root), e);
                }
            }
            stream.close();
        }
        return list;
    }

    public Path getRoot() {
        return this.root;
    }
}

