/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler.java;

import gg.jte.ContentType;
import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.compiler.ClassDefinition;
import gg.jte.compiler.CodeBuilder;
import gg.jte.compiler.CodeGenerator;
import gg.jte.compiler.CodeType;
import gg.jte.compiler.ContentProcessor;
import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateCompiler;
import gg.jte.compiler.TemplateDependency;
import gg.jte.compiler.TemplateParser;
import gg.jte.compiler.TemplateType;
import gg.jte.compiler.java.JavaParamInfo;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class JavaCodeGenerator
implements CodeGenerator {
    private final TemplateCompiler compiler;
    private final TemplateConfig config;
    private final ConcurrentHashMap<String, List<ParamInfo>> paramOrder;
    private final ClassInfo classInfo;
    private final CodeBuilder javaCode = new CodeBuilder(CodeType.Java);
    private final LinkedHashSet<ClassDefinition> classDefinitions;
    private final LinkedHashSet<TemplateDependency> templateDependencies;
    private final List<ParamInfo> parameters = new ArrayList<ParamInfo>();
    private final List<String> imports = new ArrayList<String>();
    private final List<byte[]> binaryTextParts = new ArrayList<byte[]>();
    private final Deque<ForLoopStart> forLoopStack = new ArrayDeque<ForLoopStart>();
    private boolean hasWrittenPackage;
    private boolean hasWrittenClass;
    private CodeBuilder.CodeMarker fieldsMarker;
    private int attributeCounter;
    private int nextForLoopId = 1;

    public JavaCodeGenerator(TemplateCompiler compiler, TemplateConfig config, ConcurrentHashMap<String, List<ParamInfo>> paramOrder, ClassInfo classInfo, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies) {
        this.compiler = compiler;
        this.config = config;
        this.paramOrder = paramOrder;
        this.classInfo = classInfo;
        this.classDefinitions = classDefinitions;
        this.templateDependencies = templateDependencies;
    }

    @Override
    public void onImport(String importClass) {
        this.writePackageIfRequired();
        this.imports.add(importClass);
        this.javaCode.append("import ").append(importClass).append(";\n");
    }

    private void writePackageIfRequired() {
        if (!this.hasWrittenPackage) {
            this.javaCode.append("package " + this.classInfo.packageName + ";\n");
            this.hasWrittenPackage = true;
        }
    }

    @Override
    public void onParam(String parameter) {
        ParamInfo paramInfo = JavaParamInfo.parse(parameter, this, this.getCurrentTemplateLine());
        this.writePackageIfRequired();
        if (!this.hasWrittenClass) {
            this.writeClass();
        }
        this.javaCode.append(", ").append(paramInfo.type).append(' ').append(paramInfo.name);
        this.parameters.add(paramInfo);
    }

    private void writeClass() {
        this.javaCode.append("public final class ").append(this.classInfo.className).append(" {\n");
        this.fieldsMarker = this.javaCode.getMarkerOfCurrentPosition();
        this.javaCode.append("\tpublic static void render(");
        this.writeTemplateOutputParam();
        this.javaCode.append(", gg.jte.html.HtmlInterceptor jteHtmlInterceptor");
        this.hasWrittenClass = true;
    }

    private String getContentClass() {
        if (this.config.contentType == ContentType.Html) {
            return "gg.jte.html.HtmlContent";
        }
        return "gg.jte.Content";
    }

    private void writeTemplateOutputParam() {
        if (this.config.contentType == ContentType.Html) {
            this.javaCode.append("gg.jte.html.HtmlTemplateOutput jteOutput");
        } else {
            this.javaCode.append("gg.jte.TemplateOutput jteOutput");
        }
    }

    @Override
    public void onParamsComplete() {
        this.writePackageIfRequired();
        if (!this.hasWrittenClass) {
            this.writeClass();
        }
        this.javaCode.append(") {\n");
        this.paramOrder.put(this.classInfo.name, this.parameters);
    }

    @Override
    public void onLineFinished() {
        this.javaCode.finishTemplateLine();
    }

    @Override
    public void onComplete() {
        this.javaCode.append("\t}\n");
        this.javaCode.append("\tpublic static void renderMap(");
        this.writeTemplateOutputParam();
        this.javaCode.append(", gg.jte.html.HtmlInterceptor jteHtmlInterceptor");
        this.javaCode.append(", java.util.Map<String, Object> params) {\n");
        for (ParamInfo parameter : this.parameters) {
            if (parameter.varargs) continue;
            this.javaCode.setCurrentTemplateLine(parameter.templateLine);
            this.javaCode.append("\t\t").append(parameter.type).append(" ").append(parameter.name).append(" = (").append(parameter.type);
            if (parameter.defaultValue != null) {
                this.javaCode.append(")params.getOrDefault(\"").append(parameter.name).append("\", ");
                this.writeJavaCodeWithContentSupport(0, parameter.defaultValue);
                this.javaCode.append(");\n");
                continue;
            }
            this.javaCode.append(")params.get(\"").append(parameter.name).append("\");\n");
        }
        this.javaCode.append("\t\trender(jteOutput, jteHtmlInterceptor");
        for (ParamInfo parameter : this.parameters) {
            if (parameter.varargs) continue;
            this.javaCode.append(", ").append(parameter.name);
        }
        this.javaCode.append(");\n");
        this.javaCode.append("\t}\n");
        this.javaCode.append("}\n");
        int lineCount = 2;
        if (!this.binaryTextParts.isEmpty()) {
            lineCount += this.binaryTextParts.size() + 1;
        }
        this.javaCode.fillLines(this.fieldsMarker, lineCount);
        StringBuilder fields = new StringBuilder();
        this.addNameField(fields, this.classInfo.name);
        this.addLineInfoField(fields);
        this.writeBinaryTextParts(fields);
        this.javaCode.insert(this.fieldsMarker, fields, false);
        this.classInfo.lineInfo = this.javaCode.getLineInfo();
    }

    private void addLineInfoField(StringBuilder fields) {
        fields.append("\tpublic static final int[] ").append("JTE_LINE_INFO").append(" = {");
        for (int i = 0; i < this.javaCode.getCurrentCodeLine(); ++i) {
            if (i > 0) {
                fields.append(',');
            }
            fields.append(this.javaCode.getLineInfo(i));
        }
        fields.append("};\n");
    }

    private void addNameField(StringBuilder fields, String name) {
        fields.append("\tpublic static final String ").append("JTE_NAME").append(" = \"");
        fields.append(name);
        fields.append("\";\n");
    }

    private void writeBinaryTextParts(StringBuilder fields) {
        if (this.binaryTextParts.isEmpty()) {
            return;
        }
        this.writeBinaryTextPartsContent(fields);
        this.writeBinaryTextPartsConstants(fields);
    }

    private void writeBinaryTextPartsContent(StringBuilder fields) {
        String contentFileName = new ClassDefinition(this.classInfo.className, "java").getBinaryTextPartsFileName();
        fields.append("\tprivate static final gg.jte.runtime.BinaryContent BINARY_CONTENT = gg.jte.runtime.BinaryContent.load(").append(this.classInfo.className).append(".class, \"").append(contentFileName).append("\", ");
        for (int i = 0; i < this.binaryTextParts.size(); ++i) {
            if (i > 0) {
                fields.append(',');
            }
            fields.append(this.binaryTextParts.get(i).length);
        }
        fields.append(");\n");
    }

    private void writeBinaryTextPartsConstants(StringBuilder fields) {
        for (int i = 0; i < this.binaryTextParts.size(); ++i) {
            fields.append("\tprivate static final byte[] ").append("TEXT_PART_BINARY_").append(i).append(" = BINARY_CONTENT.get(").append(i).append(");\n");
        }
    }

    @Override
    public void onError(String message) {
        DebugInfo debugInfo = this.getCurrentDebugInfo();
        throw new TemplateException("Failed to compile " + debugInfo.name + ", error at line " + debugInfo.line + ": " + message);
    }

    @Override
    public void onError(String message, int templateLine) {
        DebugInfo debugInfo = this.getDebugInfo(templateLine);
        throw new TemplateException("Failed to compile " + debugInfo.name + ", error at line " + debugInfo.line + ": " + message);
    }

    @Override
    public void onTextPart(int depth, String textPart) {
        if (textPart.isEmpty()) {
            return;
        }
        if (this.config.binaryStaticContent) {
            this.writeTextBinary(depth, textPart);
        } else {
            this.writeTextString(depth, textPart);
        }
    }

    private void writeTextBinary(int depth, String textPart) {
        this.writeIndentation(depth);
        this.javaCode.append("jteOutput.writeBinaryContent(");
        this.javaCode.append("TEXT_PART_BINARY_").append(this.binaryTextParts.size());
        this.javaCode.append(");\n");
        byte[] bytes = textPart.getBytes(StandardCharsets.UTF_8);
        this.binaryTextParts.add(bytes);
    }

    private void writeTextString(int depth, String textPart) {
        int length = textPart.length();
        if (length < 10922) {
            this.writeText(depth, textPart);
        } else {
            int modifiedUtf8Length = 0;
            int chunkOffset = 0;
            for (int i = 0; i < length; ++i) {
                char c = textPart.charAt(i);
                if (c >= '\u0080' || c == '\u0000') {
                    modifiedUtf8Length += c >= '\u0800' ? 2 : 1;
                }
                if (c >= '\ud800' && c <= '\udbff' || modifiedUtf8Length + (i - chunkOffset + 1) <= 65529) continue;
                this.writeText(depth, textPart.substring(chunkOffset, i + 1));
                modifiedUtf8Length = 0;
                chunkOffset = i + 1;
            }
            if (chunkOffset < length) {
                this.writeText(depth, textPart.substring(chunkOffset));
            }
        }
    }

    private void writeText(int depth, String text) {
        this.writeIndentation(depth);
        this.javaCode.append("jteOutput.writeContent(\"");
        this.javaCode.appendEscaped(text);
        this.javaCode.append("\");\n");
    }

    @Override
    public void onCodePart(int depth, String codePart) {
        this.writeCodePart(depth, codePart);
    }

    @Override
    public void onHtmlTagBodyCodePart(int depth, String codePart, String tagName) {
        this.writeIndentation(depth);
        this.javaCode.append("jteOutput.setContext(\"").append(tagName).append("\", null);\n");
        this.writeCodePart(depth, codePart);
    }

    @Override
    public void onHtmlTagAttributeCodePart(int depth, String codePart, String tagName, String attributeName) {
        this.writeIndentation(depth);
        this.javaCode.append("jteOutput.setContext(\"").append(tagName).append("\", \"").append(attributeName).append("\");\n");
        this.writeCodePart(depth, codePart);
        this.writeIndentation(depth);
        this.javaCode.append("jteOutput.setContext(\"").append(tagName).append("\", null);\n");
    }

    @Override
    public void onUnsafeCodePart(int depth, String codePart) {
        this.writeIndentation(depth);
        this.javaCode.append("jteOutput.writeUnsafeContent(");
        this.javaCode.append(codePart);
        this.javaCode.append(");\n");
    }

    private void writeCodePart(int depth, String codePart) {
        this.writeIndentation(depth);
        this.javaCode.append("jteOutput.writeUserContent(");
        this.writeJavaCodeWithContentSupport(depth, codePart);
        this.javaCode.append(");\n");
    }

    @Override
    public void onCodeStatement(int depth, String codePart) {
        this.writeIndentation(depth);
        this.writeJavaCodeWithContentSupport(depth, codePart);
        this.javaCode.append("\n");
    }

    @Override
    public void onConditionStart(int depth, String condition) {
        this.writeIndentation(depth);
        this.javaCode.append("if (");
        this.javaCode.append(condition);
        this.javaCode.append(") {\n");
    }

    @Override
    public void onConditionElse(int depth, String condition) {
        this.writeIndentation(depth);
        this.javaCode.append("} else if (");
        this.javaCode.append(condition);
        this.javaCode.append(") {\n");
    }

    @Override
    public void onConditionElse(int depth) {
        this.writeIndentation(depth);
        this.javaCode.append("} else {\n");
    }

    @Override
    public void onConditionEnd(int depth) {
        this.writeIndentation(depth);
        this.javaCode.append("}\n");
    }

    @Override
    public void onForLoopStart(int depth, String codePart) {
        CodeBuilder.CodeMarker beforeLoop = this.javaCode.getMarkerOfCurrentPosition();
        this.writeIndentation(depth);
        this.javaCode.append("for (").append(codePart).append(") {\n");
        CodeBuilder.CodeMarker inLoop = this.javaCode.getMarkerOfCurrentPosition();
        this.forLoopStack.push(new ForLoopStart(beforeLoop, inLoop, depth, this.nextForLoopId++));
    }

    @Override
    public void onForLoopElse(int depth) {
        ForLoopStart forLoopStart = this.forLoopStack.peek();
        if (forLoopStart != null) {
            String variableName = "__jte_for_loop_entered_" + forLoopStart.id;
            StringBuilder variableDeclaration = new StringBuilder();
            this.writeIndentation(variableDeclaration, forLoopStart.indentation);
            variableDeclaration.append("boolean ").append(variableName).append(" = false;\n");
            this.javaCode.insert(forLoopStart.beforeLoop, variableDeclaration);
            StringBuilder variableAssignment = new StringBuilder();
            this.writeIndentation(variableAssignment, forLoopStart.indentation + 1);
            variableAssignment.append(variableName).append(" = true;\n");
            this.javaCode.insert(forLoopStart.inLoop, variableAssignment);
            this.writeIndentation(depth);
            this.javaCode.append("}\n");
            this.writeIndentation(depth);
            this.javaCode.append("if (!").append(variableName).append(") {\n");
        }
    }

    @Override
    public void onForLoopEnd(int depth) {
        this.forLoopStack.pop();
        this.writeIndentation(depth);
        this.javaCode.append("}\n");
    }

    @Override
    public void onTemplateCall(int depth, String name, List<String> params) {
        ClassInfo tagInfo = this.compiler.generateTemplateCall(name, "jte", this.classDefinitions, this.templateDependencies, this.getCurrentDebugInfo());
        this.writeIndentation(depth);
        this.javaCode.append(tagInfo.fullName).append(".render(jteOutput, jteHtmlInterceptor");
        this.appendParams(depth, tagInfo.name, params);
        this.javaCode.append(");\n");
    }

    @Override
    public void onInterceptHtmlTagOpened(int depth, TemplateParser.HtmlTag htmlTag) {
        this.writeIndentation(depth);
        this.javaCode.append("jteHtmlInterceptor.onHtmlTagOpened(\"").append(htmlTag.name).append("\", ");
        this.writeAttributeMap(htmlTag);
        this.javaCode.append(", jteOutput);\n");
    }

    @Override
    public void onInterceptHtmlTagClosed(int depth, TemplateParser.HtmlTag htmlTag) {
        this.writeIndentation(depth);
        this.javaCode.append("jteHtmlInterceptor.onHtmlTagClosed(\"").append(htmlTag.name).append("\", jteOutput);\n");
    }

    @Override
    public void onHtmlAttributeOutput(int depth, TemplateParser.HtmlTag currentHtmlTag, TemplateParser.HtmlAttribute htmlAttribute) {
        String variableName = this.assignAttributeToVariable(depth, htmlAttribute);
        if (htmlAttribute.bool) {
            this.onConditionStart(depth, variableName);
            this.onTextPart(depth, " " + htmlAttribute.name);
        } else {
            this.onConditionStart(depth, "gg.jte.runtime.TemplateUtils.isAttributeRendered(" + variableName + ")");
            this.onTextPart(depth + 1, " " + htmlAttribute.name + "=" + htmlAttribute.quotes);
            this.onHtmlTagAttributeCodePart(depth + 1, variableName, currentHtmlTag.name, htmlAttribute.name);
            this.onTextPart(depth + 1, "" + htmlAttribute.quotes);
        }
        this.onConditionEnd(depth);
    }

    private String assignAttributeToVariable(int depth, TemplateParser.HtmlAttribute htmlAttribute) {
        String variableName = "__jte_html_attribute_" + this.attributeCounter;
        String variableValue = CodeGenerator.extractSingleOutputTemplateExpression(htmlAttribute.value);
        ++this.attributeCounter;
        htmlAttribute.variableName = variableName;
        this.writeIndentation(depth);
        this.javaCode.append("var ").append(variableName).append(" = ").append(variableValue).append(";\n");
        return variableName;
    }

    private void writeAttributeMap(TemplateParser.HtmlTag htmlTag) {
        CodeGenerator.writeAttributeMap(this.javaCode, htmlTag);
    }

    private void writeJavaCodeWithContentSupport(int depth, String code) {
        if (code.contains("@`")) {
            new JavaContentProcessor(depth, code).process();
        } else {
            this.javaCode.append(code);
        }
    }

    private DebugInfo getCurrentDebugInfo() {
        return this.getDebugInfo(this.getCurrentTemplateLine());
    }

    private DebugInfo getDebugInfo(int templateLine) {
        return new DebugInfo(this.classInfo.name, templateLine + 1);
    }

    @Override
    public int getCurrentTemplateLine() {
        return this.javaCode.getCurrentTemplateLine();
    }

    @Override
    public List<ParamInfo> getParamInfo() {
        return this.parameters;
    }

    @Override
    public List<String> getImports() {
        return this.imports;
    }

    private void appendParams(int depth, String name, List<String> params) {
        List<ParamInfo> paramInfos = this.paramOrder.get(name);
        if (paramInfos == null) {
            throw new IllegalStateException("No parameter information for " + name);
        }
        int index = 0;
        ParamCallInfo[] paramCallInfos = new ParamCallInfo[Math.max(params.size(), paramInfos.size())];
        for (String param : params) {
            ParamCallInfo paramCallInfo = new ParamCallInfo(param);
            int parameterIndex = this.getParameterIndex(name, paramInfos, paramCallInfo);
            if (parameterIndex == -1) {
                parameterIndex = index;
            }
            paramCallInfos[parameterIndex] = paramCallInfo;
            ++index;
        }
        for (int i = 0; i < paramCallInfos.length; ++i) {
            ParamCallInfo paramCallInfo = paramCallInfos[i];
            if (paramCallInfo != null) {
                this.appendParam(depth, paramCallInfo.data);
                continue;
            }
            ParamInfo paramInfo = paramInfos.get(i);
            if (paramInfo.defaultValue == null) continue;
            this.appendParam(depth, paramInfo.defaultValue);
        }
    }

    private void appendParam(int depth, String param) {
        this.javaCode.append(", ");
        this.writeJavaCodeWithContentSupport(depth, param);
    }

    private int getParameterIndex(String name, List<ParamInfo> paramInfos, ParamCallInfo paramCallInfo) {
        if (paramCallInfo.name == null) {
            return -1;
        }
        for (int i = 0; i < paramInfos.size(); ++i) {
            if (!paramInfos.get((int)i).name.equals(paramCallInfo.name)) continue;
            return i;
        }
        throw new TemplateException("Failed to compile template, error at " + this.classInfo.name + ":" + this.getCurrentTemplateLine() + ". No parameter with name " + paramCallInfo.name + " is defined in " + name);
    }

    private void writeIndentation(int depth) {
        for (int i = 0; i < depth + 2; ++i) {
            this.javaCode.append('\t');
        }
    }

    private void writeIndentation(StringBuilder code, int depth) {
        for (int i = 0; i < depth + 2; ++i) {
            code.append('\t');
        }
    }

    @Override
    public String getCode() {
        return this.javaCode.getCode();
    }

    @Override
    public List<byte[]> getBinaryTextParts() {
        return this.binaryTextParts;
    }

    private record ForLoopStart(CodeBuilder.CodeMarker beforeLoop, CodeBuilder.CodeMarker inLoop, int indentation, int id) {
    }

    class JavaContentProcessor
    extends ContentProcessor {
        public JavaContentProcessor(int depth, String code) {
            super(depth, code);
        }

        @Override
        protected void onContentBlock(int depth, String code, int lastWrittenIndex, int startIndex, int endIndex) {
            JavaCodeGenerator.this.javaCode.append(code, lastWrittenIndex + 1, startIndex - 2);
            JavaCodeGenerator.this.javaCode.append("new ").append(JavaCodeGenerator.this.getContentClass()).append("() {\n");
            JavaCodeGenerator.this.writeIndentation(depth + 1);
            JavaCodeGenerator.this.javaCode.append("public void writeTo(");
            JavaCodeGenerator.this.writeTemplateOutputParam();
            JavaCodeGenerator.this.javaCode.append(") {\n");
            TemplateParser parser = new TemplateParser(code, TemplateType.Content, JavaCodeGenerator.this, JavaCodeGenerator.this.config);
            parser.setStartIndex(startIndex);
            parser.setEndIndex(endIndex);
            parser.setParamsComplete(true);
            parser.parse(depth + 2);
            JavaCodeGenerator.this.writeIndentation(depth + 1);
            JavaCodeGenerator.this.javaCode.append("}\n");
            JavaCodeGenerator.this.writeIndentation(depth);
            JavaCodeGenerator.this.javaCode.append("}");
        }

        @Override
        protected void onRemainingCode(String code, int startIndex, int endIndex) {
            JavaCodeGenerator.this.javaCode.append(code, startIndex, endIndex);
        }
    }

    private static final class ParamCallInfo {
        final String name;
        final String data;

        public ParamCallInfo(String param) {
            param = param.trim();
            int nameEndIndex = -1;
            int dataStartIndex = -1;
            for (int i = 0; i < param.length(); ++i) {
                char character = param.charAt(i);
                if (nameEndIndex == -1) {
                    if (character == '\"' || character == '\'') break;
                    if (character != '=') continue;
                    nameEndIndex = i;
                    continue;
                }
                if (dataStartIndex != -1 || Character.isWhitespace(character)) continue;
                dataStartIndex = i;
            }
            if (nameEndIndex != -1 && dataStartIndex != -1) {
                this.name = param.substring(0, nameEndIndex).trim();
                this.data = param.substring(dataStartIndex).trim();
            } else {
                this.name = null;
                this.data = param;
            }
        }
    }
}

