/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler.java;

import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.compiler.ClassCompiler;
import gg.jte.compiler.ClassUtils;
import gg.jte.runtime.ClassInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class JavaClassCompiler
implements ClassCompiler {
    @Override
    public void compile(String[] files, List<String> classPath, TemplateConfig config, Path classDirectory, Map<String, ClassInfo> templateByClassName) {
        ArrayList<String> args = new ArrayList<String>(files.length + classPath.size() + 8);
        if (config.compileArgs != null) {
            args.addAll(Arrays.asList(config.compileArgs));
        }
        args.add("-encoding");
        args.add("UTF-8");
        args.add("-parameters");
        if (!classPath.isEmpty()) {
            args.add("-classpath");
            args.add(ClassUtils.join(classPath));
        }
        args.addAll(Arrays.asList(files));
        this.runCompiler(args.toArray(new String[0]), classDirectory, templateByClassName);
    }

    private void runCompiler(String[] args, Path classDirectory, Map<String, ClassInfo> templateByClassName) {
        ByteArrayOutputStream errorStream;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        int result = compiler.run(null, null, new PrintStream((OutputStream)(errorStream = new ByteArrayOutputStream()), true, StandardCharsets.UTF_8), args);
        if (result != 0) {
            String errors = errorStream.toString(StandardCharsets.UTF_8);
            throw new TemplateException(JavaClassCompiler.getErrorMessage(errors, classDirectory, templateByClassName));
        }
    }

    private static String getErrorMessage(String errors, Path classDirectory, Map<String, ClassInfo> templateByClassName) {
        try {
            String absolutePath = classDirectory.toAbsolutePath().toString();
            int classBeginIndex = errors.indexOf(absolutePath) + absolutePath.length() + 1;
            int classEndIndex = errors.indexOf(".java:");
            String className = errors.substring(classBeginIndex, classEndIndex).replace(File.separatorChar, '.');
            int lineStartIndex = classEndIndex + 6;
            int lineEndIndex = errors.indexOf(58, lineStartIndex);
            int javaLine = Integer.parseInt(errors.substring(lineStartIndex, lineEndIndex));
            ClassInfo templateInfo = templateByClassName.get(className);
            int templateLine = templateInfo.lineInfo[javaLine - 1] + 1;
            return "Failed to compile template, error at " + templateInfo.name + ":" + templateLine + "\n" + errors;
        }
        catch (Exception e) {
            return "Failed to compile template, error at\n" + errors;
        }
    }
}

