/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import gg.jte.TemplateConfig;
import gg.jte.compiler.CodeBuilder;
import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateParser;
import gg.jte.compiler.TemplateParserVisitor;
import gg.jte.compiler.TemplateParserVisitorAdapter;
import gg.jte.compiler.TemplateType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface CodeGenerator
extends TemplateParserVisitor {
    public String getCode();

    public List<byte[]> getBinaryTextParts();

    public int getCurrentTemplateLine();

    public static void writeAttributeMap(CodeBuilder code, TemplateParser.HtmlTag htmlTag) {
        code.append("gg.jte.runtime.TemplateUtils.toMap(");
        boolean firstWritten = false;
        for (TemplateParser.HtmlAttribute attribute : htmlTag.attributes) {
            if (firstWritten) {
                code.append(",");
            } else {
                firstWritten = true;
            }
            code.append("\"").append(attribute.name).append("\",");
            if (attribute.value == null) {
                if (attribute.bool) {
                    code.append("true");
                    continue;
                }
                code.append("null");
                continue;
            }
            if (attribute.variableName != null) {
                code.append(attribute.variableName);
                continue;
            }
            List<TemplateExpressionPart> expressionParts = CodeGenerator.extractTemplateExpressionParts(attribute.value);
            if (!expressionParts.isEmpty()) {
                if (expressionParts.size() > 1) {
                    code.append("\"\" + ");
                }
                int index = 0;
                for (TemplateExpressionPart expressionPart : expressionParts) {
                    if (index++ > 0) {
                        code.append(" + ");
                    }
                    switch (expressionPart.type.ordinal()) {
                        case 1: {
                            code.append("(").append(expressionPart.value).append(")");
                            break;
                        }
                        case 0: {
                            code.append("\"").appendEscaped(expressionPart.value).append("\"");
                        }
                    }
                }
                continue;
            }
            code.append("\"").appendEscaped(attribute.value).append("\"");
        }
        code.append(")");
    }

    public static String extractSingleOutputTemplateExpression(String value) {
        int startIndex = value.indexOf("${");
        if (startIndex == -1) {
            return null;
        }
        int endIndex = value.lastIndexOf(125);
        if (endIndex == -1) {
            return null;
        }
        return value.substring(startIndex + 2, endIndex);
    }

    public static List<TemplateExpressionPart> extractTemplateExpressionParts(String value) {
        if (!value.contains("${") || !value.contains("}")) {
            return Collections.emptyList();
        }
        final ArrayList<TemplateExpressionPart> parts = new ArrayList<TemplateExpressionPart>();
        TemplateParser parser = new TemplateParser(value, TemplateType.Content, new TemplateParserVisitorAdapter(){

            @Override
            public void onTextPart(int depth, String textPart) {
                if (!textPart.isEmpty()) {
                    parts.add(new TemplateExpressionPart(TemplateExpressionPart.Type.Text, textPart));
                }
            }

            @Override
            public void onCodePart(int depth, String codePart) {
                parts.add(new TemplateExpressionPart(TemplateExpressionPart.Type.Code, codePart));
            }
        }, TemplateConfig.PLAIN);
        parser.parse();
        return parts;
    }

    public List<ParamInfo> getParamInfo();

    public List<String> getImports();

    public static class TemplateExpressionPart {
        final Type type;
        final String value;

        public TemplateExpressionPart(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        static enum Type {
            Text,
            Code;

        }
    }
}

