/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import gg.jte.compiler.CodeType;
import gg.jte.runtime.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CodeBuilder {
    private static final int INITIAL_CAPACITY = 10;
    private static final int LOAD_FACTOR = 2;
    private final CodeType codeType;
    private final StringBuilder code = new StringBuilder(1024);
    private int currentCodeLine;
    private int currentTemplateLine;
    private int[] lineInfo = new int[10];
    private final List<CodeMarker> codeMarkers = new ArrayList<CodeMarker>();

    public CodeBuilder(CodeType codeType) {
        this.codeType = codeType;
    }

    public CodeBuilder append(String code) {
        this.code.append(code);
        this.addLines(code, 0, code.length());
        return this;
    }

    public CodeBuilder append(String code, int start, int end) {
        this.code.append(code, start, end);
        this.addLines(code, start, end);
        return this;
    }

    public CodeBuilder append(char code) {
        this.code.append(code);
        if (code == '\n') {
            this.addLine(this.currentTemplateLine);
        }
        return this;
    }

    public CodeBuilder append(int integer) {
        this.code.append(integer);
        return this;
    }

    public CodeBuilder appendEscaped(String text) {
        if (this.codeType == CodeType.Kotlin) {
            this.appendEscapedKotlin(this.code, text);
        } else {
            StringUtils.appendEscaped((StringBuilder)this.code, (String)text);
        }
        return this;
    }

    private void appendEscapedKotlin(StringBuilder result, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            if (c == '\n') {
                result.append("\\n");
                continue;
            }
            if (c == '\t') {
                result.append("\\t");
                continue;
            }
            if (c == '\r') {
                result.append("\\r");
                continue;
            }
            if (c == '\b') {
                result.append("\\b");
                continue;
            }
            if (c == '\\') {
                result.append("\\\\");
                continue;
            }
            if (c == '$') {
                result.append("\\$");
                continue;
            }
            result.append(c);
        }
    }

    public CodeBuilder finishTemplateLine() {
        ++this.currentTemplateLine;
        return this;
    }

    public CodeBuilder insert(CodeMarker position, CharSequence codeToInsert) {
        return this.insert(position, codeToInsert, true);
    }

    public CodeBuilder insert(CodeMarker position, CharSequence codeToInsert, boolean fillLines) {
        this.code.insert(position.codeIndex, codeToInsert);
        int insertedLineCount = 0;
        for (int i = 0; i < codeToInsert.length(); ++i) {
            if (codeToInsert.charAt(i) != '\n') continue;
            ++insertedLineCount;
        }
        if (fillLines) {
            this.fillLines(position, insertedLineCount);
        }
        for (CodeMarker codeMarker : this.codeMarkers) {
            if (codeMarker.codeIndex <= position.codeIndex) continue;
            codeMarker.codeIndex += codeToInsert.length();
            codeMarker.codeLine += insertedLineCount;
        }
        return this;
    }

    public void fillLines(CodeMarker position, int insertedLineCount) {
        this.fillLines(position.codeLine, position.templateLine, insertedLineCount);
    }

    public int getCurrentTemplateLine() {
        return this.currentTemplateLine;
    }

    public String getCode() {
        return this.code.toString();
    }

    public CodeMarker getMarkerOfCurrentPosition() {
        CodeMarker codeMarker = new CodeMarker(this.code.length(), this.currentCodeLine, this.currentTemplateLine);
        this.codeMarkers.add(codeMarker);
        return codeMarker;
    }

    private void addLine(int templateLine) {
        if (this.currentCodeLine + 1 > this.lineInfo.length) {
            this.lineInfo = Arrays.copyOf(this.lineInfo, this.lineInfo.length * 2);
        }
        this.lineInfo[this.currentCodeLine] = templateLine;
        ++this.currentCodeLine;
    }

    private void fillLines(int fromJavaLine, int templateLine, int count) {
        if (this.currentCodeLine + count > this.lineInfo.length) {
            this.lineInfo = Arrays.copyOf(this.lineInfo, this.currentCodeLine + count);
        }
        System.arraycopy(this.lineInfo, fromJavaLine, this.lineInfo, fromJavaLine + count, this.currentCodeLine - fromJavaLine);
        Arrays.fill(this.lineInfo, fromJavaLine, fromJavaLine + count, templateLine);
        this.currentCodeLine += count;
    }

    private void addLines(String code, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (code.charAt(i) != '\n') continue;
            this.addLine(this.currentTemplateLine);
        }
    }

    public int[] getLineInfo() {
        return Arrays.copyOf(this.lineInfo, this.currentCodeLine);
    }

    public int getCurrentCodeLine() {
        return this.currentCodeLine;
    }

    public int getLineInfo(int index) {
        return this.lineInfo[index];
    }

    public void setCurrentTemplateLine(int templateLine) {
        this.currentTemplateLine = templateLine;
    }

    public static class CodeMarker {
        private int codeIndex;
        private int codeLine;
        private final int templateLine;

        private CodeMarker(int codeIndex, int codeLine, int templateLine) {
            this.codeIndex = codeIndex;
            this.codeLine = codeLine;
            this.templateLine = templateLine;
        }
    }
}

