/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import tigase.http.AuthProvider;
import tigase.http.DeploymentInfo;
import tigase.http.ServletInfo;
import tigase.http.api.HttpServerIfc;
import tigase.http.java.filters.ProtocolRedirectFilter;
import tigase.http.jetty.security.BasicAndJWTAuthenticator;
import tigase.http.jetty.security.TigasePlainLoginService;

public class JettyHttpServerHelper {
    public static final String CONTEXT_KEY = "context-key";
    private static final Logger log = Logger.getLogger(JettyHttpServerHelper.class.getCanonicalName());

    public static ServletContextHandler createServletContextHandler(DeploymentInfo deployment, HttpServerIfc server) {
        ServletInfo[] servletInfos;
        String[] vhosts;
        ServletContextHandler context = new ServletContextHandler(0);
        try {
            context.setSecurityHandler((SecurityHandler)context.getDefaultSecurityHandlerClass().newInstance());
        }
        catch (InstantiationException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        AuthProvider authProvider = deployment.getAuthProvider();
        if (authProvider != null) {
            context.getSecurityHandler().setAuthenticator((Authenticator)new BasicAndJWTAuthenticator());
            context.getSecurityHandler().setLoginService((LoginService)new TigasePlainLoginService(authProvider));
        }
        context.setContextPath(deployment.getContextPath());
        if (deployment.getClassLoader() != null) {
            context.setClassLoader(deployment.getClassLoader());
        }
        if ((vhosts = deployment.getVHosts()) != null && vhosts.length > 0) {
            context.setVirtualHosts(vhosts);
        }
        for (ServletInfo info : servletInfos = deployment.getServlets()) {
            for (String mapping : info.getMappings()) {
                ServletHolder holder = new ServletHolder(mapping, info.getServletClass());
                holder.setInitParameters(info.getInitParams());
                context.addServlet(holder, mapping);
            }
        }
        HashMap<String, String> filterParams = new HashMap<String, String>();
        filterParams.put("serverBeanName", server.getName());
        context.addFilter(ProtocolRedirectFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameters(Collections.unmodifiableMap(filterParams));
        return context;
    }
}

