/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.bcstarttls;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import tigase.cert.CertificateEntry;
import tigase.extras.bcstarttls.Credentials;
import tigase.extras.bcstarttls.CredentialsProvider;
import tigase.io.CertificateContainerIfc;

public class SimpleCredentialsProvider
implements CredentialsProvider {
    private static final Logger log = Logger.getLogger(SimpleCredentialsProvider.class.getName());
    private final CertificateContainerIfc certificateContainer;
    private final BcTlsCrypto crypto;
    private final String hostname;
    private Credentials credentials;
    private boolean keysLoaded = false;

    public SimpleCredentialsProvider(BcTlsCrypto crypto, CertificateContainerIfc certificateContainer, String hostname) {
        this.crypto = crypto;
        this.certificateContainer = certificateContainer;
        this.hostname = hostname;
    }

    @Override
    public Credentials getCredentials(TlsServerContext context) {
        this.loadIfRequired(context);
        return this.credentials;
    }

    private Certificate gen12(java.security.cert.Certificate[] certChain) throws CertificateEncodingException, IOException {
        TlsCertificate[] arr = new TlsCertificate[certChain.length];
        for (int i = 0; i < certChain.length; ++i) {
            TlsCertificate cc;
            arr[i] = cc = this.crypto.createCertificate(certChain[i].getEncoded());
        }
        return new Certificate(arr);
    }

    private Certificate gen13(java.security.cert.Certificate[] certChain) throws CertificateEncodingException, IOException {
        org.bouncycastle.tls.CertificateEntry[] arr = new org.bouncycastle.tls.CertificateEntry[certChain.length];
        for (int i = 0; i < certChain.length; ++i) {
            TlsCertificate cc = this.crypto.createCertificate(certChain[i].getEncoded());
            arr[i] = new org.bouncycastle.tls.CertificateEntry(cc, null);
        }
        return new Certificate(0, TlsUtils.EMPTY_BYTES, arr);
    }

    private void loadIfRequired(TlsServerContext context) {
        if (this.keysLoaded) {
            return;
        }
        try {
            CertificateEntry kk = this.certificateContainer.getCertificateEntry(this.hostname);
            AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey((byte[])kk.getPrivateKey().getEncoded());
            Certificate certificate = TlsUtils.isTLSv13((TlsContext)context) ? this.gen13(kk.getCertChain()) : this.gen12(kk.getCertChain());
            this.keysLoaded = true;
            this.credentials = new Credentials(certificate, privateKey);
            log.log(Level.FINE, "Certificate for domain loaded.");
        }
        catch (IOException | CertificateEncodingException e) {
            log.log(Level.WARNING, "Cannot load domain " + this.hostname + " certificate.", e);
            throw new RuntimeException("Cannot load domain " + this.hostname + " certificate.", e);
        }
    }
}

