/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.bcstarttls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerProtocol;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateUtil;
import tigase.extras.bcstarttls.DefaultTls13Server;
import tigase.extras.bcstarttls.SimpleCredentialsProvider;
import tigase.io.CertificateContainerIfc;
import tigase.io.IOInterface;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSEventHandler;
import tigase.io.TLSIOIfc;
import tigase.io.TLSStatus;
import tigase.io.TLSWrapper;
import tigase.stats.StatisticsList;

public class BcTLSIO
implements IOInterface,
TLSIOIfc {
    public static final String TLS_CAPS = "tls-caps";
    private static final Logger log = Logger.getLogger(BcTLSIO.class.getName());
    private final TrustManager[] clientTrustManagers;
    private final boolean needClientAuth;
    private final DefaultTls13Server server;
    private final TlsServerProtocol serverProtocol;
    private final boolean wantClientAuth;
    private int bytesRead = 0;
    private boolean handshakeCompleted = false;
    private IOInterface io = null;
    private Certificate peerCertificate;
    private byte[] tlsExporter;
    private ByteBuffer tlsInput = null;
    private byte[] tlsUnique;
    private final TLSWrapper fakeWrapper = new TLSWrapper(){

        public int bytesConsumed() {
            throw new RuntimeException("Cannot be used!");
        }

        public void close() throws SSLException {
            try {
                BcTLSIO.this.serverProtocol.close();
            }
            catch (IOException e) {
                log.log(Level.FINE, "Cannot close Server Protocol", e);
            }
        }

        public int getAppBuffSize() {
            throw new RuntimeException("Cannot be used!");
        }

        public CertCheckResult getCertificateStatus(boolean revocationEnabled, SSLContextContainerIfc sslContextContainer) {
            java.security.cert.Certificate[] chain;
            try {
                chain = this.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                return CertCheckResult.none;
            }
            if (chain == null || chain.length == 0) {
                return CertCheckResult.none;
            }
            try {
                return CertificateUtil.validateCertificate((java.security.cert.Certificate[])chain, (KeyStore)sslContextContainer.getTrustStore(), (boolean)revocationEnabled);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem validating certificate", ex);
                return CertCheckResult.invalid;
            }
        }

        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            if (BcTLSIO.this.handshakeCompleted) {
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        public java.security.cert.Certificate[] getLocalCertificates() {
            return BcTLSIO.this.gen(BcTLSIO.this.server.getLocalCertificates());
        }

        public int getNetBuffSize() {
            throw new RuntimeException("Cannot be used!");
        }

        public int getPacketBuffSize() {
            throw new RuntimeException("Cannot be used!");
        }

        public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            if (BcTLSIO.this.peerCertificate == null) {
                return null;
            }
            return BcTLSIO.this.gen(BcTLSIO.this.peerCertificate);
        }

        public TLSStatus getStatus() {
            return TLSStatus.OK;
        }

        public byte[] getTlsExporterBindingData() {
            return BcTLSIO.this.tlsExporter;
        }

        public byte[] getTlsUniqueBindingData() {
            return BcTLSIO.this.tlsUnique;
        }

        public boolean isClientMode() {
            return false;
        }

        public boolean isNeedClientAuth() {
            return BcTLSIO.this.needClientAuth;
        }

        public void setDebugId(String id) {
            throw new RuntimeException("Cannot be used!");
        }

        public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
            throw new RuntimeException("Cannot be used!");
        }

        public boolean wantClientAuth() {
            return BcTLSIO.this.wantClientAuth;
        }

        public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
            throw new RuntimeException("Cannot be used!");
        }
    };

    public BcTLSIO(CertificateContainerIfc certificateContainer, TLSEventHandler eventHandler, IOInterface ioi, String hostname, ByteOrder order, boolean wantClientAuth, boolean needClientAuth, TrustManager[] x509TrustManagers) throws IOException {
        this.clientTrustManagers = x509TrustManagers;
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = needClientAuth;
        SecureRandom random = new SecureRandom();
        BcTlsCrypto crypto = new BcTlsCrypto(random);
        this.io = ioi;
        this.tlsInput = ByteBuffer.allocate(2048);
        this.tlsInput.order(order);
        this.serverProtocol = new TlsServerProtocol();
        SimpleCredentialsProvider credentials = new SimpleCredentialsProvider(crypto, certificateContainer, hostname);
        this.server = new DefaultTls13Server(crypto, needClientAuth, wantClientAuth, this.getAcceptedIssuers(), credentials, (clientCertificate, tlsUnique, tlsExporter) -> {
            this.peerCertificate = clientCertificate;
            this.tlsUnique = tlsUnique;
            this.tlsExporter = tlsExporter;
            this.handshakeCompleted = true;
            eventHandler.handshakeCompleted(this.fakeWrapper);
        });
        this.serverProtocol.accept((TlsServer)this.server);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "TLS Socket created: {0}", this.io.toString());
        }
    }

    public int bytesRead() {
        return this.bytesRead;
    }

    public boolean checkCapabilities(String caps) {
        return caps.contains(TLS_CAPS) || this.io.checkCapabilities(caps);
    }

    public long getBuffOverflow(boolean reset) {
        return this.io.getBuffOverflow(reset);
    }

    public long getBytesReceived(boolean reset) {
        return this.io.getBytesReceived(reset);
    }

    public long getBytesSent(boolean reset) {
        return this.io.getBytesSent(reset);
    }

    public int getInputPacketSize() throws IOException {
        return this.io.getInputPacketSize();
    }

    public SocketChannel getSocketChannel() {
        return this.io.getSocketChannel();
    }

    public void getStatistics(StatisticsList list, boolean reset) {
        if (this.io != null) {
            this.io.getStatistics(list, reset);
        }
    }

    public long getTotalBuffOverflow() {
        return this.io.getTotalBuffOverflow();
    }

    public long getTotalBytesReceived() {
        return this.io.getTotalBytesReceived();
    }

    public long getTotalBytesSent() {
        return this.io.getTotalBytesSent();
    }

    public boolean isConnected() {
        return this.io.isConnected();
    }

    public boolean isRemoteAddress(String addr) {
        return this.io.isRemoteAddress(addr);
    }

    public void processHandshake(byte[] data) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Process handshake data: " + data.length + " bytes.");
        }
        this.serverProtocol.offerInput(data);
        this.pumpData();
    }

    public ByteBuffer read(ByteBuffer buff) throws IOException {
        this.pumpData();
        this.bytesRead = this.serverProtocol.readInput(buff.array(), buff.position(), buff.remaining());
        if (this.bytesRead > 0) {
            buff.position(buff.position() + this.bytesRead);
            buff.flip();
        }
        this.pumpData();
        return buff;
    }

    public void setLogId(String logId) {
        this.io.setLogId(logId);
    }

    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called..." + this);
        }
        this.io.stop();
        this.serverProtocol.close();
    }

    public String toString() {
        return "TLS: " + this.io.toString();
    }

    public boolean waitingToSend() {
        return this.io.waitingToSend();
    }

    public int waitingToSendSize() {
        return this.io.waitingToSendSize();
    }

    public int write(ByteBuffer buff) throws IOException {
        int result;
        try {
            this.pumpData();
            if (buff == null) {
                return this.io.write(null);
            }
            this.serverProtocol.writeApplicationData(buff.array(), buff.position(), buff.remaining());
            result = buff.remaining();
            buff.position(buff.position() + result);
            this.serverProtocol.flush();
            this.pumpData();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Cannot write data!", e);
            throw new SSLException(e);
        }
        return result;
    }

    private X509Certificate[] gen(Certificate chain) {
        if (chain == null) {
            return null;
        }
        try {
            X509Certificate[] result = new X509Certificate[chain.getLength()];
            for (int i = 0; i < chain.getLength(); ++i) {
                X509Certificate cert;
                TlsCertificate c = chain.getCertificateAt(i);
                result[i] = cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(c.getEncoded()));
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot create certificate", e);
            return null;
        }
    }

    private Collection<X500Name> getAcceptedIssuers() {
        if (this.clientTrustManagers != null) {
            ArrayList<X500Name> result = new ArrayList<X500Name>();
            for (TrustManager clientTrustManager : this.clientTrustManagers) {
                X509Certificate[] iss;
                if (!(clientTrustManager instanceof X509TrustManager)) continue;
                for (X509Certificate certificate : iss = ((X509TrustManager)clientTrustManager).getAcceptedIssuers()) {
                    X500Name n = new X500Name(certificate.getSubjectX500Principal().toString());
                    result.add(n);
                }
            }
            return result;
        }
        return null;
    }

    private byte[] getBytes(ByteBuffer buff) {
        byte[] tmp;
        if (buff != null) {
            tmp = new byte[buff.remaining()];
            buff.get(tmp);
            buff.compact();
        } else {
            tmp = null;
        }
        return tmp;
    }

    private void pumpData() throws IOException {
        int counter = 0;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Copying data from&to TLS Engine");
        }
        try {
            int resOut;
            int resIn;
            do {
                byte[] tmp;
                ByteBuffer bb;
                int dataLen;
                ++counter;
                resOut = 0;
                int waiting = this.serverProtocol.getAvailableOutputBytes();
                if (waiting > 0 && (dataLen = this.serverProtocol.readOutput((bb = ByteBuffer.allocate(waiting)).array(), 0, bb.array().length)) > 0) {
                    bb.position(resOut += dataLen);
                    bb.flip();
                    this.io.write(bb);
                }
                resIn = 0;
                bb = this.io.read(this.tlsInput);
                if (this.io.bytesRead() <= 0 || (tmp = this.getBytes(bb)) == null || tmp.length <= 0) continue;
                resIn += tmp.length;
                this.serverProtocol.offerInput(tmp);
            } while ((resIn > 0 || resOut > 0) && counter <= 1000);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error on reading/writing data.", e);
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Error on reading/writing data.", e);
            throw new IOException("Data copying exception", e);
        }
    }
}

