/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.RepositoryException;
import tigase.db.util.importexport.AbstractImporterExtension;
import tigase.db.util.importexport.Exporter;
import tigase.db.util.importexport.ImporterExtension;
import tigase.db.util.importexport.RepositoryManager;
import tigase.db.util.importexport.RepositoryManagerExtensionBase;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Message;
import tigase.util.ui.console.CommandlineParameter;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.ExtendedQuery;
import tigase.xmpp.mam.MAMItemHandler;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.util.MAMRepositoryManagerExtensionHelper;

public class PubSubRepositoryManagerExtension
extends RepositoryManagerExtensionBase {
    private static final Logger log = Logger.getLogger(PubSubRepositoryManagerExtension.class.getSimpleName());
    private final CommandlineParameter INCLUDE_PUBSUB = new CommandlineParameter.Builder(null, "include-pubsub").type(Boolean.class).description("Include PubSub component data").defaultValue("false").requireArguments(false).build();
    private final CommandlineParameter EXCLUDE_PEP = new CommandlineParameter.Builder(null, "exclude-pep").type(Boolean.class).description("Exclude user PEP data").defaultValue("false").requireArguments(false).build();

    public Stream<CommandlineParameter> getImportParameters() {
        return Stream.concat(super.getImportParameters(), Stream.of(this.INCLUDE_PUBSUB));
    }

    public Stream<CommandlineParameter> getExportParameters() {
        return Stream.concat(super.getExportParameters(), Stream.of(this.INCLUDE_PUBSUB, this.EXCLUDE_PEP, Exporter.EXPORT_MAM_SINCE, Exporter.EXPORT_MAM_BATCH_SIZE));
    }

    public void exportDomainData(String domain, Writer writer) throws Exception {
        if (!RepositoryManager.isSet((CommandlineParameter)this.INCLUDE_PUBSUB)) {
            return;
        }
        List names = this.getNamesOfComponent(PubSubComponent.class);
        log.finest("for domain " + domain + " found following PubSub components: " + names);
        for (String name : names) {
            BareJID serviceJID = BareJID.bareJIDInstance((String)(name + "." + domain));
            PubSubDAO pubSubDAO = (PubSubDAO)this.getRepository(PubSubDAO.class, serviceJID.getDomain());
            if (pubSubDAO.getNodesCount(serviceJID) <= 0L) continue;
            log.info("exporting PubSub data for component domain " + name + "." + domain + "..");
            this.exportInclude(writer, this.getRootPath().resolve(name + "." + domain + ".xml"), pubsubWriter -> {
                pubsubWriter.append("<pubsub xmlns=\"tigase:xep-0227:pubsub:0\" name=\"").append(name).append("\">\n");
                this.exportData(serviceJID, false, (Writer)pubsubWriter);
                pubsubWriter.append("\n</pubsub>");
            });
        }
    }

    public void exportUserData(Path userDirPath, BareJID serviceJid, Writer writer) throws Exception {
        if (!RepositoryManager.isSet((CommandlineParameter)this.EXCLUDE_PEP)) {
            this.exportInclude(writer, userDirPath.resolve("pep.xml"), pepWriter -> this.exportData(serviceJid, true, (Writer)pepWriter));
        }
    }

    public void exportData(BareJID serviceJid, boolean isPEP, Writer writer) throws Exception {
        INodeMeta nodeMeta;
        PubSubDAO pubSubDAO = (PubSubDAO)this.getRepository(PubSubDAO.class, serviceJid.getDomain());
        String[] nodeNames = pubSubDAO.getChildNodes(serviceJid, null);
        log.finest("for JID " + serviceJid + " found PEP nodes: " + Arrays.asList(nodeNames));
        writer.write("<pubsub xmlns='http://jabber.org/protocol/pubsub#owner'>");
        for (String nodeName : nodeNames) {
            nodeMeta = pubSubDAO.getNodeMeta(serviceJid, nodeName);
            if (nodeMeta != null) {
                Map<BareJID, UsersSubscription> subs;
                writer.append("<configure node=\"").append(XMLUtils.escape((String)nodeName)).append("\"");
                if (!isPEP) {
                    writer.append(" xmlns:tigase=\"tigase:xep-0227:pubsub:0\"").append(" tigase:createdBy=\"").append(XMLUtils.escape((String)nodeMeta.getCreator().toString())).append("\"");
                }
                writer.append(">");
                writer.write(nodeMeta.getNodeConfig().getFormElement().toString());
                writer.write("</configure>");
                Map<BareJID, UsersAffiliation> affs = pubSubDAO.getNodeAffiliations(serviceJid, nodeMeta.getNodeId());
                if (affs != null && !affs.isEmpty()) {
                    writer.append("<affiliations node=\"").append(XMLUtils.escape((String)nodeName)).append("\">");
                    for (UsersAffiliation aff : affs.values()) {
                        writer.append("<affiliation jid=\"").append(XMLUtils.escape((String)aff.getJid().toString())).append("\" affiliation=\"").append(aff.getAffiliation().name()).append("\"/>");
                    }
                    writer.write("</affiliations>");
                }
                if ((subs = pubSubDAO.getNodeSubscriptions(serviceJid, nodeMeta.getNodeId())) == null || subs.isEmpty()) continue;
                writer.append("<subscriptions node=\"").append(XMLUtils.escape((String)nodeName)).append("\">");
                for (UsersSubscription sub : subs.values()) {
                    writer.append("<subscription jid=\"").append(XMLUtils.escape((String)sub.getJid().toString())).append("\" subscription=\"").append(sub.getSubscription().name()).append("\"");
                    if (sub.getSubid() != null) {
                        writer.append(" subid=\"").append(sub.getSubid()).append("\"");
                    }
                    writer.append("/>");
                }
                writer.write("</subscriptions>");
                continue;
            }
            throw new RuntimeException("Couldn't load metadata info for JID = " + serviceJid + ", node = " + nodeName);
        }
        writer.write("</pubsub>");
        writer.write("<pubsub xmlns='http://jabber.org/protocol/pubsub'>");
        for (String nodeName : nodeNames) {
            nodeMeta = pubSubDAO.getNodeMeta(serviceJid, nodeName);
            if (nodeMeta == null) continue;
            writer.append("<items node=\"").append(XMLUtils.escape((String)nodeName)).append("\">");
            String[] itemIds = pubSubDAO.getItemsIds(serviceJid, nodeMeta.getNodeId(), CollectionItemsOrdering.byUpdateDate);
            if (itemIds != null && itemIds.length > 0) {
                for (String itemId : itemIds) {
                    IItems.IItem item = pubSubDAO.getItem(serviceJid, nodeMeta.getNodeId(), itemId);
                    if (item == null || item.getItem() == null) continue;
                    Element itemEl = item.getItem().clone();
                    if (item.getUUID() != null || !isPEP) {
                        itemEl.addAttribute("xmlns:tigase", "tigase:xep-0227:pubsub:0");
                        if (item.getUUID() != null) {
                            itemEl.addAttribute("tigase:stableId", item.getUUID().toString());
                        }
                    }
                    writer.write(itemEl.toString());
                }
            }
            writer.write("</items>");
            PubSubRepositoryManagerExtension.exportMAMDataFromRepository(pubSubDAO, serviceJid, nodeName, nodeMeta, serviceJid, writer);
        }
        writer.write("</pubsub>");
    }

    public static void exportMAMDataFromRepository(IPubSubDAO mamRepository, BareJID repoJID, String nodeName, INodeMeta nodeMeta, BareJID askingJID, final Writer writer) throws Exception {
        writer.append("<archive xmlns='urn:xmpp:pie:0#mam' node=\"").append(XMLUtils.escape((String)nodeName)).append("\">");
        Object query = mamRepository.newQuery(repoJID);
        query.setComponentJID(JID.jidInstance((BareJID)repoJID));
        query.setQuestionerJID(JID.jidInstance((BareJID)askingJID));
        query.setPubsubNode(nodeName);
        query.setXMLNS("urn:xmpp:mam:2");
        Exporter.getExportMAMSinceValue().ifPresent(arg_0 -> query.setStart(arg_0));
        query.getRsm().setMax(Exporter.getExportMAMBatchSize().intValue());
        final AtomicReference lastItem = new AtomicReference();
        int batchNo = 0;
        Integer itemsToExport = null;
        while (true) {
            mamRepository.queryItems(query, nodeMeta.getNodeId(), new MAMItemHandler(){

                public void itemFound(Query query, MAMRepository.Item item) {
                    lastItem.set(item);
                    Element result = this.prepareResult(query, item);
                    if (result != null) {
                        try {
                            writer.append(result.toString());
                        }
                        catch (Throwable ex) {
                            log.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
            });
            if (lastItem.get() == null) break;
            if (itemsToExport == null) {
                itemsToExport = query.getRsm().getCount();
            }
            if (itemsToExport != null) {
                int completed = Math.min(++batchNo * Exporter.getExportMAMBatchSize(), itemsToExport);
                int percent = completed * 100 / itemsToExport;
                if (batchNo > 1 || percent < 100) {
                    log.info("MAM archive of node " + nodeName + ", exported batch no. " + batchNo + ", " + percent + "%...");
                }
            }
            if (query instanceof ExtendedQuery) {
                ExtendedQuery extendedQuery = (ExtendedQuery)query;
                extendedQuery.setAfterId(((MAMRepository.Item)lastItem.get()).getId());
            } else {
                query.getRsm().setAfter(((MAMRepository.Item)lastItem.get()).getId());
            }
            lastItem.set(null);
        }
        writer.append("</archive>");
    }

    public ImporterExtension startImportDomainData(String domain, String name, Map<String, String> attrs) throws Exception {
        if (!"pubsub".equals(name)) {
            return null;
        }
        if (!"tigase:xep-0227:pubsub:0".equals(attrs.get("xmlns"))) {
            return null;
        }
        String prefix = attrs.get("name");
        String componentDomain = prefix != null ? prefix + "." + domain : domain;
        return new PubSubComponentImporterExtension((PubSubDAO)this.getRepository(PubSubDAO.class, componentDomain), componentDomain, RepositoryManager.isSet((CommandlineParameter)this.INCLUDE_PUBSUB));
    }

    public ImporterExtension startImportUserData(BareJID userJid, String name, Map<String, String> attrs) throws Exception {
        if (!"pubsub".equals(name)) {
            return null;
        }
        return switch (attrs.get("xmlns")) {
            case "http://jabber.org/protocol/pubsub#owner" -> new PubSubOwnerImporterExtension((PubSubDAO)this.getRepository(PubSubDAO.class, userJid.getDomain()), userJid, true);
            case "http://jabber.org/protocol/pubsub" -> new PubSubDataImporterExtension((PubSubDAO)this.getRepository(PubSubDAO.class, userJid.getDomain()), userJid, true);
            default -> null;
        };
    }

    public static class PubSubComponentImporterExtension
    extends AbstractImporterExtension {
        private final PubSubDAO pubSubDAO;
        private ImporterExtension activeExtension = null;
        private final String domain;
        private final boolean includePubSub;
        private int depth = 0;

        public PubSubComponentImporterExtension(PubSubDAO pubSubDAO, String domain, boolean includePubSub) {
            this.domain = domain;
            this.pubSubDAO = pubSubDAO;
            this.includePubSub = includePubSub;
            if (includePubSub) {
                log.info("importing PubSub data for component domain " + domain + "...");
            }
        }

        public boolean startElement(String name, Map<String, String> attrs) throws Exception {
            if (!this.includePubSub) {
                ++this.depth;
                return true;
            }
            if (this.activeExtension != null && this.activeExtension.startElement(name, attrs)) {
                return true;
            }
            if (!"pubsub".equals(name)) {
                return false;
            }
            this.activeExtension = switch (attrs.get("xmlns")) {
                case "http://jabber.org/protocol/pubsub#owner" -> new PubSubOwnerImporterExtension(this.pubSubDAO, BareJID.bareJIDInstanceNS((String)this.domain), false);
                case "http://jabber.org/protocol/pubsub" -> new PubSubDataImporterExtension(this.pubSubDAO, BareJID.bareJIDInstanceNS((String)this.domain), false);
                default -> null;
            };
            return this.activeExtension != null;
        }

        public boolean handleElement(Element element) throws Exception {
            return this.activeExtension != null && this.activeExtension.handleElement(element);
        }

        public boolean endElement(String name) throws Exception {
            if (!this.includePubSub) {
                boolean inside = this.depth > 0;
                --this.depth;
                return inside;
            }
            if (this.activeExtension != null) {
                if (this.activeExtension.endElement(name)) {
                    return true;
                }
                if ("pubsub".equals(name)) {
                    this.activeExtension.close();
                    this.activeExtension = null;
                    return true;
                }
            }
            return false;
        }
    }

    public static class PubSubOwnerImporterExtension
    extends AbstractImporterExtension {
        private final PubSubDAO pubSubDAO;
        private final BareJID serviceJID;
        private final boolean isPEP;
        private State state = State.root;
        private String nodeName;
        private INodeMeta nodeMeta;

        public PubSubOwnerImporterExtension(PubSubDAO pubSubDAO, BareJID serviceJID, boolean isPEP) {
            this.pubSubDAO = pubSubDAO;
            this.serviceJID = serviceJID;
            this.isPEP = isPEP;
        }

        public boolean startElement(String name, Map<String, String> attrs) throws Exception {
            return switch (this.state) {
                case State.root -> {
                    switch (name) {
                        case "affiliations": {
                            this.nodeName = Optional.ofNullable(attrs.get("node")).orElseThrow();
                            this.nodeMeta = this.pubSubDAO.getNodeMeta(this.serviceJID, this.nodeName);
                            this.state = State.affiliations;
                            yield true;
                        }
                        case "subscriptions": {
                            this.nodeName = Optional.ofNullable(attrs.get("node")).orElseThrow();
                            this.nodeMeta = this.pubSubDAO.getNodeMeta(this.serviceJID, this.nodeName);
                            this.state = State.subscriptions;
                            yield true;
                        }
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean handleElement(Element element) throws Exception {
            return switch (this.state) {
                case State.root -> {
                    switch (element.getName()) {
                        case "configure": {
                            String nodeName = XMLUtils.unescape((String)element.getAttributeStaticStr("node"));
                            Element config = element.getChild("x", "jabber:x:data");
                            INodeMeta nodeMeta = this.pubSubDAO.getNodeMeta(this.serviceJID, nodeName);
                            if (nodeMeta != null) {
                                this.pubSubDAO.updateNodeConfig(this.serviceJID, nodeMeta.getNodeId(), config.toString(), null);
                            } else {
                                BareJID creatorJID = this.isPEP ? this.serviceJID : Optional.ofNullable(element.getAttributeStaticStr("tigase:createdBy")).map(XMLUtils::unescape).map(BareJID::bareJIDInstanceNS).orElse(this.serviceJID);
                                LeafNodeConfig leafNodeConfig = new LeafNodeConfig(nodeName);
                                leafNodeConfig.getForm().copyValuesFrom(config);
                                this.pubSubDAO.createNode(this.serviceJID, nodeName, creatorJID, leafNodeConfig, NodeType.leaf, null, true);
                            }
                            yield true;
                        }
                    }
                    yield false;
                }
                case State.affiliations -> {
                    switch (element.getName()) {
                        case "affiliation": {
                            BareJID jid = Optional.ofNullable(element.getAttributeStaticStr("jid")).map(BareJID::bareJIDInstanceNS).orElseThrow();
                            Affiliation affiliation = Optional.ofNullable(element.getAttributeStaticStr("affiliation")).map(Affiliation::valueOf).orElse(Affiliation.none);
                            if (affiliation != Affiliation.none) {
                                this.pubSubDAO.updateNodeAffiliation(this.serviceJID, this.nodeMeta.getNodeId(), this.nodeName, new UsersAffiliation(jid, affiliation));
                            }
                            yield true;
                        }
                    }
                    yield false;
                }
                case State.subscriptions -> {
                    switch (element.getName()) {
                        case "subscription": {
                            BareJID jid = Optional.ofNullable(element.getAttributeStaticStr("jid")).map(BareJID::bareJIDInstanceNS).orElseThrow();
                            String subid = element.getAttributeStaticStr("subid");
                            Subscription subscriptionType = Optional.ofNullable(element.getAttributeStaticStr("subscription")).map(Subscription::valueOf).orElse(Subscription.none);
                            if (subscriptionType != Subscription.none) {
                                UsersSubscription subscription = new UsersSubscription(jid, subid, subscriptionType);
                                this.pubSubDAO.updateNodeSubscription(this.serviceJID, this.nodeMeta.getNodeId(), this.nodeName, subscription);
                            }
                            yield true;
                        }
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean endElement(String name) throws Exception {
            return switch (this.state) {
                case State.affiliations -> {
                    if ("affiliations".equals(name)) {
                        this.nodeMeta = null;
                        this.nodeName = null;
                        this.state = State.root;
                        yield true;
                    }
                    yield false;
                }
                case State.subscriptions -> {
                    if ("subscriptions".equals(name)) {
                        this.nodeMeta = null;
                        this.nodeName = null;
                        this.state = State.root;
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        static enum State {
            root,
            affiliations,
            subscriptions;

        }
    }

    public static class PubSubDataImporterExtension
    extends AbstractImporterExtension {
        private final boolean isPEP;
        private final PubSubDAO pubSubDAO;
        private final BareJID serviceJID;
        private String nodeName;
        private INodeMeta nodeMeta;
        private State state = State.root;
        private ImporterExtension activeExtension;
        private Class<? extends PubSubMAMImporterExtension> mamImporterExtension;

        public PubSubDataImporterExtension(PubSubDAO pubSubDAO, BareJID serviceJID, boolean isPEP) {
            this(pubSubDAO, serviceJID, isPEP, PubSubMAMImporterExtension.class);
        }

        public PubSubDataImporterExtension(PubSubDAO pubSubDAO, BareJID serviceJID, boolean isPEP, Class<? extends PubSubMAMImporterExtension> mamImporterExtension) {
            this.pubSubDAO = pubSubDAO;
            this.serviceJID = serviceJID;
            this.isPEP = isPEP;
            this.mamImporterExtension = mamImporterExtension;
        }

        public boolean startElement(String name, Map<String, String> attrs) throws Exception {
            return switch (this.state) {
                case State.root -> {
                    switch (name) {
                        case "items": {
                            this.nodeName = attrs.get("node");
                            this.nodeMeta = this.pubSubDAO.getNodeMeta(this.serviceJID, this.nodeName);
                            this.state = State.items;
                            yield true;
                        }
                        case "archive": {
                            if ("urn:xmpp:pie:0#mam".equals(attrs.get("xmlns"))) {
                                this.state = State.archive;
                                this.nodeName = attrs.get("node");
                                this.activeExtension = (ImporterExtension)this.mamImporterExtension.getConstructor(PubSubDAO.class, BareJID.class, String.class).newInstance(this.pubSubDAO, this.serviceJID, this.nodeName);
                                log.finest("starting " + this.activeExtension.getClass().getSimpleName() + "...");
                                yield true;
                            }
                            yield false;
                        }
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean handleElement(Element element) throws Exception {
            if (this.activeExtension != null && this.activeExtension.handleElement(element)) {
                return true;
            }
            return switch (this.state) {
                case State.items -> {
                    if ("item".equals(element.getName())) {
                        String id = element.getAttributeStaticStr("id");
                        String publisher = this.isPEP ? this.serviceJID.toString() : this.serviceJID.toString();
                        String stableId = element.getAttributeStaticStr("tigase:stableId");
                        List<String> attrsToRemove = element.getAttributes().keySet().stream().filter(key -> key.contains("tigase")).toList();
                        for (String key : attrsToRemove) {
                            element.removeAttribute(key);
                        }
                        log.finest("inserting for " + this.serviceJID + " node = " + this.nodeName + ", item " + id);
                        this.pubSubDAO.writeItem(this.serviceJID, this.nodeMeta.getNodeId(), System.currentTimeMillis(), id, publisher, element, stableId);
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean endElement(String name) throws Exception {
            return switch (this.state) {
                case State.items -> {
                    switch (name) {
                        case "items": {
                            this.nodeName = null;
                            this.nodeMeta = null;
                            this.state = State.root;
                            yield true;
                        }
                    }
                    yield false;
                }
                case State.archive -> {
                    switch (name) {
                        case "archive": {
                            this.nodeName = null;
                            this.activeExtension.close();
                            this.activeExtension = null;
                            this.state = State.root;
                            yield true;
                        }
                    }
                    yield false;
                }
                default -> false;
            };
        }

        static enum State {
            root,
            items,
            archive;

        }
    }

    public static class PubSubMAMImporterExtension
    extends MAMRepositoryManagerExtensionHelper.AbstractImporterExtension {
        protected final INodeMeta nodeMeta;
        protected final String nodeName;
        protected final PubSubDAO pubSubDAO;
        protected final BareJID serviceJID;

        public PubSubMAMImporterExtension(PubSubDAO pubSubDAO, BareJID serviceJID, String nodeName) throws RepositoryException {
            this.pubSubDAO = pubSubDAO;
            this.serviceJID = serviceJID;
            this.nodeName = nodeName;
            this.nodeMeta = pubSubDAO.getNodeMeta(serviceJID, nodeName);
        }

        protected boolean handleMessage(Message message, String stableId, Date timestamp, Element source) throws Exception {
            String itemId;
            Element event = message.getElemChild("event", "http://jabber.org/protocol/pubsub#event");
            if (event == null) {
                return false;
            }
            Element items = event.getChild("items");
            if (items == null) {
                return false;
            }
            Element item = items.getChild("item");
            if (item == null) {
                item = items.getChild("retract");
            }
            String string = itemId = item == null ? null : item.getAttributeStaticStr("id");
            if (itemId == null) {
                return false;
            }
            if (this.pubSubDAO.getItem(this.serviceJID, this.nodeMeta.getNodeId(), itemId) == null) {
                this.pubSubDAO.addMAMItem(this.serviceJID, this.nodeMeta.getNodeId(), stableId, message.getElement(), timestamp, itemId);
            } else {
                log.finest("MAM entry for item with id = " + itemId + ", already existed..");
            }
            return true;
        }
    }
}

