/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.derby;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Logger;
import tigase.util.Algorithms;

public class StoredProcedures {
    private static final Logger log = Logger.getLogger(tigase.db.derby.StoredProcedures.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF-8");

    protected static Long getIdOfJid(Connection conn, String jid) throws SQLException {
        if (jid == null) {
            return null;
        }
        String jidSha = StoredProcedures.sha1OfLower(jid);
        Statement st = conn.createStatement();
        try (ResultSet rs = st.executeQuery("select jid_id from tig_pubsub_jids where jid_sha1 = '" + jidSha + "'");){
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
        }
        return null;
    }

    protected static String sha1OfLower(String data) throws SQLException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(data.toLowerCase().getBytes(UTF8));
            return Algorithms.bytesToHex((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(e);
        }
    }

    public static void tigPubSubCreateNode(String serviceJid, String nodeName, Integer nodeType, String nodeCreator, String nodeConf, Long collectionId, Timestamp ts, String domain, Integer autocreateService, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            long serviceJidId = StoredProcedures.tigPubSubEnsureServiceJid(serviceJid, domain, autocreateService);
            long nodeCreatorId = StoredProcedures.tigPubSubEnsureJid(nodeCreator);
            PreparedStatement ps = conn.prepareStatement("insert into tig_pubsub_nodes (service_id,name,type,creator_id,creation_date,configuration,collection_id) values (?, ?, ?, ?, ?, ?, ?)", 1);
            ps.setLong(1, serviceJidId);
            ps.setString(2, nodeName);
            ps.setInt(3, nodeType);
            ps.setLong(4, nodeCreatorId);
            ps.setTimestamp(5, ts);
            ps.setString(6, nodeConf);
            if (collectionId == null) {
                ps.setNull(7, -5);
            } else {
                ps.setLong(7, collectionId);
            }
            ps.executeUpdate();
            data[0] = ps.getGeneratedKeys();
        }
    }

    public static void tigPubSubDeleteAllNodes(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String serviceJidSha1 = StoredProcedures.sha1OfLower(serviceJid);
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_items where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_nodes where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubDeleteItem(Long nodeId, String itemId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_items where node_id = ? and id = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, itemId);
            ps.executeUpdate();
            ps = conn.prepareStatement("update tig_pubsub_mam set data = null where node_id = ? and item_id = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, itemId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubDeleteNodeSubscription(Long nodeId, String jid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id = ? and jid_id = (select jid_id from tig_pubsub_jids where jid_sha1 = ?)");
            ps.setLong(1, nodeId);
            ps.setString(2, StoredProcedures.sha1OfLower(jid));
            ps.executeUpdate();
        }
    }

    public static Long tigPubSubEnsureJid(String jid) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Long l = StoredProcedures.tigPubSubEnsureJid(conn, jid);
            return l;
        }
    }

    public static Long tigPubSubEnsureJid(Connection conn, String jid) throws SQLException {
        String jidSha1 = StoredProcedures.sha1OfLower(jid);
        PreparedStatement ps = conn.prepareStatement("select jid_id from tig_pubsub_jids where jid_sha1 = ?");
        ps.setString(1, jidSha1);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getLong(1);
        }
        ps = conn.prepareStatement("insert into tig_pubsub_jids (jid, jid_sha1) values (?, ?)", 1);
        ps.setString(1, jid);
        ps.setString(2, jidSha1);
        ps.executeUpdate();
        rs = ps.getGeneratedKeys();
        if (rs.next()) {
            return rs.getLong(1);
        }
        return null;
    }

    public static Long tigPubSubEnsureServiceJid(String serviceJid, String domain, Integer autocreateService) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String serviceJidSha1 = StoredProcedures.sha1OfLower(serviceJid);
            PreparedStatement ps = conn.prepareStatement("select service_id from tig_pubsub_service_jids where service_jid_sha1 = ?");
            ps.setString(1, serviceJidSha1);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            if (autocreateService > 0) {
                ps = conn.prepareStatement("insert into tig_pubsub_service_jids (service_jid, service_jid_sha1, domain) values (?, ?, ?)", 1);
                ps.setString(1, serviceJid);
                ps.setString(2, serviceJidSha1);
                ps.setString(3, domain);
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            Long l = null;
            return l;
        }
    }

    public static void tigPubSubFixItem(Long nodeId, String itemId, Timestamp creationDate, Timestamp updateDate) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_pubsub_items set creation_date = ?, update_date = ? where node_id = ? and id = ?");
            if (creationDate == null) {
                ps.setNull(1, 93);
            } else {
                ps.setTimestamp(1, creationDate);
            }
            if (updateDate == null) {
                ps.setNull(2, 93);
            } else {
                ps.setTimestamp(2, updateDate);
            }
            ps.setLong(3, nodeId);
            ps.setString(4, itemId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubFixNode(Long nodeId, Timestamp creationDate) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_pubsub_nodes set creation_date = ? where node_id = ?");
            if (creationDate == null) {
                ps.setNull(1, 93);
            } else {
                ps.setTimestamp(1, creationDate);
            }
            ps.setLong(2, nodeId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubGetAllNodes(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(serviceJid));
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetChildNodes(String serviceJid, String collection, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id inner join tig_pubsub_nodes p on p.node_id = n.collection_id and p.service_id = sj.service_id where sj.service_jid_sha1 = ? and p.name = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(serviceJid));
            ps.setString(2, collection);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetItem(Long nodeId, String itemId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select pi.data, pn.name, pi.uuid from tig_pubsub_items pi inner join tig_pubsub_nodes pn on pn.node_id = pi.node_id where pi.node_id = ? and pi.id = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, itemId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeAffiliations(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select pj.jid, pa.affiliation from tig_pubsub_affiliations pa inner join tig_pubsub_jids pj on pa.jid_id = pj.jid_id where pa.node_id = ?");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeConfiguration(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select configuration from tig_pubsub_nodes where node_id = ?");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeId(String serviceJid, String nodeName, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ? and n.name = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(serviceJid));
            ps.setString(2, nodeName);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeItemIds(Long nodeId, Integer order, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement(order == 1 ? "select id from tig_pubsub_items where node_id = ? order by creation_date" : "select id from tig_pubsub_items where node_id = ? order by update_date");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeItemIdsSince(Long nodeId, Integer order, Timestamp since, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement(order == 1 ? "select id from tig_pubsub_items where node_id = ? and creation_date >= ? order by creation_date" : "select id from tig_pubsub_items where node_id = ? and update_date >= ? order by update_date");
            ps.setLong(1, nodeId);
            ps.setTimestamp(2, since);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeItemsMeta(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select id, creation_date, update_date, uuid from tig_pubsub_items where node_id = ? order by creation_date");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeMeta(String serviceJid, String nodeName, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.node_id, n.configuration, cj.jid, n.creation_date from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id inner join tig_pubsub_jids cj on cj.jid_id = n.creator_id where sj.service_jid_sha1 = ? and n.name = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(serviceJid));
            ps.setString(2, nodeName);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeSubscriptions(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select pj.jid, ps.subscription, ps.subscription_id from tig_pubsub_subscriptions ps inner join tig_pubsub_jids pj on ps.jid_id = pj.jid_id where ps.node_id = ?");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetRootNodes(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ? and collection_id is null");
            ps.setString(1, StoredProcedures.sha1OfLower(serviceJid));
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetUserAffiliations(String serviceJid, String jid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, pa.affiliation from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on sj.service_id = n.service_id inner join tig_pubsub_affiliations pa on pa.node_id = n.node_id inner join tig_pubsub_jids pj on pj.jid_id = pa.jid_id where pj.jid_sha1 = ? and sj.service_jid_sha1 = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(jid));
            ps.setString(2, StoredProcedures.sha1OfLower(serviceJid));
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetUserSubscriptions(String serviceJid, String jid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, ps.subscription, ps.subscription_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on sj.service_id = n.service_id inner join tig_pubsub_subscriptions ps on ps.node_id = n.node_id inner join tig_pubsub_jids pj on pj.jid_id = ps.jid_id where pj.jid_sha1 = ? and sj.service_jid_sha1 = ?");
            ps.setString(1, StoredProcedures.sha1OfLower(jid));
            ps.setString(2, StoredProcedures.sha1OfLower(serviceJid));
            data[0] = ps.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubMamAddItem(Long nodeId, String uuid, Timestamp ts, String itemData, String itemId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Class<StoredProcedures> clazz = StoredProcedures.class;
            synchronized (StoredProcedures.class) {
                PreparedStatement ps = conn.prepareStatement("insert into tig_pubsub_mam (node_id, uuid, ts, data, item_id) VALUES (?,?,?,?,?)");
                ps.setLong(1, nodeId);
                ps.setString(2, uuid);
                ps.setTimestamp(3, ts);
                ps.setString(4, itemData);
                ps.setString(5, itemId);
                ps.executeUpdate();
                // ** MonitorExit[var7_7] (shouldn't be in output)
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubMamUpdateItem(Long nodeId, String uuid, String itemData, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Class<StoredProcedures> clazz = StoredProcedures.class;
            synchronized (StoredProcedures.class) {
                PreparedStatement ps = conn.prepareStatement("update tig_pubsub_mam set data = ? where node_id = ? and uuid = ?");
                ps.setString(1, itemData);
                ps.setLong(2, nodeId);
                ps.setString(3, uuid);
                ps.executeUpdate();
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubMamQueryItemPosition(Long nodeId, Timestamp since, Timestamp to, String uuid, ResultSet[] data) throws SQLException {
        String query = "select pm.uuid, row_number() over () as position from tig_pubsub_mam pm where pm.node_id = ?  and (? is null or pm.ts >= ?) and (? is null or pm.ts <= ?) order by pm.ts";
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement st = conn.prepareStatement(query);
            st.setLong(1, nodeId);
            st.setTimestamp(2, since);
            st.setTimestamp(3, since);
            st.setTimestamp(4, to);
            st.setTimestamp(5, to);
            int i = 0;
            try (ResultSet rs = st.executeQuery();){
                while (rs.next()) {
                    if (!uuid.equalsIgnoreCase(rs.getString(1))) continue;
                    i = rs.getInt(2);
                }
            }
            String q = "select " + i + " as position from SYSIBM.SYSDUMMY1 where " + i + " <> 0";
            data[0] = conn.prepareStatement(q).executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubMamQueryItem(Long nodeId, String stableId, ResultSet[] data) throws SQLException {
        String query = "select pm.uuid, pm.ts, pm.data from tig_pubsub_mam pm where pm.node_id = ? and pm.uuid = ?";
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement st = conn.prepareStatement(query);
            st.setLong(1, nodeId);
            st.setString(2, stableId);
            data[0] = st.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubMamQueryItems(Long nodeId, Timestamp since, Timestamp to, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        String query = "select pm.uuid, pm.ts, pm.data from tig_pubsub_mam pm where pm.node_id = ? and (? is null or pm.ts >= ?) and (? is null or pm.ts <= ?) order by pm.ts offset ? rows fetch next ? rows only";
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement st = conn.prepareStatement(query);
            st.setLong(1, nodeId);
            st.setTimestamp(2, since);
            st.setTimestamp(3, since);
            st.setTimestamp(4, to);
            st.setTimestamp(5, to);
            st.setInt(6, offset);
            st.setInt(7, limit);
            data[0] = st.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubMamQueryItemsCount(Long nodeId, Timestamp since, Timestamp to, ResultSet[] data) throws SQLException {
        String query = "select count(1) from tig_pubsub_mam pm where pm.node_id = ? and (? is null or pm.ts >= ?) and (? is null or pm.ts <= ?)";
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement st = conn.prepareStatement(query);
            st.setLong(1, nodeId);
            st.setTimestamp(2, since);
            st.setTimestamp(3, since);
            st.setTimestamp(4, to);
            st.setTimestamp(5, to);
            data[0] = st.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubQueryItemPosition(String nodesIds, Timestamp since, Timestamp to, Integer order, Long nodeId, String itemId, ResultSet[] data) throws SQLException {
        String ts = order == 1 ? "update_date" : "creation_date";
        String query = "select pi.node_id, pi.id, row_number() over () as position from tig_pubsub_items pi where pi.node_id in (" + nodesIds + ") and (? is null or pi." + ts + " >= ?) and (? is null or pi." + ts + " <= ?) order by pi." + ts;
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement st = conn.prepareStatement(query);
            st.setTimestamp(1, since);
            st.setTimestamp(2, since);
            st.setTimestamp(3, to);
            st.setTimestamp(4, to);
            int i = 0;
            try (ResultSet rs = st.executeQuery();){
                while (rs.next()) {
                    if (rs.getLong(1) != nodeId.longValue() || !itemId.equals(rs.getString(2))) continue;
                    i = rs.getInt(3);
                }
            }
            String q = "select " + i + " as position from SYSIBM.SYSDUMMY1 where " + i + " <> 0";
            data[0] = conn.prepareStatement(q).executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubQueryItems(String nodesIds, Timestamp since, Timestamp to, Integer order, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        String ts = order == 1 ? "update_date" : "creation_date";
        String query = "select pn.name, pi.node_id, pi.id, pi.uuid, pi.data from tig_pubsub_items pi inner join tig_pubsub_nodes pn on pi.node_id = pn.node_id where pi.node_id in (" + nodesIds + ") and (? is null or pi." + ts + " >= ?) and (? is null or pi." + ts + " <= ?) order by pi." + ts + " offset ? rows fetch next ? rows only";
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement st = conn.prepareStatement(query);
            st.setTimestamp(1, since);
            st.setTimestamp(2, since);
            st.setTimestamp(3, to);
            st.setTimestamp(4, to);
            st.setInt(5, offset);
            st.setInt(6, limit);
            data[0] = st.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubQueryItemsCount(String nodesIds, Timestamp since, Timestamp to, Integer order, ResultSet[] data) throws SQLException {
        String ts = order == 1 ? "update_date" : "creation_date";
        String query = "select count(1) from tig_pubsub_items pi where pi.node_id in (" + nodesIds + ") and (? is null or pi." + ts + " >= ?) and (? is null or pi." + ts + " <= ?)";
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement st = conn.prepareStatement(query);
            st.setTimestamp(1, since);
            st.setTimestamp(2, since);
            st.setTimestamp(3, to);
            st.setTimestamp(4, to);
            data[0] = st.executeQuery();
        }
    }

    public static void tigPubSubRemoveNode(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_mam where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_items where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_nodes where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubRemoveService(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String serviceJidSha1 = StoredProcedures.sha1OfLower(serviceJid);
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_items where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_nodes where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_service_jids where service_jid_sha1 = ?");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where jid_id in (select j.jid_id from tig_pubsub_jids j where j.jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where jid_id in (select j.jid_id from tig_pubsub_jids j where j.jid_sha1 = ?)");
            ps.setString(1, serviceJidSha1);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubSetNodeAffiliation(Long nodeId, String jid, String affil, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_pubsub_affiliations pa inner join tig_pubsub_jids pj on pa.jid_id = pj.jid_id where pa.node_id = ? and pj.jid_sha1 = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, StoredProcedures.sha1OfLower(jid));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                if ("none".equals(affil)) {
                    ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id = ? and jid_id = ( select jid_id from tig_pubsub_jids where jid_sha1 = ?)");
                    ps.setLong(1, nodeId);
                    ps.setString(2, StoredProcedures.sha1OfLower(jid));
                    ps.executeUpdate();
                } else {
                    long jidId = StoredProcedures.tigPubSubEnsureJid(jid);
                    ps = conn.prepareStatement("update tig_pubsub_affiliations set affiliation = ? where node_id = ? and jid_id = ?");
                    ps.setString(1, affil);
                    ps.setLong(2, nodeId);
                    ps.setLong(3, jidId);
                    ps.executeUpdate();
                }
            } else {
                if ("none".equals(affil)) {
                    return;
                }
                long jidId = StoredProcedures.tigPubSubEnsureJid(jid);
                ps = conn.prepareStatement("insert into tig_pubsub_affiliations (node_id, jid_id, affiliation) values (?, ?, ?)");
                ps.setLong(1, nodeId);
                ps.setLong(2, jidId);
                ps.setString(3, affil);
                ps.executeUpdate();
            }
        }
    }

    public static void tigPubSubSetNodeConfiguration(Long nodeId, String conf, Long collectionId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_pubsub_nodes set configuration = ?, collection_id = ? where node_id = ?");
            ps.setString(1, conf);
            if (collectionId == null) {
                ps.setNull(2, -5);
            } else {
                ps.setLong(2, collectionId);
            }
            ps.setLong(3, nodeId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubSetNodeSubscription(Long nodeId, String jid, String subscr, String subscrId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            long jidId = StoredProcedures.tigPubSubEnsureJid(jid);
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_pubsub_subscriptions where node_id = ? and jid_id = ?");
            ps.setLong(1, nodeId);
            ps.setLong(2, jidId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ps = conn.prepareStatement("update tig_pubsub_subscriptions set subscription = ? where node_id = ? and jid_id = ?");
                ps.setString(1, subscr);
                ps.setLong(2, nodeId);
                ps.setLong(3, jidId);
                ps.executeUpdate();
            } else {
                ps = conn.prepareStatement("insert into tig_pubsub_subscriptions (node_id, jid_id, subscription, subscription_id) values (?, ?, ?, ?)");
                ps.setLong(1, nodeId);
                ps.setLong(2, jidId);
                ps.setString(3, subscr);
                ps.setString(4, subscrId);
                ps.executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigPubSubWriteItem(Long nodeId, String itemId, String publisher, String itemData, Timestamp ts, String uuid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Class<StoredProcedures> clazz = StoredProcedures.class;
            synchronized (StoredProcedures.class) {
                PreparedStatement ps = conn.prepareStatement("update tig_pubsub_items set update_date = ?, data = ?, uuid = ? where node_id = ? and id = ?");
                ps.setTimestamp(1, ts);
                ps.setString(2, itemData);
                ps.setString(3, uuid);
                ps.setLong(4, nodeId);
                ps.setString(5, itemId);
                int updated = ps.executeUpdate();
                if (updated == 0) {
                    long publisherId = StoredProcedures.tigPubSubEnsureJid(conn, publisher);
                    ps = conn.prepareStatement("insert into tig_pubsub_items (node_id, id, creation_date, update_date, publisher_id, data, uuid) values (?, ?, ?, ?, ?, ?, ?)");
                    ps.setLong(1, nodeId);
                    ps.setString(2, itemId);
                    ps.setTimestamp(3, ts);
                    ps.setTimestamp(4, ts);
                    ps.setLong(5, publisherId);
                    ps.setString(6, itemData);
                    ps.setString(7, uuid);
                    ps.executeUpdate();
                }
                // ** MonitorExit[var8_8] (shouldn't be in output)
            }
        }
        {
            return;
        }
    }

    public static void tigPubSubCountNodes(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = null;
            if (serviceJid == null) {
                ps = conn.prepareStatement("select count(1) from tig_pubsub_nodes");
            } else {
                String serviceJidSha1 = StoredProcedures.sha1OfLower(serviceJid);
                ps = conn.prepareStatement("select count(1) from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid_sha1 = ?)");
                ps.setString(1, serviceJidSha1);
            }
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetServices(String domain, Integer isPublic, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select service_jid, is_public from tig_pubsub_service_jids where domain = ? and (? is null or is_public = ?)");
            ps.setString(1, domain);
            if (isPublic != null) {
                ps.setInt(2, isPublic);
                ps.setInt(3, isPublic);
            } else {
                ps.setNull(2, 4);
                ps.setNull(3, 4);
            }
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubCreateService(String serviceJid, String domain, Integer isPublic, ResultSet[] data) throws SQLException {
        String serviceJidSha1 = StoredProcedures.sha1OfLower(serviceJid);
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("insert into tig_pubsub_service_jids (service_jid, service_jid_sha1, domain, is_public) values (?, ?, ?, ?)", 1);
            ps.setString(1, serviceJid);
            ps.setString(2, serviceJidSha1);
            ps.setString(3, domain);
            ps.setInt(4, isPublic);
            ps.executeUpdate();
        }
    }
}

