/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Date;
import java.util.List;
import tigase.component.exceptions.RepositoryException;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.exceptions.PubSubException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public interface IItems {
    public void deleteItem(String var1) throws RepositoryException;

    public IItem getItem(String var1) throws RepositoryException;

    public String[] getItemsIds(CollectionItemsOrdering var1) throws RepositoryException;

    public String[] getItemsIdsSince(CollectionItemsOrdering var1, Date var2) throws RepositoryException;

    public IItem getLastItem(CollectionItemsOrdering var1) throws RepositoryException;

    public List<ItemMeta> getItemsMeta() throws RepositoryException;

    public void writeItem(String var1, String var2, Element var3, String var4) throws RepositoryException, PubSubException;

    public static interface IListnener {
        public void itemWritten(BareJID var1, String var2, String var3, String var4, Element var5, String var6);

        public void itemDeleted(BareJID var1, String var2, String var3);

        public boolean validateItem(BareJID var1, String var2, String var3, String var4, Element var5) throws PubSubException;
    }

    public static class ItemMeta
    extends ItemBase {
        private final Date creationDate;
        private final Date updateDate;

        public ItemMeta(String node, String id, Date creationDate, Date updateDate, String uuid) {
            super(node, id, uuid);
            this.creationDate = creationDate;
            this.updateDate = updateDate;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public Date getItemUpdateDate() {
            return this.updateDate;
        }
    }

    public static class Item
    extends ItemBase
    implements IItem {
        private final Element item;

        public Item(String node, String id, String uuid, Element item) {
            super(node, id, uuid);
            this.item = item;
        }

        @Override
        public Element getItem() {
            return this.item;
        }
    }

    public static class ItemBase {
        private final String id;
        private final String node;
        private final String uuid;

        protected ItemBase(String node, String id, String uuid) {
            this.node = node;
            this.id = id;
            this.uuid = uuid != null ? uuid.toLowerCase() : null;
        }

        public String getId() {
            return this.id;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getNode() {
            return this.node;
        }
    }

    public static interface IItem
    extends IItemBase {
        public Element getItem();
    }

    public static interface IItemBase {
        public String getId();

        public String getNode();

        public String getUUID();
    }
}

